/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.SlidesLayoutOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Handout layouting options")
public class HandoutLayoutingOptions
extends SlidesLayoutOptions {
    @SerializedName(value="handout", alternate={"Handout"})
    private HandoutEnum handout;
    @SerializedName(value="printSlideNumbers", alternate={"PrintSlideNumbers"})
    private Boolean printSlideNumbers;
    @SerializedName(value="printComments", alternate={"PrintComments"})
    private Boolean printComments;
    @SerializedName(value="printFrameSlide", alternate={"PrintFrameSlide"})
    private Boolean printFrameSlide;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public HandoutLayoutingOptions() {
        this.setLayoutType(SlidesLayoutOptions.LayoutTypeEnum.HANDOUT);
    }

    public HandoutLayoutingOptions handout(HandoutEnum handout) {
        this.handout = handout;
        return this;
    }

    @ApiModelProperty(value="Specified how many pages and in what sequence will be placed on the page.")
    public HandoutEnum getHandout() {
        return this.handout;
    }

    public void setHandout(HandoutEnum handout) {
        this.handout = handout;
    }

    public HandoutLayoutingOptions printSlideNumbers(Boolean printSlideNumbers) {
        this.printSlideNumbers = printSlideNumbers;
        return this;
    }

    @ApiModelProperty(value="True to print the displayed slide numbers.")
    public Boolean isPrintSlideNumbers() {
        return this.printSlideNumbers;
    }

    public void setPrintSlideNumbers(Boolean printSlideNumbers) {
        this.printSlideNumbers = printSlideNumbers;
    }

    public HandoutLayoutingOptions printComments(Boolean printComments) {
        this.printComments = printComments;
        return this;
    }

    @ApiModelProperty(value="True to display comments on slide.")
    public Boolean isPrintComments() {
        return this.printComments;
    }

    public void setPrintComments(Boolean printComments) {
        this.printComments = printComments;
    }

    public HandoutLayoutingOptions printFrameSlide(Boolean printFrameSlide) {
        this.printFrameSlide = printFrameSlide;
        return this;
    }

    @ApiModelProperty(value="True to draw frames around the displayed slides.")
    public Boolean isPrintFrameSlide() {
        return this.printFrameSlide;
    }

    public void setPrintFrameSlide(Boolean printFrameSlide) {
        this.printFrameSlide = printFrameSlide;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandoutLayoutingOptions handoutLayoutingOptions = (HandoutLayoutingOptions)o;
        return Objects.equals((Object)this.handout, (Object)handoutLayoutingOptions.handout) && Objects.equals(this.printSlideNumbers, handoutLayoutingOptions.printSlideNumbers) && Objects.equals(this.printComments, handoutLayoutingOptions.printComments) && Objects.equals(this.printFrameSlide, handoutLayoutingOptions.printFrameSlide) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.handout, this.printSlideNumbers, this.printComments, this.printFrameSlide, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HandoutLayoutingOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    handout: ").append(this.toIndentedString((Object)this.handout)).append("\n");
        sb.append("    printSlideNumbers: ").append(this.toIndentedString(this.printSlideNumbers)).append("\n");
        sb.append("    printComments: ").append(this.toIndentedString(this.printComments)).append("\n");
        sb.append("    printFrameSlide: ").append(this.toIndentedString(this.printFrameSlide)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("LayoutType", (Object)SlidesLayoutOptions.LayoutTypeEnum.HANDOUT);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HandoutEnum {
        HANDOUTS1("Handouts1"),
        HANDOUTS2("Handouts2"),
        HANDOUTS3("Handouts3"),
        HANDOUTS4HORIZONTAL("Handouts4Horizontal"),
        HANDOUTS4VERTICAL("Handouts4Vertical"),
        HANDOUTS6HORIZONTAL("Handouts6Horizontal"),
        HANDOUTS6VERTICAL("Handouts6Vertical"),
        HANDOUTS9HORIZONTAL("Handouts9Horizontal"),
        HANDOUTS9VERTICAL("Handouts9Vertical");

        private String value;

        private HandoutEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HandoutEnum fromValue(String text) {
            for (HandoutEnum b : HandoutEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HandoutEnum> {
            public void write(JsonWriter jsonWriter, HandoutEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HandoutEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HandoutEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

