/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.aspose.slides.model.SlidesLayoutOptions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in Html5 format.")
public class Html5ExportOptions
extends ExportOptions {
    @SerializedName(value="animateTransitions", alternate={"AnimateTransitions"})
    private Boolean animateTransitions;
    @SerializedName(value="animateShapes", alternate={"AnimateShapes"})
    private Boolean animateShapes;
    @SerializedName(value="embedImages", alternate={"EmbedImages"})
    private Boolean embedImages;
    @SerializedName(value="slidesLayoutOptions", alternate={"SlidesLayoutOptions"})
    private SlidesLayoutOptions slidesLayoutOptions;
    @SerializedName(value="templatesPath", alternate={"TemplatesPath"})
    private String templatesPath;
    @SerializedName(value="disableFontLigatures", alternate={"DisableFontLigatures"})
    private Boolean disableFontLigatures;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Html5ExportOptions() {
        this.setFormat("HTML5");
    }

    public Html5ExportOptions animateTransitions(Boolean animateTransitions) {
        this.animateTransitions = animateTransitions;
        return this;
    }

    @ApiModelProperty(value="Gets or sets transitions animation option.")
    public Boolean isAnimateTransitions() {
        return this.animateTransitions;
    }

    public void setAnimateTransitions(Boolean animateTransitions) {
        this.animateTransitions = animateTransitions;
    }

    public Html5ExportOptions animateShapes(Boolean animateShapes) {
        this.animateShapes = animateShapes;
        return this;
    }

    @ApiModelProperty(value="Gets or sets shapes animation option.")
    public Boolean isAnimateShapes() {
        return this.animateShapes;
    }

    public void setAnimateShapes(Boolean animateShapes) {
        this.animateShapes = animateShapes;
    }

    public Html5ExportOptions embedImages(Boolean embedImages) {
        this.embedImages = embedImages;
        return this;
    }

    @ApiModelProperty(value="Gets or sets embed images option.")
    public Boolean isEmbedImages() {
        return this.embedImages;
    }

    public void setEmbedImages(Boolean embedImages) {
        this.embedImages = embedImages;
    }

    public Html5ExportOptions slidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
        return this;
    }

    @ApiModelProperty(value="Slides layouting options")
    public SlidesLayoutOptions getSlidesLayoutOptions() {
        return this.slidesLayoutOptions;
    }

    public void setSlidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
    }

    public Html5ExportOptions templatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
        return this;
    }

    @ApiModelProperty(value="Path to custom templates")
    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }

    public Html5ExportOptions disableFontLigatures(Boolean disableFontLigatures) {
        this.disableFontLigatures = disableFontLigatures;
        return this;
    }

    @ApiModelProperty(value="true to disable ligatures in the rendered output.")
    public Boolean isDisableFontLigatures() {
        return this.disableFontLigatures;
    }

    public void setDisableFontLigatures(Boolean disableFontLigatures) {
        this.disableFontLigatures = disableFontLigatures;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Html5ExportOptions html5ExportOptions = (Html5ExportOptions)o;
        return Objects.equals(this.animateTransitions, html5ExportOptions.animateTransitions) && Objects.equals(this.animateShapes, html5ExportOptions.animateShapes) && Objects.equals(this.embedImages, html5ExportOptions.embedImages) && Objects.equals(this.slidesLayoutOptions, html5ExportOptions.slidesLayoutOptions) && Objects.equals(this.templatesPath, html5ExportOptions.templatesPath) && Objects.equals(this.disableFontLigatures, html5ExportOptions.disableFontLigatures) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.animateTransitions, this.animateShapes, this.embedImages, this.slidesLayoutOptions, this.templatesPath, this.disableFontLigatures, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Html5ExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    animateTransitions: ").append(this.toIndentedString(this.animateTransitions)).append("\n");
        sb.append("    animateShapes: ").append(this.toIndentedString(this.animateShapes)).append("\n");
        sb.append("    embedImages: ").append(this.toIndentedString(this.embedImages)).append("\n");
        sb.append("    slidesLayoutOptions: ").append(this.toIndentedString(this.slidesLayoutOptions)).append("\n");
        sb.append("    templatesPath: ").append(this.toIndentedString(this.templatesPath)).append("\n");
        sb.append("    disableFontLigatures: ").append(this.toIndentedString(this.disableFontLigatures)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

