/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.PathSegment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Line segment of the geometry path")
public class LineToPathSegment
extends PathSegment {
    @SerializedName(value="x", alternate={"X"})
    private Double x;
    @SerializedName(value="y", alternate={"Y"})
    private Double y;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public LineToPathSegment() {
        this.setType(PathSegment.TypeEnum.LINETO);
    }

    public LineToPathSegment x(Double x) {
        this.x = x;
        return this;
    }

    @ApiModelProperty(required=true, value="X coordinate of the end point of the line")
    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public LineToPathSegment y(Double y) {
        this.y = y;
        return this;
    }

    @ApiModelProperty(required=true, value="Y coordinate of the end point of the line")
    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineToPathSegment lineToPathSegment = (LineToPathSegment)o;
        return Objects.equals(this.x, lineToPathSegment.x) && Objects.equals(this.y, lineToPathSegment.y) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineToPathSegment {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)PathSegment.TypeEnum.LINETO);
    }
}

