/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceBase;
import com.aspose.slides.model.ResourceUri;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Master slide.")
public class MasterSlide
extends ResourceBase {
    @SerializedName(value="name", alternate={"Name"})
    private String name;
    @SerializedName(value="layoutSlides", alternate={"LayoutSlides"})
    private List<ResourceUri> layoutSlides = null;
    @SerializedName(value="dependingSlides", alternate={"DependingSlides"})
    private List<ResourceUri> dependingSlides = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public MasterSlide name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MasterSlide layoutSlides(List<ResourceUri> layoutSlides) {
        this.layoutSlides = layoutSlides;
        return this;
    }

    public MasterSlide addLayoutSlidesItem(ResourceUri layoutSlidesItem) {
        if (this.layoutSlides == null) {
            this.layoutSlides = new ArrayList<ResourceUri>();
        }
        this.layoutSlides.add(layoutSlidesItem);
        return this;
    }

    @ApiModelProperty(value="List of layout slide links.")
    public List<ResourceUri> getLayoutSlides() {
        return this.layoutSlides;
    }

    public void setLayoutSlides(List<ResourceUri> layoutSlides) {
        this.layoutSlides = layoutSlides;
    }

    public MasterSlide dependingSlides(List<ResourceUri> dependingSlides) {
        this.dependingSlides = dependingSlides;
        return this;
    }

    public MasterSlide addDependingSlidesItem(ResourceUri dependingSlidesItem) {
        if (this.dependingSlides == null) {
            this.dependingSlides = new ArrayList<ResourceUri>();
        }
        this.dependingSlides.add(dependingSlidesItem);
        return this;
    }

    @ApiModelProperty(value="List of depending slide links.")
    public List<ResourceUri> getDependingSlides() {
        return this.dependingSlides;
    }

    public void setDependingSlides(List<ResourceUri> dependingSlides) {
        this.dependingSlides = dependingSlides;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MasterSlide masterSlide = (MasterSlide)o;
        return Objects.equals(this.name, masterSlide.name) && Objects.equals(this.layoutSlides, masterSlide.layoutSlides) && Objects.equals(this.dependingSlides, masterSlide.dependingSlides) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.layoutSlides, this.dependingSlides, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MasterSlide {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    layoutSlides: ").append(this.toIndentedString(this.layoutSlides)).append("\n");
        sb.append("    dependingSlides: ").append(this.toIndentedString(this.dependingSlides)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

