/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Specifies the Matrix object,")
public class MatrixElement
extends MathElement {
    @SerializedName(value="hidePlaceholders", alternate={"HidePlaceholders"})
    private Boolean hidePlaceholders;
    @SerializedName(value="baseJustification", alternate={"BaseJustification"})
    private BaseJustificationEnum baseJustification;
    @SerializedName(value="minColumnWidth", alternate={"MinColumnWidth"})
    private Integer minColumnWidth;
    @SerializedName(value="columnGapRule", alternate={"ColumnGapRule"})
    private ColumnGapRuleEnum columnGapRule;
    @SerializedName(value="columnGap", alternate={"ColumnGap"})
    private Integer columnGap;
    @SerializedName(value="rowGapRule", alternate={"RowGapRule"})
    private RowGapRuleEnum rowGapRule;
    @SerializedName(value="rowGap", alternate={"RowGap"})
    private Integer rowGap;
    @SerializedName(value="items", alternate={"Items"})
    private List<List<MathElement>> items = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public MatrixElement() {
        this.setType(MathElement.TypeEnum.MATRIX);
    }

    public MatrixElement hidePlaceholders(Boolean hidePlaceholders) {
        this.hidePlaceholders = hidePlaceholders;
        return this;
    }

    @ApiModelProperty(value="Hide the placeholders for empty matrix elements")
    public Boolean isHidePlaceholders() {
        return this.hidePlaceholders;
    }

    public void setHidePlaceholders(Boolean hidePlaceholders) {
        this.hidePlaceholders = hidePlaceholders;
    }

    public MatrixElement baseJustification(BaseJustificationEnum baseJustification) {
        this.baseJustification = baseJustification;
        return this;
    }

    @ApiModelProperty(value="Specifies the vertical justification respect to surrounding text. ")
    public BaseJustificationEnum getBaseJustification() {
        return this.baseJustification;
    }

    public void setBaseJustification(BaseJustificationEnum baseJustification) {
        this.baseJustification = baseJustification;
    }

    public MatrixElement minColumnWidth(Integer minColumnWidth) {
        this.minColumnWidth = minColumnWidth;
        return this;
    }

    @ApiModelProperty(value="Minimum column width in twips (1/20th of a point)")
    public Integer getMinColumnWidth() {
        return this.minColumnWidth;
    }

    public void setMinColumnWidth(Integer minColumnWidth) {
        this.minColumnWidth = minColumnWidth;
    }

    public MatrixElement columnGapRule(ColumnGapRuleEnum columnGapRule) {
        this.columnGapRule = columnGapRule;
        return this;
    }

    @ApiModelProperty(value="The type of horizontal spacing between columns of a matrix.")
    public ColumnGapRuleEnum getColumnGapRule() {
        return this.columnGapRule;
    }

    public void setColumnGapRule(ColumnGapRuleEnum columnGapRule) {
        this.columnGapRule = columnGapRule;
    }

    public MatrixElement columnGap(Integer columnGap) {
        this.columnGap = columnGap;
        return this;
    }

    @ApiModelProperty(value="The value of horizontal spacing between columns of a matrix")
    public Integer getColumnGap() {
        return this.columnGap;
    }

    public void setColumnGap(Integer columnGap) {
        this.columnGap = columnGap;
    }

    public MatrixElement rowGapRule(RowGapRuleEnum rowGapRule) {
        this.rowGapRule = rowGapRule;
        return this;
    }

    @ApiModelProperty(value="The type of vertical spacing between rows of a matrix")
    public RowGapRuleEnum getRowGapRule() {
        return this.rowGapRule;
    }

    public void setRowGapRule(RowGapRuleEnum rowGapRule) {
        this.rowGapRule = rowGapRule;
    }

    public MatrixElement rowGap(Integer rowGap) {
        this.rowGap = rowGap;
        return this;
    }

    @ApiModelProperty(value="The value of vertical spacing between rows of a matrix;             ")
    public Integer getRowGap() {
        return this.rowGap;
    }

    public void setRowGap(Integer rowGap) {
        this.rowGap = rowGap;
    }

    public MatrixElement items(List<List<MathElement>> items) {
        this.items = items;
        return this;
    }

    public MatrixElement addItemsItem(List<MathElement> itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<List<MathElement>>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="Matrix items")
    public List<List<MathElement>> getItems() {
        return this.items;
    }

    public void setItems(List<List<MathElement>> items) {
        this.items = items;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatrixElement matrixElement = (MatrixElement)o;
        return Objects.equals(this.hidePlaceholders, matrixElement.hidePlaceholders) && Objects.equals((Object)this.baseJustification, (Object)matrixElement.baseJustification) && Objects.equals(this.minColumnWidth, matrixElement.minColumnWidth) && Objects.equals((Object)this.columnGapRule, (Object)matrixElement.columnGapRule) && Objects.equals(this.columnGap, matrixElement.columnGap) && Objects.equals((Object)this.rowGapRule, (Object)matrixElement.rowGapRule) && Objects.equals(this.rowGap, matrixElement.rowGap) && Objects.equals(this.items, matrixElement.items) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.hidePlaceholders, this.baseJustification, this.minColumnWidth, this.columnGapRule, this.columnGap, this.rowGapRule, this.rowGap, this.items, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatrixElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    hidePlaceholders: ").append(this.toIndentedString(this.hidePlaceholders)).append("\n");
        sb.append("    baseJustification: ").append(this.toIndentedString((Object)this.baseJustification)).append("\n");
        sb.append("    minColumnWidth: ").append(this.toIndentedString(this.minColumnWidth)).append("\n");
        sb.append("    columnGapRule: ").append(this.toIndentedString((Object)this.columnGapRule)).append("\n");
        sb.append("    columnGap: ").append(this.toIndentedString(this.columnGap)).append("\n");
        sb.append("    rowGapRule: ").append(this.toIndentedString((Object)this.rowGapRule)).append("\n");
        sb.append("    rowGap: ").append(this.toIndentedString(this.rowGap)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.MATRIX);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RowGapRuleEnum {
        SINGLESPACINGGAP("SingleSpacingGap"),
        ONEANDHALFSPACINGGAP("OneAndHalfSpacingGap"),
        DOUBLESPACINGGAP("DoubleSpacingGap"),
        EXACTLY("Exactly"),
        MULTIPLE("Multiple");

        private String value;

        private RowGapRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RowGapRuleEnum fromValue(String text) {
            for (RowGapRuleEnum b : RowGapRuleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RowGapRuleEnum> {
            public void write(JsonWriter jsonWriter, RowGapRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RowGapRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RowGapRuleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ColumnGapRuleEnum {
        SINGLESPACINGGAP("SingleSpacingGap"),
        ONEANDHALFSPACINGGAP("OneAndHalfSpacingGap"),
        DOUBLESPACINGGAP("DoubleSpacingGap"),
        EXACTLY("Exactly"),
        MULTIPLE("Multiple");

        private String value;

        private ColumnGapRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ColumnGapRuleEnum fromValue(String text) {
            for (ColumnGapRuleEnum b : ColumnGapRuleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ColumnGapRuleEnum> {
            public void write(JsonWriter jsonWriter, ColumnGapRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ColumnGapRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ColumnGapRuleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BaseJustificationEnum {
        NOTDEFINED("NotDefined"),
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom");

        private String value;

        private BaseJustificationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BaseJustificationEnum fromValue(String text) {
            for (BaseJustificationEnum b : BaseJustificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BaseJustificationEnum> {
            public void write(JsonWriter jsonWriter, BaseJustificationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BaseJustificationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BaseJustificationEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

