/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MergingSource;
import com.aspose.slides.model.Task;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Merge presentations task.")
public class Merge
extends Task {
    @SerializedName(value="presentations", alternate={"Presentations"})
    private List<MergingSource> presentations = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Merge() {
        this.setType(Task.TypeEnum.MERGE);
    }

    public Merge presentations(List<MergingSource> presentations) {
        this.presentations = presentations;
        return this;
    }

    public Merge addPresentationsItem(MergingSource presentationsItem) {
        if (this.presentations == null) {
            this.presentations = new ArrayList<MergingSource>();
        }
        this.presentations.add(presentationsItem);
        return this;
    }

    @ApiModelProperty(value="Information about documents and slides being merging sources.")
    public List<MergingSource> getPresentations() {
        return this.presentations;
    }

    public void setPresentations(List<MergingSource> presentations) {
        this.presentations = presentations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Merge merge = (Merge)o;
        return Objects.equals(this.presentations, merge.presentations) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.presentations, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Merge {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    presentations: ").append(this.toIndentedString(this.presentations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)Task.TypeEnum.MERGE);
    }
}

