/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.SlidesLayoutOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Notes &amp; comments layouting options.")
public class NotesCommentsLayoutingOptions
extends SlidesLayoutOptions {
    @SerializedName(value="notesPosition", alternate={"NotesPosition"})
    private NotesPositionEnum notesPosition;
    @SerializedName(value="commentsPosition", alternate={"CommentsPosition"})
    private CommentsPositionEnum commentsPosition;
    @SerializedName(value="commentsAreaWidth", alternate={"CommentsAreaWidth"})
    private Integer commentsAreaWidth;
    @SerializedName(value="commentsAreaColor", alternate={"CommentsAreaColor"})
    private String commentsAreaColor;
    @SerializedName(value="showCommentsByNoAuthor", alternate={"ShowCommentsByNoAuthor"})
    private Boolean showCommentsByNoAuthor;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public NotesCommentsLayoutingOptions() {
        this.setLayoutType(SlidesLayoutOptions.LayoutTypeEnum.NOTESCOMMENTS);
    }

    public NotesCommentsLayoutingOptions notesPosition(NotesPositionEnum notesPosition) {
        this.notesPosition = notesPosition;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the position of the notes on the page.")
    public NotesPositionEnum getNotesPosition() {
        return this.notesPosition;
    }

    public void setNotesPosition(NotesPositionEnum notesPosition) {
        this.notesPosition = notesPosition;
    }

    public NotesCommentsLayoutingOptions commentsPosition(CommentsPositionEnum commentsPosition) {
        this.commentsPosition = commentsPosition;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the position of the comments on the page.")
    public CommentsPositionEnum getCommentsPosition() {
        return this.commentsPosition;
    }

    public void setCommentsPosition(CommentsPositionEnum commentsPosition) {
        this.commentsPosition = commentsPosition;
    }

    public NotesCommentsLayoutingOptions commentsAreaWidth(Integer commentsAreaWidth) {
        this.commentsAreaWidth = commentsAreaWidth;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the width of the comment output area in pixels (Applies only if comments are displayed on the right).")
    public Integer getCommentsAreaWidth() {
        return this.commentsAreaWidth;
    }

    public void setCommentsAreaWidth(Integer commentsAreaWidth) {
        this.commentsAreaWidth = commentsAreaWidth;
    }

    public NotesCommentsLayoutingOptions commentsAreaColor(String commentsAreaColor) {
        this.commentsAreaColor = commentsAreaColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the color of comments area (Applies only if comments are displayed on the right).")
    public String getCommentsAreaColor() {
        return this.commentsAreaColor;
    }

    public void setCommentsAreaColor(String commentsAreaColor) {
        this.commentsAreaColor = commentsAreaColor;
    }

    public NotesCommentsLayoutingOptions showCommentsByNoAuthor(Boolean showCommentsByNoAuthor) {
        this.showCommentsByNoAuthor = showCommentsByNoAuthor;
        return this;
    }

    @ApiModelProperty(value="True if comments that have no author are displayed. (Applies only if comments are displayed).")
    public Boolean isShowCommentsByNoAuthor() {
        return this.showCommentsByNoAuthor;
    }

    public void setShowCommentsByNoAuthor(Boolean showCommentsByNoAuthor) {
        this.showCommentsByNoAuthor = showCommentsByNoAuthor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotesCommentsLayoutingOptions notesCommentsLayoutingOptions = (NotesCommentsLayoutingOptions)o;
        return Objects.equals((Object)this.notesPosition, (Object)notesCommentsLayoutingOptions.notesPosition) && Objects.equals((Object)this.commentsPosition, (Object)notesCommentsLayoutingOptions.commentsPosition) && Objects.equals(this.commentsAreaWidth, notesCommentsLayoutingOptions.commentsAreaWidth) && Objects.equals(this.commentsAreaColor, notesCommentsLayoutingOptions.commentsAreaColor) && Objects.equals(this.showCommentsByNoAuthor, notesCommentsLayoutingOptions.showCommentsByNoAuthor) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.notesPosition, this.commentsPosition, this.commentsAreaWidth, this.commentsAreaColor, this.showCommentsByNoAuthor, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotesCommentsLayoutingOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    notesPosition: ").append(this.toIndentedString((Object)this.notesPosition)).append("\n");
        sb.append("    commentsPosition: ").append(this.toIndentedString((Object)this.commentsPosition)).append("\n");
        sb.append("    commentsAreaWidth: ").append(this.toIndentedString(this.commentsAreaWidth)).append("\n");
        sb.append("    commentsAreaColor: ").append(this.toIndentedString(this.commentsAreaColor)).append("\n");
        sb.append("    showCommentsByNoAuthor: ").append(this.toIndentedString(this.showCommentsByNoAuthor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("LayoutType", (Object)SlidesLayoutOptions.LayoutTypeEnum.NOTESCOMMENTS);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CommentsPositionEnum {
        NONE("None"),
        BOTTOM("Bottom"),
        RIGHT("Right");

        private String value;

        private CommentsPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CommentsPositionEnum fromValue(String text) {
            for (CommentsPositionEnum b : CommentsPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CommentsPositionEnum> {
            public void write(JsonWriter jsonWriter, CommentsPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CommentsPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CommentsPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NotesPositionEnum {
        NONE("None"),
        BOTTOMFULL("BottomFull"),
        BOTTOMTRUNCATED("BottomTruncated");

        private String value;

        private NotesPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NotesPositionEnum fromValue(String text) {
            for (NotesPositionEnum b : NotesPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NotesPositionEnum> {
            public void write(JsonWriter jsonWriter, NotesPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NotesPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NotesPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

