/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.DataPoint;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="One value chart data point.")
public class OneValueChartDataPoint
extends DataPoint {
    @SerializedName(value="value", alternate={"Value"})
    private Double value;
    @SerializedName(value="valueFormula", alternate={"ValueFormula"})
    private String valueFormula;
    @SerializedName(value="setAsTotal", alternate={"SetAsTotal"})
    private Boolean setAsTotal;
    @SerializedName(value="invertIfNegative", alternate={"InvertIfNegative"})
    private Boolean invertIfNegative;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public OneValueChartDataPoint() {
        this.setType(DataPoint.TypeEnum.ONEVALUE);
    }

    public OneValueChartDataPoint value(Double value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Value.")
    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public OneValueChartDataPoint valueFormula(String valueFormula) {
        this.valueFormula = valueFormula;
        return this;
    }

    @ApiModelProperty(value="Spreadsheet formula in A1-style.")
    public String getValueFormula() {
        return this.valueFormula;
    }

    public void setValueFormula(String valueFormula) {
        this.valueFormula = valueFormula;
    }

    public OneValueChartDataPoint setAsTotal(Boolean setAsTotal) {
        this.setAsTotal = setAsTotal;
        return this;
    }

    @ApiModelProperty(value="SetAsTotal. Applied to Waterfall data points only.")
    public Boolean isSetAsTotal() {
        return this.setAsTotal;
    }

    public void setSetAsTotal(Boolean setAsTotal) {
        this.setAsTotal = setAsTotal;
    }

    public OneValueChartDataPoint invertIfNegative(Boolean invertIfNegative) {
        this.invertIfNegative = invertIfNegative;
        return this;
    }

    @ApiModelProperty(value="True if the data point shall invert its colors if the value is negative. Applies to bar, column and bubble series.")
    public Boolean isInvertIfNegative() {
        return this.invertIfNegative;
    }

    public void setInvertIfNegative(Boolean invertIfNegative) {
        this.invertIfNegative = invertIfNegative;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneValueChartDataPoint oneValueChartDataPoint = (OneValueChartDataPoint)o;
        return Objects.equals(this.value, oneValueChartDataPoint.value) && Objects.equals(this.valueFormula, oneValueChartDataPoint.valueFormula) && Objects.equals(this.setAsTotal, oneValueChartDataPoint.setAsTotal) && Objects.equals(this.invertIfNegative, oneValueChartDataPoint.invertIfNegative) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.valueFormula, this.setAsTotal, this.invertIfNegative, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OneValueChartDataPoint {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueFormula: ").append(this.toIndentedString(this.valueFormula)).append("\n");
        sb.append("    setAsTotal: ").append(this.toIndentedString(this.setAsTotal)).append("\n");
        sb.append("    invertIfNegative: ").append(this.toIndentedString(this.invertIfNegative)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)DataPoint.TypeEnum.ONEVALUE);
    }
}

