/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.DataSource;
import com.aspose.slides.model.OneValueChartDataPoint;
import com.aspose.slides.model.Series;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="One value series.")
public class OneValueSeries
extends Series {
    @SerializedName(value="dataPoints", alternate={"DataPoints"})
    private List<OneValueChartDataPoint> dataPoints = null;
    @SerializedName(value="numberFormatOfValues", alternate={"NumberFormatOfValues"})
    private String numberFormatOfValues;
    @SerializedName(value="dataSourceForValues", alternate={"DataSourceForValues"})
    private DataSource dataSourceForValues;
    @SerializedName(value="showConnectorLines", alternate={"ShowConnectorLines"})
    private Boolean showConnectorLines;
    @SerializedName(value="quartileMethod", alternate={"QuartileMethod"})
    private QuartileMethodEnum quartileMethod;
    @SerializedName(value="showInnerPoints", alternate={"ShowInnerPoints"})
    private Boolean showInnerPoints;
    @SerializedName(value="showMeanLine", alternate={"ShowMeanLine"})
    private Boolean showMeanLine;
    @SerializedName(value="showMeanMarkers", alternate={"ShowMeanMarkers"})
    private Boolean showMeanMarkers;
    @SerializedName(value="showOutlierPoints", alternate={"ShowOutlierPoints"})
    private Boolean showOutlierPoints;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public OneValueSeries() {
        this.setDataPointType(Series.DataPointTypeEnum.ONEVALUE);
    }

    public OneValueSeries dataPoints(List<OneValueChartDataPoint> dataPoints) {
        this.dataPoints = dataPoints;
        return this;
    }

    public OneValueSeries addDataPointsItem(OneValueChartDataPoint dataPointsItem) {
        if (this.dataPoints == null) {
            this.dataPoints = new ArrayList<OneValueChartDataPoint>();
        }
        this.dataPoints.add(dataPointsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the values.")
    public List<OneValueChartDataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public void setDataPoints(List<OneValueChartDataPoint> dataPoints) {
        this.dataPoints = dataPoints;
    }

    public OneValueSeries numberFormatOfValues(String numberFormatOfValues) {
        this.numberFormatOfValues = numberFormatOfValues;
        return this;
    }

    @ApiModelProperty(value="The number format for the series values.")
    public String getNumberFormatOfValues() {
        return this.numberFormatOfValues;
    }

    public void setNumberFormatOfValues(String numberFormatOfValues) {
        this.numberFormatOfValues = numberFormatOfValues;
    }

    public OneValueSeries dataSourceForValues(DataSource dataSourceForValues) {
        this.dataSourceForValues = dataSourceForValues;
        return this;
    }

    @ApiModelProperty(value="Data source type for values.")
    public DataSource getDataSourceForValues() {
        return this.dataSourceForValues;
    }

    public void setDataSourceForValues(DataSource dataSourceForValues) {
        this.dataSourceForValues = dataSourceForValues;
    }

    public OneValueSeries showConnectorLines(Boolean showConnectorLines) {
        this.showConnectorLines = showConnectorLines;
        return this;
    }

    @ApiModelProperty(value="True if inner points are shown. Applied to Waterfall series only.")
    public Boolean isShowConnectorLines() {
        return this.showConnectorLines;
    }

    public void setShowConnectorLines(Boolean showConnectorLines) {
        this.showConnectorLines = showConnectorLines;
    }

    public OneValueSeries quartileMethod(QuartileMethodEnum quartileMethod) {
        this.quartileMethod = quartileMethod;
        return this;
    }

    @ApiModelProperty(value="Quartile method. Applied to BoxAndWhisker series only.")
    public QuartileMethodEnum getQuartileMethod() {
        return this.quartileMethod;
    }

    public void setQuartileMethod(QuartileMethodEnum quartileMethod) {
        this.quartileMethod = quartileMethod;
    }

    public OneValueSeries showInnerPoints(Boolean showInnerPoints) {
        this.showInnerPoints = showInnerPoints;
        return this;
    }

    @ApiModelProperty(value="True if inner points are shown. Applied to BoxAndWhisker series only.")
    public Boolean isShowInnerPoints() {
        return this.showInnerPoints;
    }

    public void setShowInnerPoints(Boolean showInnerPoints) {
        this.showInnerPoints = showInnerPoints;
    }

    public OneValueSeries showMeanLine(Boolean showMeanLine) {
        this.showMeanLine = showMeanLine;
        return this;
    }

    @ApiModelProperty(value="True if mean line is shown. Applied to BoxAndWhisker series only.")
    public Boolean isShowMeanLine() {
        return this.showMeanLine;
    }

    public void setShowMeanLine(Boolean showMeanLine) {
        this.showMeanLine = showMeanLine;
    }

    public OneValueSeries showMeanMarkers(Boolean showMeanMarkers) {
        this.showMeanMarkers = showMeanMarkers;
        return this;
    }

    @ApiModelProperty(value="True if mean markers are shown. Applied to BoxAndWhisker series only.")
    public Boolean isShowMeanMarkers() {
        return this.showMeanMarkers;
    }

    public void setShowMeanMarkers(Boolean showMeanMarkers) {
        this.showMeanMarkers = showMeanMarkers;
    }

    public OneValueSeries showOutlierPoints(Boolean showOutlierPoints) {
        this.showOutlierPoints = showOutlierPoints;
        return this;
    }

    @ApiModelProperty(value="True if outlier points are shown. Applied to BoxAndWhisker series only.")
    public Boolean isShowOutlierPoints() {
        return this.showOutlierPoints;
    }

    public void setShowOutlierPoints(Boolean showOutlierPoints) {
        this.showOutlierPoints = showOutlierPoints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneValueSeries oneValueSeries = (OneValueSeries)o;
        return Objects.equals(this.dataPoints, oneValueSeries.dataPoints) && Objects.equals(this.numberFormatOfValues, oneValueSeries.numberFormatOfValues) && Objects.equals(this.dataSourceForValues, oneValueSeries.dataSourceForValues) && Objects.equals(this.showConnectorLines, oneValueSeries.showConnectorLines) && Objects.equals((Object)this.quartileMethod, (Object)oneValueSeries.quartileMethod) && Objects.equals(this.showInnerPoints, oneValueSeries.showInnerPoints) && Objects.equals(this.showMeanLine, oneValueSeries.showMeanLine) && Objects.equals(this.showMeanMarkers, oneValueSeries.showMeanMarkers) && Objects.equals(this.showOutlierPoints, oneValueSeries.showOutlierPoints) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.dataPoints, this.numberFormatOfValues, this.dataSourceForValues, this.showConnectorLines, this.quartileMethod, this.showInnerPoints, this.showMeanLine, this.showMeanMarkers, this.showOutlierPoints, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OneValueSeries {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    dataPoints: ").append(this.toIndentedString(this.dataPoints)).append("\n");
        sb.append("    numberFormatOfValues: ").append(this.toIndentedString(this.numberFormatOfValues)).append("\n");
        sb.append("    dataSourceForValues: ").append(this.toIndentedString(this.dataSourceForValues)).append("\n");
        sb.append("    showConnectorLines: ").append(this.toIndentedString(this.showConnectorLines)).append("\n");
        sb.append("    quartileMethod: ").append(this.toIndentedString((Object)this.quartileMethod)).append("\n");
        sb.append("    showInnerPoints: ").append(this.toIndentedString(this.showInnerPoints)).append("\n");
        sb.append("    showMeanLine: ").append(this.toIndentedString(this.showMeanLine)).append("\n");
        sb.append("    showMeanMarkers: ").append(this.toIndentedString(this.showMeanMarkers)).append("\n");
        sb.append("    showOutlierPoints: ").append(this.toIndentedString(this.showOutlierPoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("DataPointType", (Object)Series.DataPointTypeEnum.ONEVALUE);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum QuartileMethodEnum {
        EXCLUSIVE("Exclusive"),
        INCLUSIVE("Inclusive");

        private String value;

        private QuartileMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static QuartileMethodEnum fromValue(String text) {
            for (QuartileMethodEnum b : QuartileMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<QuartileMethodEnum> {
            public void write(JsonWriter jsonWriter, QuartileMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public QuartileMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return QuartileMethodEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

