/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.AccessPermissions;
import com.aspose.slides.model.ExportOptions;
import com.aspose.slides.model.SlidesLayoutOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in Pdf format.")
public class PdfExportOptions
extends ExportOptions {
    @SerializedName(value="textCompression", alternate={"TextCompression"})
    private TextCompressionEnum textCompression;
    @SerializedName(value="embedFullFonts", alternate={"EmbedFullFonts"})
    private Boolean embedFullFonts;
    @SerializedName(value="compliance", alternate={"Compliance"})
    private ComplianceEnum compliance;
    @SerializedName(value="sufficientResolution", alternate={"SufficientResolution"})
    private Double sufficientResolution;
    @SerializedName(value="jpegQuality", alternate={"JpegQuality"})
    private Integer jpegQuality;
    @SerializedName(value="drawSlidesFrame", alternate={"DrawSlidesFrame"})
    private Boolean drawSlidesFrame;
    @SerializedName(value="showHiddenSlides", alternate={"ShowHiddenSlides"})
    private Boolean showHiddenSlides;
    @SerializedName(value="saveMetafilesAsPng", alternate={"SaveMetafilesAsPng"})
    private Boolean saveMetafilesAsPng;
    @SerializedName(value="password", alternate={"Password"})
    private String password;
    @SerializedName(value="embedTrueTypeFontsForASCII", alternate={"EmbedTrueTypeFontsForASCII"})
    private Boolean embedTrueTypeFontsForASCII;
    @SerializedName(value="additionalCommonFontFamilies", alternate={"AdditionalCommonFontFamilies"})
    private List<String> additionalCommonFontFamilies = null;
    @SerializedName(value="slidesLayoutOptions", alternate={"SlidesLayoutOptions"})
    private SlidesLayoutOptions slidesLayoutOptions;
    @SerializedName(value="imageTransparentColor", alternate={"ImageTransparentColor"})
    private String imageTransparentColor;
    @SerializedName(value="applyImageTransparent", alternate={"ApplyImageTransparent"})
    private Boolean applyImageTransparent;
    @SerializedName(value="accessPermissions", alternate={"AccessPermissions"})
    private AccessPermissions accessPermissions;
    @SerializedName(value="hideInk", alternate={"HideInk"})
    private Boolean hideInk;
    @SerializedName(value="interpretMaskOpAsOpacity", alternate={"InterpretMaskOpAsOpacity"})
    private Boolean interpretMaskOpAsOpacity;
    @SerializedName(value="rasterizeUnsupportedFontStyles", alternate={"RasterizeUnsupportedFontStyles"})
    private Boolean rasterizeUnsupportedFontStyles;
    @SerializedName(value="includeOleData", alternate={"IncludeOleData"})
    private Boolean includeOleData;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public PdfExportOptions() {
        this.setFormat("PDF");
    }

    public PdfExportOptions textCompression(TextCompressionEnum textCompression) {
        this.textCompression = textCompression;
        return this;
    }

    @ApiModelProperty(value="Specifies compression type to be used for all textual content in the document.")
    public TextCompressionEnum getTextCompression() {
        return this.textCompression;
    }

    public void setTextCompression(TextCompressionEnum textCompression) {
        this.textCompression = textCompression;
    }

    public PdfExportOptions embedFullFonts(Boolean embedFullFonts) {
        this.embedFullFonts = embedFullFonts;
        return this;
    }

    @ApiModelProperty(value="Determines if all characters of font should be embedded or only used subset.")
    public Boolean isEmbedFullFonts() {
        return this.embedFullFonts;
    }

    public void setEmbedFullFonts(Boolean embedFullFonts) {
        this.embedFullFonts = embedFullFonts;
    }

    public PdfExportOptions compliance(ComplianceEnum compliance) {
        this.compliance = compliance;
        return this;
    }

    @ApiModelProperty(value="Desired conformance level for generated PDF document.")
    public ComplianceEnum getCompliance() {
        return this.compliance;
    }

    public void setCompliance(ComplianceEnum compliance) {
        this.compliance = compliance;
    }

    public PdfExportOptions sufficientResolution(Double sufficientResolution) {
        this.sufficientResolution = sufficientResolution;
        return this;
    }

    @ApiModelProperty(value="Returns or sets a value determining resolution of images inside PDF document.  Property affects on file size, time of export and image quality. The default value is 96.")
    public Double getSufficientResolution() {
        return this.sufficientResolution;
    }

    public void setSufficientResolution(Double sufficientResolution) {
        this.sufficientResolution = sufficientResolution;
    }

    public PdfExportOptions jpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
        return this;
    }

    @ApiModelProperty(value="Returns or sets a value determining the quality of the JPEG images inside PDF document.")
    public Integer getJpegQuality() {
        return this.jpegQuality;
    }

    public void setJpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public PdfExportOptions drawSlidesFrame(Boolean drawSlidesFrame) {
        this.drawSlidesFrame = drawSlidesFrame;
        return this;
    }

    @ApiModelProperty(value="True to draw black frame around each slide.")
    public Boolean isDrawSlidesFrame() {
        return this.drawSlidesFrame;
    }

    public void setDrawSlidesFrame(Boolean drawSlidesFrame) {
        this.drawSlidesFrame = drawSlidesFrame;
    }

    public PdfExportOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should include hidden slides or not. Default is false. ")
    public Boolean isShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    public PdfExportOptions saveMetafilesAsPng(Boolean saveMetafilesAsPng) {
        this.saveMetafilesAsPng = saveMetafilesAsPng;
        return this;
    }

    @ApiModelProperty(value="True to convert all metafiles used in a presentation to the PNG images.")
    public Boolean isSaveMetafilesAsPng() {
        return this.saveMetafilesAsPng;
    }

    public void setSaveMetafilesAsPng(Boolean saveMetafilesAsPng) {
        this.saveMetafilesAsPng = saveMetafilesAsPng;
    }

    public PdfExportOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Setting user password to protect the PDF document. ")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PdfExportOptions embedTrueTypeFontsForASCII(Boolean embedTrueTypeFontsForASCII) {
        this.embedTrueTypeFontsForASCII = embedTrueTypeFontsForASCII;
        return this;
    }

    @ApiModelProperty(value="Determines if Aspose.Slides will embed common fonts for ASCII (33..127 code range) text. Fonts for character codes greater than 127 are always embedded. Common fonts list includes PDF's base 14 fonts and additional user specified fonts.")
    public Boolean isEmbedTrueTypeFontsForASCII() {
        return this.embedTrueTypeFontsForASCII;
    }

    public void setEmbedTrueTypeFontsForASCII(Boolean embedTrueTypeFontsForASCII) {
        this.embedTrueTypeFontsForASCII = embedTrueTypeFontsForASCII;
    }

    public PdfExportOptions additionalCommonFontFamilies(List<String> additionalCommonFontFamilies) {
        this.additionalCommonFontFamilies = additionalCommonFontFamilies;
        return this;
    }

    public PdfExportOptions addAdditionalCommonFontFamiliesItem(String additionalCommonFontFamiliesItem) {
        if (this.additionalCommonFontFamilies == null) {
            this.additionalCommonFontFamilies = new ArrayList<String>();
        }
        this.additionalCommonFontFamilies.add(additionalCommonFontFamiliesItem);
        return this;
    }

    @ApiModelProperty(value="Returns or sets an array of user-defined names of font families which Aspose.Slides should consider common.")
    public List<String> getAdditionalCommonFontFamilies() {
        return this.additionalCommonFontFamilies;
    }

    public void setAdditionalCommonFontFamilies(List<String> additionalCommonFontFamilies) {
        this.additionalCommonFontFamilies = additionalCommonFontFamilies;
    }

    public PdfExportOptions slidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
        return this;
    }

    @ApiModelProperty(value="Slides layouting options")
    public SlidesLayoutOptions getSlidesLayoutOptions() {
        return this.slidesLayoutOptions;
    }

    public void setSlidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
    }

    public PdfExportOptions imageTransparentColor(String imageTransparentColor) {
        this.imageTransparentColor = imageTransparentColor;
        return this;
    }

    @ApiModelProperty(value="Image transparent color.")
    public String getImageTransparentColor() {
        return this.imageTransparentColor;
    }

    public void setImageTransparentColor(String imageTransparentColor) {
        this.imageTransparentColor = imageTransparentColor;
    }

    public PdfExportOptions applyImageTransparent(Boolean applyImageTransparent) {
        this.applyImageTransparent = applyImageTransparent;
        return this;
    }

    @ApiModelProperty(value="True to apply specified ImageTransparentColor  to an image.")
    public Boolean isApplyImageTransparent() {
        return this.applyImageTransparent;
    }

    public void setApplyImageTransparent(Boolean applyImageTransparent) {
        this.applyImageTransparent = applyImageTransparent;
    }

    public PdfExportOptions accessPermissions(AccessPermissions accessPermissions) {
        this.accessPermissions = accessPermissions;
        return this;
    }

    @ApiModelProperty(value="Access permissions that should be granted when the document is opened with user access.  Default is AccessPermissions.None.             ")
    public AccessPermissions getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(AccessPermissions accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public PdfExportOptions hideInk(Boolean hideInk) {
        this.hideInk = hideInk;
        return this;
    }

    @ApiModelProperty(value="True to hide Ink elements in exported document.")
    public Boolean isHideInk() {
        return this.hideInk;
    }

    public void setHideInk(Boolean hideInk) {
        this.hideInk = hideInk;
    }

    public PdfExportOptions interpretMaskOpAsOpacity(Boolean interpretMaskOpAsOpacity) {
        this.interpretMaskOpAsOpacity = interpretMaskOpAsOpacity;
        return this;
    }

    @ApiModelProperty(value="True to use ROP operation or Opacity for rendering brush.")
    public Boolean isInterpretMaskOpAsOpacity() {
        return this.interpretMaskOpAsOpacity;
    }

    public void setInterpretMaskOpAsOpacity(Boolean interpretMaskOpAsOpacity) {
        this.interpretMaskOpAsOpacity = interpretMaskOpAsOpacity;
    }

    public PdfExportOptions rasterizeUnsupportedFontStyles(Boolean rasterizeUnsupportedFontStyles) {
        this.rasterizeUnsupportedFontStyles = rasterizeUnsupportedFontStyles;
        return this;
    }

    @ApiModelProperty(value="True if text should be rasterized as a bitmap and saved to PDF when the font does not support bold styling. This approach can enhance the quality of text in the resulting PDF for certain fonts.")
    public Boolean isRasterizeUnsupportedFontStyles() {
        return this.rasterizeUnsupportedFontStyles;
    }

    public void setRasterizeUnsupportedFontStyles(Boolean rasterizeUnsupportedFontStyles) {
        this.rasterizeUnsupportedFontStyles = rasterizeUnsupportedFontStyles;
    }

    public PdfExportOptions includeOleData(Boolean includeOleData) {
        this.includeOleData = includeOleData;
        return this;
    }

    @ApiModelProperty(value="True to convert all OLE data from the presentation to embedded files in the resulting PDF.")
    public Boolean isIncludeOleData() {
        return this.includeOleData;
    }

    public void setIncludeOleData(Boolean includeOleData) {
        this.includeOleData = includeOleData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfExportOptions pdfExportOptions = (PdfExportOptions)o;
        return Objects.equals((Object)this.textCompression, (Object)pdfExportOptions.textCompression) && Objects.equals(this.embedFullFonts, pdfExportOptions.embedFullFonts) && Objects.equals((Object)this.compliance, (Object)pdfExportOptions.compliance) && Objects.equals(this.sufficientResolution, pdfExportOptions.sufficientResolution) && Objects.equals(this.jpegQuality, pdfExportOptions.jpegQuality) && Objects.equals(this.drawSlidesFrame, pdfExportOptions.drawSlidesFrame) && Objects.equals(this.showHiddenSlides, pdfExportOptions.showHiddenSlides) && Objects.equals(this.saveMetafilesAsPng, pdfExportOptions.saveMetafilesAsPng) && Objects.equals(this.password, pdfExportOptions.password) && Objects.equals(this.embedTrueTypeFontsForASCII, pdfExportOptions.embedTrueTypeFontsForASCII) && Objects.equals(this.additionalCommonFontFamilies, pdfExportOptions.additionalCommonFontFamilies) && Objects.equals(this.slidesLayoutOptions, pdfExportOptions.slidesLayoutOptions) && Objects.equals(this.imageTransparentColor, pdfExportOptions.imageTransparentColor) && Objects.equals(this.applyImageTransparent, pdfExportOptions.applyImageTransparent) && Objects.equals(this.accessPermissions, pdfExportOptions.accessPermissions) && Objects.equals(this.hideInk, pdfExportOptions.hideInk) && Objects.equals(this.interpretMaskOpAsOpacity, pdfExportOptions.interpretMaskOpAsOpacity) && Objects.equals(this.rasterizeUnsupportedFontStyles, pdfExportOptions.rasterizeUnsupportedFontStyles) && Objects.equals(this.includeOleData, pdfExportOptions.includeOleData) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.textCompression, this.embedFullFonts, this.compliance, this.sufficientResolution, this.jpegQuality, this.drawSlidesFrame, this.showHiddenSlides, this.saveMetafilesAsPng, this.password, this.embedTrueTypeFontsForASCII, this.additionalCommonFontFamilies, this.slidesLayoutOptions, this.imageTransparentColor, this.applyImageTransparent, this.accessPermissions, this.hideInk, this.interpretMaskOpAsOpacity, this.rasterizeUnsupportedFontStyles, this.includeOleData, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    textCompression: ").append(this.toIndentedString((Object)this.textCompression)).append("\n");
        sb.append("    embedFullFonts: ").append(this.toIndentedString(this.embedFullFonts)).append("\n");
        sb.append("    compliance: ").append(this.toIndentedString((Object)this.compliance)).append("\n");
        sb.append("    sufficientResolution: ").append(this.toIndentedString(this.sufficientResolution)).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.jpegQuality)).append("\n");
        sb.append("    drawSlidesFrame: ").append(this.toIndentedString(this.drawSlidesFrame)).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("    saveMetafilesAsPng: ").append(this.toIndentedString(this.saveMetafilesAsPng)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    embedTrueTypeFontsForASCII: ").append(this.toIndentedString(this.embedTrueTypeFontsForASCII)).append("\n");
        sb.append("    additionalCommonFontFamilies: ").append(this.toIndentedString(this.additionalCommonFontFamilies)).append("\n");
        sb.append("    slidesLayoutOptions: ").append(this.toIndentedString(this.slidesLayoutOptions)).append("\n");
        sb.append("    imageTransparentColor: ").append(this.toIndentedString(this.imageTransparentColor)).append("\n");
        sb.append("    applyImageTransparent: ").append(this.toIndentedString(this.applyImageTransparent)).append("\n");
        sb.append("    accessPermissions: ").append(this.toIndentedString(this.accessPermissions)).append("\n");
        sb.append("    hideInk: ").append(this.toIndentedString(this.hideInk)).append("\n");
        sb.append("    interpretMaskOpAsOpacity: ").append(this.toIndentedString(this.interpretMaskOpAsOpacity)).append("\n");
        sb.append("    rasterizeUnsupportedFontStyles: ").append(this.toIndentedString(this.rasterizeUnsupportedFontStyles)).append("\n");
        sb.append("    includeOleData: ").append(this.toIndentedString(this.includeOleData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ComplianceEnum {
        PDF15("Pdf15"),
        PDF16("Pdf16"),
        PDF17("Pdf17"),
        PDFA1B("PdfA1b"),
        PDFA1A("PdfA1a"),
        PDFA2B("PdfA2b"),
        PDFA2A("PdfA2a"),
        PDFA3B("PdfA3b"),
        PDFA3A("PdfA3a"),
        PDFUA("PdfUa"),
        PDFA2U("PdfA2u");

        private String value;

        private ComplianceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ComplianceEnum fromValue(String text) {
            for (ComplianceEnum b : ComplianceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ComplianceEnum> {
            public void write(JsonWriter jsonWriter, ComplianceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ComplianceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ComplianceEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextCompressionEnum {
        NONE("None"),
        FLATE("Flate");

        private String value;

        private TextCompressionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextCompressionEnum fromValue(String text) {
            for (TextCompressionEnum b : TextCompressionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextCompressionEnum> {
            public void write(JsonWriter jsonWriter, TextCompressionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextCompressionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextCompressionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

