/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Specifies an instance of mathematical text that contained within a MathParagraph and starts on its own line.")
public class PhantomElement
extends MathElement {
    @SerializedName(value="base", alternate={"Base"})
    private MathElement base;
    @SerializedName(value="show", alternate={"Show"})
    private Boolean show;
    @SerializedName(value="zeroWidth", alternate={"ZeroWidth"})
    private Boolean zeroWidth;
    @SerializedName(value="zeroAsc", alternate={"ZeroAsc"})
    private Boolean zeroAsc;
    @SerializedName(value="zeroDesc", alternate={"ZeroDesc"})
    private Boolean zeroDesc;
    @SerializedName(value="transp", alternate={"Transp"})
    private Boolean transp;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public PhantomElement() {
        this.setType(MathElement.TypeEnum.PHANTOM);
    }

    public PhantomElement base(MathElement base) {
        this.base = base;
        return this;
    }

    @ApiModelProperty(value="Base element")
    public MathElement getBase() {
        return this.base;
    }

    public void setBase(MathElement base) {
        this.base = base;
    }

    public PhantomElement show(Boolean show) {
        this.show = show;
        return this;
    }

    @ApiModelProperty(value="true if the base element is displayed.")
    public Boolean isShow() {
        return this.show;
    }

    public void setShow(Boolean show) {
        this.show = show;
    }

    public PhantomElement zeroWidth(Boolean zeroWidth) {
        this.zeroWidth = zeroWidth;
        return this;
    }

    @ApiModelProperty(value="true if the the width of the base element should be treated as zero.")
    public Boolean isZeroWidth() {
        return this.zeroWidth;
    }

    public void setZeroWidth(Boolean zeroWidth) {
        this.zeroWidth = zeroWidth;
    }

    public PhantomElement zeroAsc(Boolean zeroAsc) {
        this.zeroAsc = zeroAsc;
        return this;
    }

    @ApiModelProperty(value="true if the the ascent (height above baseline) of the base element should be treated as zero.")
    public Boolean isZeroAsc() {
        return this.zeroAsc;
    }

    public void setZeroAsc(Boolean zeroAsc) {
        this.zeroAsc = zeroAsc;
    }

    public PhantomElement zeroDesc(Boolean zeroDesc) {
        this.zeroDesc = zeroDesc;
        return this;
    }

    @ApiModelProperty(value="true if the the descent (depth below baseline) of the base element should be treated as zero.")
    public Boolean isZeroDesc() {
        return this.zeroDesc;
    }

    public void setZeroDesc(Boolean zeroDesc) {
        this.zeroDesc = zeroDesc;
    }

    public PhantomElement transp(Boolean transp) {
        this.transp = transp;
        return this;
    }

    @ApiModelProperty(value="true if operators and symbols inside the phantom still affect mathematical spacing around the phantom (as if visible).")
    public Boolean isTransp() {
        return this.transp;
    }

    public void setTransp(Boolean transp) {
        this.transp = transp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhantomElement phantomElement = (PhantomElement)o;
        return Objects.equals(this.base, phantomElement.base) && Objects.equals(this.show, phantomElement.show) && Objects.equals(this.zeroWidth, phantomElement.zeroWidth) && Objects.equals(this.zeroAsc, phantomElement.zeroAsc) && Objects.equals(this.zeroDesc, phantomElement.zeroDesc) && Objects.equals(this.transp, phantomElement.transp) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.show, this.zeroWidth, this.zeroAsc, this.zeroDesc, this.transp, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhantomElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    base: ").append(this.toIndentedString(this.base)).append("\n");
        sb.append("    show: ").append(this.toIndentedString(this.show)).append("\n");
        sb.append("    zeroWidth: ").append(this.toIndentedString(this.zeroWidth)).append("\n");
        sb.append("    zeroAsc: ").append(this.toIndentedString(this.zeroAsc)).append("\n");
        sb.append("    zeroDesc: ").append(this.toIndentedString(this.zeroDesc)).append("\n");
        sb.append("    transp: ").append(this.toIndentedString(this.transp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.PHANTOM);
    }
}

