/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents the plot area")
public class PlotArea {
    @SerializedName(value="x", alternate={"X"})
    private Double x;
    @SerializedName(value="y", alternate={"Y"})
    private Double y;
    @SerializedName(value="width", alternate={"Width"})
    private Double width;
    @SerializedName(value="height", alternate={"Height"})
    private Double height;
    @SerializedName(value="layoutTargetType", alternate={"LayoutTargetType"})
    private LayoutTargetTypeEnum layoutTargetType;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="effectFormat", alternate={"EffectFormat"})
    private EffectFormat effectFormat;
    @SerializedName(value="lineFormat", alternate={"LineFormat"})
    private LineFormat lineFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public PlotArea x(Double x) {
        this.x = x;
        return this;
    }

    @ApiModelProperty(value="the X location")
    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public PlotArea y(Double y) {
        this.y = y;
        return this;
    }

    @ApiModelProperty(value="the Y location")
    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public PlotArea width(Double width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="Width")
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public PlotArea height(Double height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(value="Height")
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public PlotArea layoutTargetType(LayoutTargetTypeEnum layoutTargetType) {
        this.layoutTargetType = layoutTargetType;
        return this;
    }

    @ApiModelProperty(value="If layout of the plot area is defined manually specifies whether to layout the plot area by its inside (not including axis and axis labels) or outside.")
    public LayoutTargetTypeEnum getLayoutTargetType() {
        return this.layoutTargetType;
    }

    public void setLayoutTargetType(LayoutTargetTypeEnum layoutTargetType) {
        this.layoutTargetType = layoutTargetType;
    }

    public PlotArea fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the fill format.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public PlotArea effectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the effect format.")
    public EffectFormat getEffectFormat() {
        return this.effectFormat;
    }

    public void setEffectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
    }

    public PlotArea lineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the line format.")
    public LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setLineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlotArea plotArea = (PlotArea)o;
        return Objects.equals(this.x, plotArea.x) && Objects.equals(this.y, plotArea.y) && Objects.equals(this.width, plotArea.width) && Objects.equals(this.height, plotArea.height) && Objects.equals((Object)this.layoutTargetType, (Object)plotArea.layoutTargetType) && Objects.equals(this.fillFormat, plotArea.fillFormat) && Objects.equals(this.effectFormat, plotArea.effectFormat) && Objects.equals(this.lineFormat, plotArea.lineFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.x, this.y, this.width, this.height, this.layoutTargetType, this.fillFormat, this.effectFormat, this.lineFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlotArea {\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    layoutTargetType: ").append(this.toIndentedString((Object)this.layoutTargetType)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    effectFormat: ").append(this.toIndentedString(this.effectFormat)).append("\n");
        sb.append("    lineFormat: ").append(this.toIndentedString(this.lineFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LayoutTargetTypeEnum {
        INNER("Inner"),
        OUTER("Outer");

        private String value;

        private LayoutTargetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LayoutTargetTypeEnum fromValue(String text) {
            for (LayoutTargetTypeEnum b : LayoutTargetTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LayoutTargetTypeEnum> {
            public void write(JsonWriter jsonWriter, LayoutTargetTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LayoutTargetTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LayoutTargetTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

