/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.Task;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Replace text task.")
public class ReplaceText
extends Task {
    @SerializedName(value="oldText", alternate={"OldText"})
    private String oldText;
    @SerializedName(value="newText", alternate={"NewText"})
    private String newText;
    @SerializedName(value="ignoreCase", alternate={"IgnoreCase"})
    private Boolean ignoreCase;
    @SerializedName(value="slidePosition", alternate={"SlidePosition"})
    private Integer slidePosition;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ReplaceText() {
        this.setType(Task.TypeEnum.REPLACETEXT);
    }

    public ReplaceText oldText(String oldText) {
        this.oldText = oldText;
        return this;
    }

    @ApiModelProperty(value="Text to be replaced.")
    public String getOldText() {
        return this.oldText;
    }

    public void setOldText(String oldText) {
        this.oldText = oldText;
    }

    public ReplaceText newText(String newText) {
        this.newText = newText;
        return this;
    }

    @ApiModelProperty(value="Text to replace with.")
    public String getNewText() {
        return this.newText;
    }

    public void setNewText(String newText) {
        this.newText = newText;
    }

    public ReplaceText ignoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    @ApiModelProperty(required=true, value="True to ignore case in replace pattern search.")
    public Boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public ReplaceText slidePosition(Integer slidePosition) {
        this.slidePosition = slidePosition;
        return this;
    }

    @ApiModelProperty(required=true, value="One-based position of the slide to perform the replace in. 0 to make the replace throughout the presentation.")
    public Integer getSlidePosition() {
        return this.slidePosition;
    }

    public void setSlidePosition(Integer slidePosition) {
        this.slidePosition = slidePosition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceText replaceText = (ReplaceText)o;
        return Objects.equals(this.oldText, replaceText.oldText) && Objects.equals(this.newText, replaceText.newText) && Objects.equals(this.ignoreCase, replaceText.ignoreCase) && Objects.equals(this.slidePosition, replaceText.slidePosition) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.oldText, this.newText, this.ignoreCase, this.slidePosition, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplaceText {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    oldText: ").append(this.toIndentedString(this.oldText)).append("\n");
        sb.append("    newText: ").append(this.toIndentedString(this.newText)).append("\n");
        sb.append("    ignoreCase: ").append(this.toIndentedString(this.ignoreCase)).append("\n");
        sb.append("    slidePosition: ").append(this.toIndentedString(this.slidePosition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)Task.TypeEnum.REPLACETEXT);
    }
}

