/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.aspose.slides.model.OutputFile;
import com.aspose.slides.model.Task;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Save slide task.")
public class Save
extends Task {
    @SerializedName(value="format", alternate={"Format"})
    private FormatEnum format;
    @SerializedName(value="output", alternate={"Output"})
    private OutputFile output;
    @SerializedName(value="options", alternate={"Options"})
    private ExportOptions options;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Save() {
        this.setType(Task.TypeEnum.SAVE);
    }

    public Save format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(required=true, value="Format.")
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public Save output(OutputFile output) {
        this.output = output;
        return this;
    }

    @ApiModelProperty(value="Output file.")
    public OutputFile getOutput() {
        return this.output;
    }

    public void setOutput(OutputFile output) {
        this.output = output;
    }

    public Save options(ExportOptions options) {
        this.options = options;
        return this;
    }

    @ApiModelProperty(value="Save options.")
    public ExportOptions getOptions() {
        return this.options;
    }

    public void setOptions(ExportOptions options) {
        this.options = options;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Save save = (Save)o;
        return Objects.equals((Object)this.format, (Object)save.format) && Objects.equals(this.output, save.output) && Objects.equals(this.options, save.options) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.output, this.options, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Save {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)Task.TypeEnum.SAVE);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormatEnum {
        PDF("Pdf"),
        XPS("Xps"),
        TIFF("Tiff"),
        PPTX("Pptx"),
        ODP("Odp"),
        OTP("Otp"),
        PPT("Ppt"),
        PPS("Pps"),
        PPSX("Ppsx"),
        PPTM("Pptm"),
        PPSM("Ppsm"),
        POT("Pot"),
        POTX("Potx"),
        POTM("Potm"),
        HTML("Html"),
        HTML5("Html5"),
        SWF("Swf"),
        SVG("Svg"),
        JPEG("Jpeg"),
        PNG("Png"),
        GIF("Gif"),
        BMP("Bmp"),
        FODP("Fodp"),
        XAML("Xaml"),
        MPEG4("Mpeg4"),
        MD("Md"),
        XML("Xml"),
        EMF("Emf");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormatEnum fromValue(String text) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FormatEnum> {
            public void write(JsonWriter jsonWriter, FormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

