/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceBase;
import com.aspose.slides.model.ResourceUri;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Presentation section.")
public class Section
extends ResourceBase {
    @SerializedName(value="name", alternate={"Name"})
    private String name;
    @SerializedName(value="firstSlideIndex", alternate={"FirstSlideIndex"})
    private Integer firstSlideIndex;
    @SerializedName(value="slideList", alternate={"SlideList"})
    private List<ResourceUri> slideList = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Section name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Section firstSlideIndex(Integer firstSlideIndex) {
        this.firstSlideIndex = firstSlideIndex;
        return this;
    }

    @ApiModelProperty(required=true, value="One-based index of slide with which the section starts.")
    public Integer getFirstSlideIndex() {
        return this.firstSlideIndex;
    }

    public void setFirstSlideIndex(Integer firstSlideIndex) {
        this.firstSlideIndex = firstSlideIndex;
    }

    public Section slideList(List<ResourceUri> slideList) {
        this.slideList = slideList;
        return this;
    }

    public Section addSlideListItem(ResourceUri slideListItem) {
        if (this.slideList == null) {
            this.slideList = new ArrayList<ResourceUri>();
        }
        this.slideList.add(slideListItem);
        return this;
    }

    @ApiModelProperty(value="Links to the shapes contained in the section.")
    public List<ResourceUri> getSlideList() {
        return this.slideList;
    }

    public void setSlideList(List<ResourceUri> slideList) {
        this.slideList = slideList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Section section = (Section)o;
        return Objects.equals(this.name, section.name) && Objects.equals(this.firstSlideIndex, section.firstSlideIndex) && Objects.equals(this.slideList, section.slideList) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.firstSlideIndex, this.slideList, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Section {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    firstSlideIndex: ").append(this.toIndentedString(this.firstSlideIndex)).append("\n");
        sb.append("    slideList: ").append(this.toIndentedString(this.slideList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

