/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.DataSource;
import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.aspose.slides.model.SeriesMarker;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="A chart series.")
public class Series {
    @SerializedName(value="type", alternate={"Type"})
    private TypeEnum type;
    @SerializedName(value="name", alternate={"Name"})
    private String name;
    @SerializedName(value="dataSourceForSeriesName", alternate={"DataSourceForSeriesName"})
    private DataSource dataSourceForSeriesName;
    @SerializedName(value="isColorVaried", alternate={"IsColorVaried"})
    private Boolean isColorVaried;
    @SerializedName(value="invertedSolidFillColor", alternate={"InvertedSolidFillColor"})
    private String invertedSolidFillColor;
    @SerializedName(value="smooth", alternate={"Smooth"})
    private Boolean smooth;
    @SerializedName(value="plotOnSecondAxis", alternate={"PlotOnSecondAxis"})
    private Boolean plotOnSecondAxis;
    @SerializedName(value="order", alternate={"Order"})
    private Integer order;
    @SerializedName(value="invertIfNegative", alternate={"InvertIfNegative"})
    private Boolean invertIfNegative;
    @SerializedName(value="explosion", alternate={"Explosion"})
    private Integer explosion;
    @SerializedName(value="marker", alternate={"Marker"})
    private SeriesMarker marker;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="effectFormat", alternate={"EffectFormat"})
    private EffectFormat effectFormat;
    @SerializedName(value="lineFormat", alternate={"LineFormat"})
    private LineFormat lineFormat;
    @SerializedName(value="dataPointType", alternate={"DataPointType"})
    private DataPointTypeEnum dataPointType;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Series type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Series type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Series name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Series name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Series dataSourceForSeriesName(DataSource dataSourceForSeriesName) {
        this.dataSourceForSeriesName = dataSourceForSeriesName;
        return this;
    }

    @ApiModelProperty(value="Series name data source.")
    public DataSource getDataSourceForSeriesName() {
        return this.dataSourceForSeriesName;
    }

    public void setDataSourceForSeriesName(DataSource dataSourceForSeriesName) {
        this.dataSourceForSeriesName = dataSourceForSeriesName;
    }

    public Series isColorVaried(Boolean isColorVaried) {
        this.isColorVaried = isColorVaried;
        return this;
    }

    @ApiModelProperty(value="True if each data marker in the series has a different color.")
    public Boolean getIsColorVaried() {
        return this.isColorVaried;
    }

    public void setIsColorVaried(Boolean isColorVaried) {
        this.isColorVaried = isColorVaried;
    }

    public Series invertedSolidFillColor(String invertedSolidFillColor) {
        this.invertedSolidFillColor = invertedSolidFillColor;
        return this;
    }

    @ApiModelProperty(value="Invert solid color for the series.")
    public String getInvertedSolidFillColor() {
        return this.invertedSolidFillColor;
    }

    public void setInvertedSolidFillColor(String invertedSolidFillColor) {
        this.invertedSolidFillColor = invertedSolidFillColor;
    }

    public Series smooth(Boolean smooth) {
        this.smooth = smooth;
        return this;
    }

    @ApiModelProperty(value="True if curve smoothing is turned on. Applies only to line and scatter connected by lines charts.")
    public Boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(Boolean smooth) {
        this.smooth = smooth;
    }

    public Series plotOnSecondAxis(Boolean plotOnSecondAxis) {
        this.plotOnSecondAxis = plotOnSecondAxis;
        return this;
    }

    @ApiModelProperty(value="True if the series is plotted on second value axis.")
    public Boolean isPlotOnSecondAxis() {
        return this.plotOnSecondAxis;
    }

    public void setPlotOnSecondAxis(Boolean plotOnSecondAxis) {
        this.plotOnSecondAxis = plotOnSecondAxis;
    }

    public Series order(Integer order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="Series order.")
    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Series invertIfNegative(Boolean invertIfNegative) {
        this.invertIfNegative = invertIfNegative;
        return this;
    }

    @ApiModelProperty(value="True if the series shall invert its colors if the value is negative. Applies to bar, column and bubble series.")
    public Boolean isInvertIfNegative() {
        return this.invertIfNegative;
    }

    public void setInvertIfNegative(Boolean invertIfNegative) {
        this.invertIfNegative = invertIfNegative;
    }

    public Series explosion(Integer explosion) {
        this.explosion = explosion;
        return this;
    }

    @ApiModelProperty(value="The distance of an open pie slice from the center of the pie chart is expressed as a percentage of the pie diameter.")
    public Integer getExplosion() {
        return this.explosion;
    }

    public void setExplosion(Integer explosion) {
        this.explosion = explosion;
    }

    public Series marker(SeriesMarker marker) {
        this.marker = marker;
        return this;
    }

    @ApiModelProperty(value="Series marker.")
    public SeriesMarker getMarker() {
        return this.marker;
    }

    public void setMarker(SeriesMarker marker) {
        this.marker = marker;
    }

    public Series fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Fill properties set for the series.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public Series effectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
        return this;
    }

    @ApiModelProperty(value="Effect properties set for the series.")
    public EffectFormat getEffectFormat() {
        return this.effectFormat;
    }

    public void setEffectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
    }

    public Series lineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        return this;
    }

    @ApiModelProperty(value="Line properties set for the series.")
    public LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setLineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    @ApiModelProperty(value="")
    public DataPointTypeEnum getDataPointType() {
        return this.dataPointType;
    }

    protected void setDataPointType(DataPointTypeEnum dataPointType) {
        this.dataPointType = dataPointType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Series series = (Series)o;
        return Objects.equals((Object)this.type, (Object)series.type) && Objects.equals(this.name, series.name) && Objects.equals(this.dataSourceForSeriesName, series.dataSourceForSeriesName) && Objects.equals(this.isColorVaried, series.isColorVaried) && Objects.equals(this.invertedSolidFillColor, series.invertedSolidFillColor) && Objects.equals(this.smooth, series.smooth) && Objects.equals(this.plotOnSecondAxis, series.plotOnSecondAxis) && Objects.equals(this.order, series.order) && Objects.equals(this.invertIfNegative, series.invertIfNegative) && Objects.equals(this.explosion, series.explosion) && Objects.equals(this.marker, series.marker) && Objects.equals(this.fillFormat, series.fillFormat) && Objects.equals(this.effectFormat, series.effectFormat) && Objects.equals(this.lineFormat, series.lineFormat) && Objects.equals((Object)this.dataPointType, (Object)series.dataPointType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.dataSourceForSeriesName, this.isColorVaried, this.invertedSolidFillColor, this.smooth, this.plotOnSecondAxis, this.order, this.invertIfNegative, this.explosion, this.marker, this.fillFormat, this.effectFormat, this.lineFormat, this.dataPointType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Series {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dataSourceForSeriesName: ").append(this.toIndentedString(this.dataSourceForSeriesName)).append("\n");
        sb.append("    isColorVaried: ").append(this.toIndentedString(this.isColorVaried)).append("\n");
        sb.append("    invertedSolidFillColor: ").append(this.toIndentedString(this.invertedSolidFillColor)).append("\n");
        sb.append("    smooth: ").append(this.toIndentedString(this.smooth)).append("\n");
        sb.append("    plotOnSecondAxis: ").append(this.toIndentedString(this.plotOnSecondAxis)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    invertIfNegative: ").append(this.toIndentedString(this.invertIfNegative)).append("\n");
        sb.append("    explosion: ").append(this.toIndentedString(this.explosion)).append("\n");
        sb.append("    marker: ").append(this.toIndentedString(this.marker)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    effectFormat: ").append(this.toIndentedString(this.effectFormat)).append("\n");
        sb.append("    lineFormat: ").append(this.toIndentedString(this.lineFormat)).append("\n");
        sb.append("    dataPointType: ").append(this.toIndentedString((Object)this.dataPointType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DataPointTypeEnum {
        ONEVALUE("OneValue"),
        SCATTER("Scatter"),
        BUBBLE("Bubble");

        private String value;

        private DataPointTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DataPointTypeEnum fromValue(String text) {
            for (DataPointTypeEnum b : DataPointTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DataPointTypeEnum> {
            public void write(JsonWriter jsonWriter, DataPointTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DataPointTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DataPointTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CLUSTEREDCOLUMN("ClusteredColumn"),
        STACKEDCOLUMN("StackedColumn"),
        PERCENTSSTACKEDCOLUMN("PercentsStackedColumn"),
        CLUSTEREDCOLUMN3D("ClusteredColumn3D"),
        STACKEDCOLUMN3D("StackedColumn3D"),
        PERCENTSSTACKEDCOLUMN3D("PercentsStackedColumn3D"),
        COLUMN3D("Column3D"),
        CLUSTEREDCYLINDER("ClusteredCylinder"),
        STACKEDCYLINDER("StackedCylinder"),
        PERCENTSSTACKEDCYLINDER("PercentsStackedCylinder"),
        CYLINDER3D("Cylinder3D"),
        CLUSTEREDCONE("ClusteredCone"),
        STACKEDCONE("StackedCone"),
        PERCENTSSTACKEDCONE("PercentsStackedCone"),
        CONE3D("Cone3D"),
        CLUSTEREDPYRAMID("ClusteredPyramid"),
        STACKEDPYRAMID("StackedPyramid"),
        PERCENTSSTACKEDPYRAMID("PercentsStackedPyramid"),
        PYRAMID3D("Pyramid3D"),
        LINE("Line"),
        STACKEDLINE("StackedLine"),
        PERCENTSSTACKEDLINE("PercentsStackedLine"),
        LINEWITHMARKERS("LineWithMarkers"),
        STACKEDLINEWITHMARKERS("StackedLineWithMarkers"),
        PERCENTSSTACKEDLINEWITHMARKERS("PercentsStackedLineWithMarkers"),
        LINE3D("Line3D"),
        PIE("Pie"),
        PIE3D("Pie3D"),
        PIEOFPIE("PieOfPie"),
        EXPLODEDPIE("ExplodedPie"),
        EXPLODEDPIE3D("ExplodedPie3D"),
        BAROFPIE("BarOfPie"),
        PERCENTSSTACKEDBAR("PercentsStackedBar"),
        CLUSTEREDBAR3D("ClusteredBar3D"),
        CLUSTEREDBAR("ClusteredBar"),
        STACKEDBAR("StackedBar"),
        STACKEDBAR3D("StackedBar3D"),
        PERCENTSSTACKEDBAR3D("PercentsStackedBar3D"),
        CLUSTEREDHORIZONTALCYLINDER("ClusteredHorizontalCylinder"),
        STACKEDHORIZONTALCYLINDER("StackedHorizontalCylinder"),
        PERCENTSSTACKEDHORIZONTALCYLINDER("PercentsStackedHorizontalCylinder"),
        CLUSTEREDHORIZONTALCONE("ClusteredHorizontalCone"),
        STACKEDHORIZONTALCONE("StackedHorizontalCone"),
        PERCENTSSTACKEDHORIZONTALCONE("PercentsStackedHorizontalCone"),
        CLUSTEREDHORIZONTALPYRAMID("ClusteredHorizontalPyramid"),
        STACKEDHORIZONTALPYRAMID("StackedHorizontalPyramid"),
        PERCENTSSTACKEDHORIZONTALPYRAMID("PercentsStackedHorizontalPyramid"),
        AREA("Area"),
        STACKEDAREA("StackedArea"),
        PERCENTSSTACKEDAREA("PercentsStackedArea"),
        AREA3D("Area3D"),
        STACKEDAREA3D("StackedArea3D"),
        PERCENTSSTACKEDAREA3D("PercentsStackedArea3D"),
        SCATTERWITHMARKERS("ScatterWithMarkers"),
        SCATTERWITHSMOOTHLINESANDMARKERS("ScatterWithSmoothLinesAndMarkers"),
        SCATTERWITHSMOOTHLINES("ScatterWithSmoothLines"),
        SCATTERWITHSTRAIGHTLINESANDMARKERS("ScatterWithStraightLinesAndMarkers"),
        SCATTERWITHSTRAIGHTLINES("ScatterWithStraightLines"),
        HIGHLOWCLOSE("HighLowClose"),
        OPENHIGHLOWCLOSE("OpenHighLowClose"),
        VOLUMEHIGHLOWCLOSE("VolumeHighLowClose"),
        VOLUMEOPENHIGHLOWCLOSE("VolumeOpenHighLowClose"),
        SURFACE3D("Surface3D"),
        WIREFRAMESURFACE3D("WireframeSurface3D"),
        CONTOUR("Contour"),
        WIREFRAMECONTOUR("WireframeContour"),
        DOUGHNUT("Doughnut"),
        EXPLODEDDOUGHNUT("ExplodedDoughnut"),
        BUBBLE("Bubble"),
        BUBBLEWITH3D("BubbleWith3D"),
        RADAR("Radar"),
        RADARWITHMARKERS("RadarWithMarkers"),
        FILLEDRADAR("FilledRadar"),
        SERIESOFMIXEDTYPES("SeriesOfMixedTypes"),
        TREEMAP("Treemap"),
        SUNBURST("Sunburst"),
        HISTOGRAM("Histogram"),
        PARETOLINE("ParetoLine"),
        BOXANDWHISKER("BoxAndWhisker"),
        WATERFALL("Waterfall"),
        FUNNEL("Funnel"),
        MAP("Map");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

