/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a series marker")
public class SeriesMarker {
    @SerializedName(value="size", alternate={"Size"})
    private Integer size;
    @SerializedName(value="symbol", alternate={"Symbol"})
    private SymbolEnum symbol;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="effectFormat", alternate={"EffectFormat"})
    private EffectFormat effectFormat;
    @SerializedName(value="lineFormat", alternate={"LineFormat"})
    private LineFormat lineFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SeriesMarker size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(value="size")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public SeriesMarker symbol(SymbolEnum symbol) {
        this.symbol = symbol;
        return this;
    }

    @ApiModelProperty(value="symbol")
    public SymbolEnum getSymbol() {
        return this.symbol;
    }

    public void setSymbol(SymbolEnum symbol) {
        this.symbol = symbol;
    }

    public SeriesMarker fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the fill format.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public SeriesMarker effectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the effect format.")
    public EffectFormat getEffectFormat() {
        return this.effectFormat;
    }

    public void setEffectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
    }

    public SeriesMarker lineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the line format.")
    public LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setLineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeriesMarker seriesMarker = (SeriesMarker)o;
        return Objects.equals(this.size, seriesMarker.size) && Objects.equals((Object)this.symbol, (Object)seriesMarker.symbol) && Objects.equals(this.fillFormat, seriesMarker.fillFormat) && Objects.equals(this.effectFormat, seriesMarker.effectFormat) && Objects.equals(this.lineFormat, seriesMarker.lineFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.symbol, this.fillFormat, this.effectFormat, this.lineFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SeriesMarker {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString((Object)this.symbol)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    effectFormat: ").append(this.toIndentedString(this.effectFormat)).append("\n");
        sb.append("    lineFormat: ").append(this.toIndentedString(this.lineFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SymbolEnum {
        CIRCLE("Circle"),
        DASH("Dash"),
        DIAMOND("Diamond"),
        DOT("Dot"),
        NONE("None"),
        PICTURE("Picture"),
        PLUS("Plus"),
        SQUARE("Square"),
        STAR("Star"),
        TRIANGLE("Triangle"),
        X("X"),
        NOTDEFINED("NotDefined");

        private String value;

        private SymbolEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SymbolEnum fromValue(String text) {
            for (SymbolEnum b : SymbolEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SymbolEnum> {
            public void write(JsonWriter jsonWriter, SymbolEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SymbolEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SymbolEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

