/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.Hyperlink;
import com.aspose.slides.model.LineFormat;
import com.aspose.slides.model.ResourceBase;
import com.aspose.slides.model.ThreeDFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Slide shape.")
public class ShapeBase
extends ResourceBase {
    @SerializedName(value="name", alternate={"Name"})
    private String name;
    @SerializedName(value="width", alternate={"Width"})
    private Double width;
    @SerializedName(value="height", alternate={"Height"})
    private Double height;
    @SerializedName(value="alternativeText", alternate={"AlternativeText"})
    private String alternativeText;
    @SerializedName(value="alternativeTextTitle", alternate={"AlternativeTextTitle"})
    private String alternativeTextTitle;
    @SerializedName(value="hidden", alternate={"Hidden"})
    private Boolean hidden;
    @SerializedName(value="isDecorative", alternate={"IsDecorative"})
    private Boolean isDecorative;
    @SerializedName(value="x", alternate={"X"})
    private Double x;
    @SerializedName(value="y", alternate={"Y"})
    private Double y;
    @SerializedName(value="zorderPosition", alternate={"ZOrderPosition"})
    private Integer zorderPosition;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="effectFormat", alternate={"EffectFormat"})
    private EffectFormat effectFormat;
    @SerializedName(value="threeDFormat", alternate={"ThreeDFormat"})
    private ThreeDFormat threeDFormat;
    @SerializedName(value="lineFormat", alternate={"LineFormat"})
    private LineFormat lineFormat;
    @SerializedName(value="hyperlinkClick", alternate={"HyperlinkClick"})
    private Hyperlink hyperlinkClick;
    @SerializedName(value="hyperlinkMouseOver", alternate={"HyperlinkMouseOver"})
    private Hyperlink hyperlinkMouseOver;
    @SerializedName(value="type", alternate={"Type"})
    private TypeEnum type;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ShapeBase name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ShapeBase width(Double width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the width.")
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public ShapeBase height(Double height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the height.")
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public ShapeBase alternativeText(String alternativeText) {
        this.alternativeText = alternativeText;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the alternative text.")
    public String getAlternativeText() {
        return this.alternativeText;
    }

    public void setAlternativeText(String alternativeText) {
        this.alternativeText = alternativeText;
    }

    public ShapeBase alternativeTextTitle(String alternativeTextTitle) {
        this.alternativeTextTitle = alternativeTextTitle;
        return this;
    }

    @ApiModelProperty(value="The title of alternative text associated with the shape.")
    public String getAlternativeTextTitle() {
        return this.alternativeTextTitle;
    }

    public void setAlternativeTextTitle(String alternativeTextTitle) {
        this.alternativeTextTitle = alternativeTextTitle;
    }

    public ShapeBase hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether this ShapeBase is hidden.")
    public Boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public ShapeBase isDecorative(Boolean isDecorative) {
        this.isDecorative = isDecorative;
        return this;
    }

    @ApiModelProperty(value="Gets or sets 'Mark as decorative' option.")
    public Boolean getIsDecorative() {
        return this.isDecorative;
    }

    public void setIsDecorative(Boolean isDecorative) {
        this.isDecorative = isDecorative;
    }

    public ShapeBase x(Double x) {
        this.x = x;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the X")
    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public ShapeBase y(Double y) {
        this.y = y;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the Y.")
    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public ShapeBase zorderPosition(Integer zorderPosition) {
        this.zorderPosition = zorderPosition;
        return this;
    }

    @ApiModelProperty(value="Gets z-order position of shape")
    public Integer getZorderPosition() {
        return this.zorderPosition;
    }

    public void setZorderPosition(Integer zorderPosition) {
        this.zorderPosition = zorderPosition;
    }

    public ShapeBase fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the fill format.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public ShapeBase effectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the effect format.")
    public EffectFormat getEffectFormat() {
        return this.effectFormat;
    }

    public void setEffectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
    }

    public ShapeBase threeDFormat(ThreeDFormat threeDFormat) {
        this.threeDFormat = threeDFormat;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the 3D format")
    public ThreeDFormat getThreeDFormat() {
        return this.threeDFormat;
    }

    public void setThreeDFormat(ThreeDFormat threeDFormat) {
        this.threeDFormat = threeDFormat;
    }

    public ShapeBase lineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the line format.")
    public LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setLineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    public ShapeBase hyperlinkClick(Hyperlink hyperlinkClick) {
        this.hyperlinkClick = hyperlinkClick;
        return this;
    }

    @ApiModelProperty(value="Hyperlink defined for mouse click.")
    public Hyperlink getHyperlinkClick() {
        return this.hyperlinkClick;
    }

    public void setHyperlinkClick(Hyperlink hyperlinkClick) {
        this.hyperlinkClick = hyperlinkClick;
    }

    public ShapeBase hyperlinkMouseOver(Hyperlink hyperlinkMouseOver) {
        this.hyperlinkMouseOver = hyperlinkMouseOver;
        return this;
    }

    @ApiModelProperty(value="Hyperlink defined for mouse over.")
    public Hyperlink getHyperlinkMouseOver() {
        return this.hyperlinkMouseOver;
    }

    public void setHyperlinkMouseOver(Hyperlink hyperlinkMouseOver) {
        this.hyperlinkMouseOver = hyperlinkMouseOver;
    }

    @ApiModelProperty(value="")
    public TypeEnum getType() {
        return this.type;
    }

    protected void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeBase shapeBase = (ShapeBase)o;
        return Objects.equals(this.name, shapeBase.name) && Objects.equals(this.width, shapeBase.width) && Objects.equals(this.height, shapeBase.height) && Objects.equals(this.alternativeText, shapeBase.alternativeText) && Objects.equals(this.alternativeTextTitle, shapeBase.alternativeTextTitle) && Objects.equals(this.hidden, shapeBase.hidden) && Objects.equals(this.isDecorative, shapeBase.isDecorative) && Objects.equals(this.x, shapeBase.x) && Objects.equals(this.y, shapeBase.y) && Objects.equals(this.zorderPosition, shapeBase.zorderPosition) && Objects.equals(this.fillFormat, shapeBase.fillFormat) && Objects.equals(this.effectFormat, shapeBase.effectFormat) && Objects.equals(this.threeDFormat, shapeBase.threeDFormat) && Objects.equals(this.lineFormat, shapeBase.lineFormat) && Objects.equals(this.hyperlinkClick, shapeBase.hyperlinkClick) && Objects.equals(this.hyperlinkMouseOver, shapeBase.hyperlinkMouseOver) && Objects.equals((Object)this.type, (Object)shapeBase.type) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.width, this.height, this.alternativeText, this.alternativeTextTitle, this.hidden, this.isDecorative, this.x, this.y, this.zorderPosition, this.fillFormat, this.effectFormat, this.threeDFormat, this.lineFormat, this.hyperlinkClick, this.hyperlinkMouseOver, this.type, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShapeBase {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    alternativeText: ").append(this.toIndentedString(this.alternativeText)).append("\n");
        sb.append("    alternativeTextTitle: ").append(this.toIndentedString(this.alternativeTextTitle)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    isDecorative: ").append(this.toIndentedString(this.isDecorative)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("    zorderPosition: ").append(this.toIndentedString(this.zorderPosition)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    effectFormat: ").append(this.toIndentedString(this.effectFormat)).append("\n");
        sb.append("    threeDFormat: ").append(this.toIndentedString(this.threeDFormat)).append("\n");
        sb.append("    lineFormat: ").append(this.toIndentedString(this.lineFormat)).append("\n");
        sb.append("    hyperlinkClick: ").append(this.toIndentedString(this.hyperlinkClick)).append("\n");
        sb.append("    hyperlinkMouseOver: ").append(this.toIndentedString(this.hyperlinkMouseOver)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        SHAPE("Shape"),
        CHART("Chart"),
        TABLE("Table"),
        PICTUREFRAME("PictureFrame"),
        VIDEOFRAME("VideoFrame"),
        AUDIOFRAME("AudioFrame"),
        SMARTART("SmartArt"),
        OLEOBJECTFRAME("OleObjectFrame"),
        GROUPSHAPE("GroupShape"),
        GRAPHICALOBJECT("GraphicalObject"),
        CONNECTOR("Connector"),
        SMARTARTSHAPE("SmartArtShape"),
        ZOOMFRAME("ZoomFrame"),
        SECTIONZOOMFRAME("SectionZoomFrame"),
        SUMMARYZOOMFRAME("SummaryZoomFrame"),
        SUMMARYZOOMSECTION("SummaryZoomSection");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

