/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a shape is saved in thumbnail.")
public class ShapeImageExportOptions {
    @SerializedName(value="scaleX", alternate={"ScaleX"})
    private Double scaleX;
    @SerializedName(value="scaleY", alternate={"ScaleY"})
    private Double scaleY;
    @SerializedName(value="thumbnailBounds", alternate={"ThumbnailBounds"})
    private ThumbnailBoundsEnum thumbnailBounds;
    @SerializedName(value="format", alternate={"Format"})
    private String format;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ShapeImageExportOptions scaleX(Double scaleX) {
        this.scaleX = scaleX;
        return this;
    }

    @ApiModelProperty(value="Get or sets scaling ratio by X axis.")
    public Double getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(Double scaleX) {
        this.scaleX = scaleX;
    }

    public ShapeImageExportOptions scaleY(Double scaleY) {
        this.scaleY = scaleY;
        return this;
    }

    @ApiModelProperty(value="Get or sets scaling ratio by Y axis.")
    public Double getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(Double scaleY) {
        this.scaleY = scaleY;
    }

    public ShapeImageExportOptions thumbnailBounds(ThumbnailBoundsEnum thumbnailBounds) {
        this.thumbnailBounds = thumbnailBounds;
        return this;
    }

    @ApiModelProperty(value="Get or sets thumbnail bounds")
    public ThumbnailBoundsEnum getThumbnailBounds() {
        return this.thumbnailBounds;
    }

    public void setThumbnailBounds(ThumbnailBoundsEnum thumbnailBounds) {
        this.thumbnailBounds = thumbnailBounds;
    }

    public ShapeImageExportOptions format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(value="Gets export format.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeImageExportOptions shapeImageExportOptions = (ShapeImageExportOptions)o;
        return Objects.equals(this.scaleX, shapeImageExportOptions.scaleX) && Objects.equals(this.scaleY, shapeImageExportOptions.scaleY) && Objects.equals((Object)this.thumbnailBounds, (Object)shapeImageExportOptions.thumbnailBounds) && Objects.equals(this.format, shapeImageExportOptions.format);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scaleX, this.scaleY, this.thumbnailBounds, this.format});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShapeImageExportOptions {\n");
        sb.append("    scaleX: ").append(this.toIndentedString(this.scaleX)).append("\n");
        sb.append("    scaleY: ").append(this.toIndentedString(this.scaleY)).append("\n");
        sb.append("    thumbnailBounds: ").append(this.toIndentedString((Object)this.thumbnailBounds)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ThumbnailBoundsEnum {
        SLIDE("Slide"),
        SHAPE("Shape"),
        APPEARANCE("Appearance");

        private String value;

        private ThumbnailBoundsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ThumbnailBoundsEnum fromValue(String text) {
            for (ThumbnailBoundsEnum b : ThumbnailBoundsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ThumbnailBoundsEnum> {
            public void write(JsonWriter jsonWriter, ThumbnailBoundsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ThumbnailBoundsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ThumbnailBoundsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

