/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.SlideCommentBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents modern comment of slide")
public class SlideModernComment
extends SlideCommentBase {
    @SerializedName(value="textSelectionStart", alternate={"TextSelectionStart"})
    private Integer textSelectionStart;
    @SerializedName(value="textSelectionLength", alternate={"TextSelectionLength"})
    private Integer textSelectionLength;
    @SerializedName(value="status", alternate={"Status"})
    private StatusEnum status;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SlideModernComment() {
        this.setType(SlideCommentBase.TypeEnum.MODERN);
    }

    public SlideModernComment textSelectionStart(Integer textSelectionStart) {
        this.textSelectionStart = textSelectionStart;
        return this;
    }

    @ApiModelProperty(value="Returns or sets starting position of text selection in text frame if the comment associated with AutoShape. Read/write Int32.")
    public Integer getTextSelectionStart() {
        return this.textSelectionStart;
    }

    public void setTextSelectionStart(Integer textSelectionStart) {
        this.textSelectionStart = textSelectionStart;
    }

    public SlideModernComment textSelectionLength(Integer textSelectionLength) {
        this.textSelectionLength = textSelectionLength;
        return this;
    }

    @ApiModelProperty(value="Returns or sets text selection length in text frame if the comment associated with AutoShape. Read/write Int32.")
    public Integer getTextSelectionLength() {
        return this.textSelectionLength;
    }

    public void setTextSelectionLength(Integer textSelectionLength) {
        this.textSelectionLength = textSelectionLength;
    }

    public SlideModernComment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the status of the comment. Read/write ModernCommentStatus.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlideModernComment slideModernComment = (SlideModernComment)o;
        return Objects.equals(this.textSelectionStart, slideModernComment.textSelectionStart) && Objects.equals(this.textSelectionLength, slideModernComment.textSelectionLength) && Objects.equals((Object)this.status, (Object)slideModernComment.status) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.textSelectionStart, this.textSelectionLength, this.status, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SlideModernComment {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    textSelectionStart: ").append(this.toIndentedString(this.textSelectionStart)).append("\n");
        sb.append("    textSelectionLength: ").append(this.toIndentedString(this.textSelectionLength)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)SlideCommentBase.TypeEnum.MODERN);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        NOTDEFINED("NotDefined"),
        ACTIVE("Active"),
        RESOLVED("Resolved"),
        CLOSED("Closed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

