/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Slide properties.")
public class SlideProperties
extends ResourceBase {
    @SerializedName(value="firstSlideNumber", alternate={"FirstSlideNumber"})
    private Integer firstSlideNumber;
    @SerializedName(value="orientation", alternate={"Orientation"})
    private OrientationEnum orientation;
    @SerializedName(value="scaleType", alternate={"ScaleType"})
    private ScaleTypeEnum scaleType;
    @SerializedName(value="sizeType", alternate={"SizeType"})
    private SizeTypeEnum sizeType;
    @SerializedName(value="width", alternate={"Width"})
    private Integer width;
    @SerializedName(value="height", alternate={"Height"})
    private Integer height;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SlideProperties firstSlideNumber(Integer firstSlideNumber) {
        this.firstSlideNumber = firstSlideNumber;
        return this;
    }

    @ApiModelProperty(value="First slide number.")
    public Integer getFirstSlideNumber() {
        return this.firstSlideNumber;
    }

    public void setFirstSlideNumber(Integer firstSlideNumber) {
        this.firstSlideNumber = firstSlideNumber;
    }

    public SlideProperties orientation(OrientationEnum orientation) {
        this.orientation = orientation;
        return this;
    }

    @ApiModelProperty(value="Slide orientation.")
    public OrientationEnum getOrientation() {
        return this.orientation;
    }

    public void setOrientation(OrientationEnum orientation) {
        this.orientation = orientation;
    }

    public SlideProperties scaleType(ScaleTypeEnum scaleType) {
        this.scaleType = scaleType;
        return this;
    }

    @ApiModelProperty(value="Scale type.")
    public ScaleTypeEnum getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(ScaleTypeEnum scaleType) {
        this.scaleType = scaleType;
    }

    public SlideProperties sizeType(SizeTypeEnum sizeType) {
        this.sizeType = sizeType;
        return this;
    }

    @ApiModelProperty(value="Size type.")
    public SizeTypeEnum getSizeType() {
        return this.sizeType;
    }

    public void setSizeType(SizeTypeEnum sizeType) {
        this.sizeType = sizeType;
    }

    public SlideProperties width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="Width.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public SlideProperties height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(value="Height.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlideProperties slideProperties = (SlideProperties)o;
        return Objects.equals(this.firstSlideNumber, slideProperties.firstSlideNumber) && Objects.equals((Object)this.orientation, (Object)slideProperties.orientation) && Objects.equals((Object)this.scaleType, (Object)slideProperties.scaleType) && Objects.equals((Object)this.sizeType, (Object)slideProperties.sizeType) && Objects.equals(this.width, slideProperties.width) && Objects.equals(this.height, slideProperties.height) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.firstSlideNumber, this.orientation, this.scaleType, this.sizeType, this.width, this.height, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SlideProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    firstSlideNumber: ").append(this.toIndentedString(this.firstSlideNumber)).append("\n");
        sb.append("    orientation: ").append(this.toIndentedString((Object)this.orientation)).append("\n");
        sb.append("    scaleType: ").append(this.toIndentedString((Object)this.scaleType)).append("\n");
        sb.append("    sizeType: ").append(this.toIndentedString((Object)this.sizeType)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SizeTypeEnum {
        ONSCREEN("OnScreen"),
        LETTERPAPER("LetterPaper"),
        A4PAPER("A4Paper"),
        SLIDE35MM("Slide35mm"),
        OVERHEAD("Overhead"),
        BANNER("Banner"),
        CUSTOM("Custom"),
        LEDGER("Ledger"),
        A3PAPER("A3Paper"),
        B4ISOPAPER("B4IsoPaper"),
        B5ISOPAPER("B5IsoPaper"),
        B4JISPAPER("B4JisPaper"),
        B5JISPAPER("B5JisPaper"),
        HAGAKICARD("HagakiCard"),
        ONSCREEN16X9("OnScreen16x9"),
        ONSCREEN16X10("OnScreen16x10"),
        WIDESCREEN("Widescreen");

        private String value;

        private SizeTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SizeTypeEnum fromValue(String text) {
            for (SizeTypeEnum b : SizeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SizeTypeEnum> {
            public void write(JsonWriter jsonWriter, SizeTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SizeTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SizeTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ScaleTypeEnum {
        DONOTSCALE("DoNotScale"),
        ENSUREFIT("EnsureFit"),
        MAXIMIZE("Maximize");

        private String value;

        private ScaleTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScaleTypeEnum fromValue(String text) {
            for (ScaleTypeEnum b : ScaleTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ScaleTypeEnum> {
            public void write(JsonWriter jsonWriter, ScaleTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ScaleTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ScaleTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrientationEnum {
        LANDSCAPE("Landscape"),
        PORTRAIT("Portrait");

        private String value;

        private OrientationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrientationEnum fromValue(String text) {
            for (OrientationEnum b : OrientationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OrientationEnum> {
            public void write(JsonWriter jsonWriter, OrientationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrientationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrientationEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

