/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Slide show properties.")
public class SlideShowProperties
extends ResourceBase {
    @SerializedName(value="loop", alternate={"Loop"})
    private Boolean loop;
    @SerializedName(value="startSlide", alternate={"StartSlide"})
    private Integer startSlide;
    @SerializedName(value="endSlide", alternate={"EndSlide"})
    private Integer endSlide;
    @SerializedName(value="penColor", alternate={"PenColor"})
    private String penColor;
    @SerializedName(value="showAnimation", alternate={"ShowAnimation"})
    private Boolean showAnimation;
    @SerializedName(value="showNarration", alternate={"ShowNarration"})
    private Boolean showNarration;
    @SerializedName(value="showMediaControls", alternate={"ShowMediaControls"})
    private Boolean showMediaControls;
    @SerializedName(value="useTimings", alternate={"UseTimings"})
    private Boolean useTimings;
    @SerializedName(value="slideShowType", alternate={"SlideShowType"})
    private SlideShowTypeEnum slideShowType;
    @SerializedName(value="showScrollbar", alternate={"ShowScrollbar"})
    private Boolean showScrollbar;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SlideShowProperties loop(Boolean loop) {
        this.loop = loop;
        return this;
    }

    @ApiModelProperty(value="Loop slide show.")
    public Boolean isLoop() {
        return this.loop;
    }

    public void setLoop(Boolean loop) {
        this.loop = loop;
    }

    public SlideShowProperties startSlide(Integer startSlide) {
        this.startSlide = startSlide;
        return this;
    }

    @ApiModelProperty(value="Start slide in the slide show.")
    public Integer getStartSlide() {
        return this.startSlide;
    }

    public void setStartSlide(Integer startSlide) {
        this.startSlide = startSlide;
    }

    public SlideShowProperties endSlide(Integer endSlide) {
        this.endSlide = endSlide;
        return this;
    }

    @ApiModelProperty(value="End slides in the slide show.")
    public Integer getEndSlide() {
        return this.endSlide;
    }

    public void setEndSlide(Integer endSlide) {
        this.endSlide = endSlide;
    }

    public SlideShowProperties penColor(String penColor) {
        this.penColor = penColor;
        return this;
    }

    @ApiModelProperty(value="Pen color.")
    public String getPenColor() {
        return this.penColor;
    }

    public void setPenColor(String penColor) {
        this.penColor = penColor;
    }

    public SlideShowProperties showAnimation(Boolean showAnimation) {
        this.showAnimation = showAnimation;
        return this;
    }

    @ApiModelProperty(value="Show animation.")
    public Boolean isShowAnimation() {
        return this.showAnimation;
    }

    public void setShowAnimation(Boolean showAnimation) {
        this.showAnimation = showAnimation;
    }

    public SlideShowProperties showNarration(Boolean showNarration) {
        this.showNarration = showNarration;
        return this;
    }

    @ApiModelProperty(value="Show narrration.")
    public Boolean isShowNarration() {
        return this.showNarration;
    }

    public void setShowNarration(Boolean showNarration) {
        this.showNarration = showNarration;
    }

    public SlideShowProperties showMediaControls(Boolean showMediaControls) {
        this.showMediaControls = showMediaControls;
        return this;
    }

    @ApiModelProperty(value="Show media controls.")
    public Boolean isShowMediaControls() {
        return this.showMediaControls;
    }

    public void setShowMediaControls(Boolean showMediaControls) {
        this.showMediaControls = showMediaControls;
    }

    public SlideShowProperties useTimings(Boolean useTimings) {
        this.useTimings = useTimings;
        return this;
    }

    @ApiModelProperty(value="Use timings.")
    public Boolean isUseTimings() {
        return this.useTimings;
    }

    public void setUseTimings(Boolean useTimings) {
        this.useTimings = useTimings;
    }

    public SlideShowProperties slideShowType(SlideShowTypeEnum slideShowType) {
        this.slideShowType = slideShowType;
        return this;
    }

    @ApiModelProperty(value="Slide show type.")
    public SlideShowTypeEnum getSlideShowType() {
        return this.slideShowType;
    }

    public void setSlideShowType(SlideShowTypeEnum slideShowType) {
        this.slideShowType = slideShowType;
    }

    public SlideShowProperties showScrollbar(Boolean showScrollbar) {
        this.showScrollbar = showScrollbar;
        return this;
    }

    @ApiModelProperty(value="Show scroll bar. Applied with BrowsedByIndividual slide show type.")
    public Boolean isShowScrollbar() {
        return this.showScrollbar;
    }

    public void setShowScrollbar(Boolean showScrollbar) {
        this.showScrollbar = showScrollbar;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlideShowProperties slideShowProperties = (SlideShowProperties)o;
        return Objects.equals(this.loop, slideShowProperties.loop) && Objects.equals(this.startSlide, slideShowProperties.startSlide) && Objects.equals(this.endSlide, slideShowProperties.endSlide) && Objects.equals(this.penColor, slideShowProperties.penColor) && Objects.equals(this.showAnimation, slideShowProperties.showAnimation) && Objects.equals(this.showNarration, slideShowProperties.showNarration) && Objects.equals(this.showMediaControls, slideShowProperties.showMediaControls) && Objects.equals(this.useTimings, slideShowProperties.useTimings) && Objects.equals((Object)this.slideShowType, (Object)slideShowProperties.slideShowType) && Objects.equals(this.showScrollbar, slideShowProperties.showScrollbar) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.loop, this.startSlide, this.endSlide, this.penColor, this.showAnimation, this.showNarration, this.showMediaControls, this.useTimings, this.slideShowType, this.showScrollbar, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SlideShowProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    loop: ").append(this.toIndentedString(this.loop)).append("\n");
        sb.append("    startSlide: ").append(this.toIndentedString(this.startSlide)).append("\n");
        sb.append("    endSlide: ").append(this.toIndentedString(this.endSlide)).append("\n");
        sb.append("    penColor: ").append(this.toIndentedString(this.penColor)).append("\n");
        sb.append("    showAnimation: ").append(this.toIndentedString(this.showAnimation)).append("\n");
        sb.append("    showNarration: ").append(this.toIndentedString(this.showNarration)).append("\n");
        sb.append("    showMediaControls: ").append(this.toIndentedString(this.showMediaControls)).append("\n");
        sb.append("    useTimings: ").append(this.toIndentedString(this.useTimings)).append("\n");
        sb.append("    slideShowType: ").append(this.toIndentedString((Object)this.slideShowType)).append("\n");
        sb.append("    showScrollbar: ").append(this.toIndentedString(this.showScrollbar)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SlideShowTypeEnum {
        BROWSEDATKIOSK("BrowsedAtKiosk"),
        BROWSEDBYINDIVIDUAL("BrowsedByIndividual"),
        PRESENTEDBYSPEAKER("PresentedBySpeaker");

        private String value;

        private SlideShowTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SlideShowTypeEnum fromValue(String text) {
            for (SlideShowTypeEnum b : SlideShowTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SlideShowTypeEnum> {
            public void write(JsonWriter jsonWriter, SlideShowTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SlideShowTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SlideShowTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

