/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ShapeBase;
import com.aspose.slides.model.SummaryZoomSection;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Summary zoom frame.")
public class SummaryZoomFrame
extends ShapeBase {
    @SerializedName(value="zoomLayout", alternate={"ZoomLayout"})
    private ZoomLayoutEnum zoomLayout;
    @SerializedName(value="sections", alternate={"Sections"})
    private List<SummaryZoomSection> sections = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SummaryZoomFrame() {
        this.setType(ShapeBase.TypeEnum.SUMMARYZOOMFRAME);
    }

    public SummaryZoomFrame zoomLayout(ZoomLayoutEnum zoomLayout) {
        this.zoomLayout = zoomLayout;
        return this;
    }

    @ApiModelProperty(value="Zoom layout type")
    public ZoomLayoutEnum getZoomLayout() {
        return this.zoomLayout;
    }

    public void setZoomLayout(ZoomLayoutEnum zoomLayout) {
        this.zoomLayout = zoomLayout;
    }

    public SummaryZoomFrame sections(List<SummaryZoomSection> sections) {
        this.sections = sections;
        return this;
    }

    public SummaryZoomFrame addSectionsItem(SummaryZoomSection sectionsItem) {
        if (this.sections == null) {
            this.sections = new ArrayList<SummaryZoomSection>();
        }
        this.sections.add(sectionsItem);
        return this;
    }

    @ApiModelProperty(value="Zoom frame sections")
    public List<SummaryZoomSection> getSections() {
        return this.sections;
    }

    public void setSections(List<SummaryZoomSection> sections) {
        this.sections = sections;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SummaryZoomFrame summaryZoomFrame = (SummaryZoomFrame)o;
        return Objects.equals((Object)this.zoomLayout, (Object)summaryZoomFrame.zoomLayout) && Objects.equals(this.sections, summaryZoomFrame.sections) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.zoomLayout, this.sections, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SummaryZoomFrame {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    zoomLayout: ").append(this.toIndentedString((Object)this.zoomLayout)).append("\n");
        sb.append("    sections: ").append(this.toIndentedString(this.sections)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ShapeBase.TypeEnum.SUMMARYZOOMFRAME);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ZoomLayoutEnum {
        GRIDLAYOUT("GridLayout"),
        FIXEDLAYOUT("FixedLayout");

        private String value;

        private ZoomLayoutEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ZoomLayoutEnum fromValue(String text) {
            for (ZoomLayoutEnum b : ZoomLayoutEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ZoomLayoutEnum> {
            public void write(JsonWriter jsonWriter, ZoomLayoutEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ZoomLayoutEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ZoomLayoutEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

