/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.aspose.slides.model.SlidesLayoutOptions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in SWF format.")
public class SwfExportOptions
extends ExportOptions {
    @SerializedName(value="showHiddenSlides", alternate={"ShowHiddenSlides"})
    private Boolean showHiddenSlides;
    @SerializedName(value="compressed", alternate={"Compressed"})
    private Boolean compressed;
    @SerializedName(value="viewerIncluded", alternate={"ViewerIncluded"})
    private Boolean viewerIncluded;
    @SerializedName(value="showPageBorder", alternate={"ShowPageBorder"})
    private Boolean showPageBorder;
    @SerializedName(value="showFullScreen", alternate={"ShowFullScreen"})
    private Boolean showFullScreen;
    @SerializedName(value="showPageStepper", alternate={"ShowPageStepper"})
    private Boolean showPageStepper;
    @SerializedName(value="showSearch", alternate={"ShowSearch"})
    private Boolean showSearch;
    @SerializedName(value="showTopPane", alternate={"ShowTopPane"})
    private Boolean showTopPane;
    @SerializedName(value="showBottomPane", alternate={"ShowBottomPane"})
    private Boolean showBottomPane;
    @SerializedName(value="showLeftPane", alternate={"ShowLeftPane"})
    private Boolean showLeftPane;
    @SerializedName(value="startOpenLeftPane", alternate={"StartOpenLeftPane"})
    private Boolean startOpenLeftPane;
    @SerializedName(value="enableContextMenu", alternate={"EnableContextMenu"})
    private Boolean enableContextMenu;
    @SerializedName(value="logoImage", alternate={"LogoImage"})
    private String logoImage;
    @SerializedName(value="logoLink", alternate={"LogoLink"})
    private String logoLink;
    @SerializedName(value="jpegQuality", alternate={"JpegQuality"})
    private Integer jpegQuality;
    @SerializedName(value="slidesLayoutOptions", alternate={"SlidesLayoutOptions"})
    private SlidesLayoutOptions slidesLayoutOptions;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SwfExportOptions() {
        this.setFormat("SWF");
    }

    public SwfExportOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should include hidden slides or not. Default is false. ")
    public Boolean isShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    public SwfExportOptions compressed(Boolean compressed) {
        this.compressed = compressed;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated SWF document should be compressed or not. Default is true. ")
    public Boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(Boolean compressed) {
        this.compressed = compressed;
    }

    public SwfExportOptions viewerIncluded(Boolean viewerIncluded) {
        this.viewerIncluded = viewerIncluded;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated SWF document should include the integrated document viewer or not. Default is true. ")
    public Boolean isViewerIncluded() {
        return this.viewerIncluded;
    }

    public void setViewerIncluded(Boolean viewerIncluded) {
        this.viewerIncluded = viewerIncluded;
    }

    public SwfExportOptions showPageBorder(Boolean showPageBorder) {
        this.showPageBorder = showPageBorder;
        return this;
    }

    @ApiModelProperty(value="Specifies whether border around pages should be shown. Default is true. ")
    public Boolean isShowPageBorder() {
        return this.showPageBorder;
    }

    public void setShowPageBorder(Boolean showPageBorder) {
        this.showPageBorder = showPageBorder;
    }

    public SwfExportOptions showFullScreen(Boolean showFullScreen) {
        this.showFullScreen = showFullScreen;
        return this;
    }

    @ApiModelProperty(value="Show/hide fullscreen button. Can be overridden in flashvars. Default is true. ")
    public Boolean isShowFullScreen() {
        return this.showFullScreen;
    }

    public void setShowFullScreen(Boolean showFullScreen) {
        this.showFullScreen = showFullScreen;
    }

    public SwfExportOptions showPageStepper(Boolean showPageStepper) {
        this.showPageStepper = showPageStepper;
        return this;
    }

    @ApiModelProperty(value="Show/hide page stepper. Can be overridden in flashvars. Default is true. ")
    public Boolean isShowPageStepper() {
        return this.showPageStepper;
    }

    public void setShowPageStepper(Boolean showPageStepper) {
        this.showPageStepper = showPageStepper;
    }

    public SwfExportOptions showSearch(Boolean showSearch) {
        this.showSearch = showSearch;
        return this;
    }

    @ApiModelProperty(value="Show/hide search section. Can be overridden in flashvars. Default is true. ")
    public Boolean isShowSearch() {
        return this.showSearch;
    }

    public void setShowSearch(Boolean showSearch) {
        this.showSearch = showSearch;
    }

    public SwfExportOptions showTopPane(Boolean showTopPane) {
        this.showTopPane = showTopPane;
        return this;
    }

    @ApiModelProperty(value="Show/hide whole top pane. Can be overridden in flashvars. Default is true. ")
    public Boolean isShowTopPane() {
        return this.showTopPane;
    }

    public void setShowTopPane(Boolean showTopPane) {
        this.showTopPane = showTopPane;
    }

    public SwfExportOptions showBottomPane(Boolean showBottomPane) {
        this.showBottomPane = showBottomPane;
        return this;
    }

    @ApiModelProperty(value="Show/hide bottom pane. Can be overridden in flashvars. Default is true. ")
    public Boolean isShowBottomPane() {
        return this.showBottomPane;
    }

    public void setShowBottomPane(Boolean showBottomPane) {
        this.showBottomPane = showBottomPane;
    }

    public SwfExportOptions showLeftPane(Boolean showLeftPane) {
        this.showLeftPane = showLeftPane;
        return this;
    }

    @ApiModelProperty(value="Show/hide left pane. Can be overridden in flashvars. Default is true. ")
    public Boolean isShowLeftPane() {
        return this.showLeftPane;
    }

    public void setShowLeftPane(Boolean showLeftPane) {
        this.showLeftPane = showLeftPane;
    }

    public SwfExportOptions startOpenLeftPane(Boolean startOpenLeftPane) {
        this.startOpenLeftPane = startOpenLeftPane;
        return this;
    }

    @ApiModelProperty(value="Start with opened left pane. Can be overridden in flashvars. Default is false. ")
    public Boolean isStartOpenLeftPane() {
        return this.startOpenLeftPane;
    }

    public void setStartOpenLeftPane(Boolean startOpenLeftPane) {
        this.startOpenLeftPane = startOpenLeftPane;
    }

    public SwfExportOptions enableContextMenu(Boolean enableContextMenu) {
        this.enableContextMenu = enableContextMenu;
        return this;
    }

    @ApiModelProperty(value="Enable/disable context menu. Default is true. ")
    public Boolean isEnableContextMenu() {
        return this.enableContextMenu;
    }

    public void setEnableContextMenu(Boolean enableContextMenu) {
        this.enableContextMenu = enableContextMenu;
    }

    public SwfExportOptions logoImage(String logoImage) {
        this.logoImage = logoImage;
        return this;
    }

    @ApiModelProperty(value="Image that will be displayed as logo in the top right corner of the viewer. The image data is a base 64 string. Image should be 32x64 pixels PNG image, otherwise logo can be displayed improperly. ")
    public String getLogoImage() {
        return this.logoImage;
    }

    public void setLogoImage(String logoImage) {
        this.logoImage = logoImage;
    }

    public SwfExportOptions logoLink(String logoLink) {
        this.logoLink = logoLink;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the full hyperlink address for a logo. Has an effect only if a LogoImage is specified. ")
    public String getLogoLink() {
        return this.logoLink;
    }

    public void setLogoLink(String logoLink) {
        this.logoLink = logoLink;
    }

    public SwfExportOptions jpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
        return this;
    }

    @ApiModelProperty(value="Specifies the quality of JPEG images. Default is 95.")
    public Integer getJpegQuality() {
        return this.jpegQuality;
    }

    public void setJpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public SwfExportOptions slidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
        return this;
    }

    @ApiModelProperty(value="Slides layouting options")
    public SlidesLayoutOptions getSlidesLayoutOptions() {
        return this.slidesLayoutOptions;
    }

    public void setSlidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwfExportOptions swfExportOptions = (SwfExportOptions)o;
        return Objects.equals(this.showHiddenSlides, swfExportOptions.showHiddenSlides) && Objects.equals(this.compressed, swfExportOptions.compressed) && Objects.equals(this.viewerIncluded, swfExportOptions.viewerIncluded) && Objects.equals(this.showPageBorder, swfExportOptions.showPageBorder) && Objects.equals(this.showFullScreen, swfExportOptions.showFullScreen) && Objects.equals(this.showPageStepper, swfExportOptions.showPageStepper) && Objects.equals(this.showSearch, swfExportOptions.showSearch) && Objects.equals(this.showTopPane, swfExportOptions.showTopPane) && Objects.equals(this.showBottomPane, swfExportOptions.showBottomPane) && Objects.equals(this.showLeftPane, swfExportOptions.showLeftPane) && Objects.equals(this.startOpenLeftPane, swfExportOptions.startOpenLeftPane) && Objects.equals(this.enableContextMenu, swfExportOptions.enableContextMenu) && Objects.equals(this.logoImage, swfExportOptions.logoImage) && Objects.equals(this.logoLink, swfExportOptions.logoLink) && Objects.equals(this.jpegQuality, swfExportOptions.jpegQuality) && Objects.equals(this.slidesLayoutOptions, swfExportOptions.slidesLayoutOptions) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.showHiddenSlides, this.compressed, this.viewerIncluded, this.showPageBorder, this.showFullScreen, this.showPageStepper, this.showSearch, this.showTopPane, this.showBottomPane, this.showLeftPane, this.startOpenLeftPane, this.enableContextMenu, this.logoImage, this.logoLink, this.jpegQuality, this.slidesLayoutOptions, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SwfExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("    compressed: ").append(this.toIndentedString(this.compressed)).append("\n");
        sb.append("    viewerIncluded: ").append(this.toIndentedString(this.viewerIncluded)).append("\n");
        sb.append("    showPageBorder: ").append(this.toIndentedString(this.showPageBorder)).append("\n");
        sb.append("    showFullScreen: ").append(this.toIndentedString(this.showFullScreen)).append("\n");
        sb.append("    showPageStepper: ").append(this.toIndentedString(this.showPageStepper)).append("\n");
        sb.append("    showSearch: ").append(this.toIndentedString(this.showSearch)).append("\n");
        sb.append("    showTopPane: ").append(this.toIndentedString(this.showTopPane)).append("\n");
        sb.append("    showBottomPane: ").append(this.toIndentedString(this.showBottomPane)).append("\n");
        sb.append("    showLeftPane: ").append(this.toIndentedString(this.showLeftPane)).append("\n");
        sb.append("    startOpenLeftPane: ").append(this.toIndentedString(this.startOpenLeftPane)).append("\n");
        sb.append("    enableContextMenu: ").append(this.toIndentedString(this.enableContextMenu)).append("\n");
        sb.append("    logoImage: ").append(this.toIndentedString(this.logoImage)).append("\n");
        sb.append("    logoLink: ").append(this.toIndentedString(this.logoLink)).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.jpegQuality)).append("\n");
        sb.append("    slidesLayoutOptions: ").append(this.toIndentedString(this.slidesLayoutOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

