/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ShapeBase;
import com.aspose.slides.model.TableColumn;
import com.aspose.slides.model.TableRow;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents Table shape resource.")
public class Table
extends ShapeBase {
    @SerializedName(value="style", alternate={"Style"})
    private StyleEnum style;
    @SerializedName(value="rows", alternate={"Rows"})
    private List<TableRow> rows = null;
    @SerializedName(value="columns", alternate={"Columns"})
    private List<TableColumn> columns = null;
    @SerializedName(value="firstCol", alternate={"FirstCol"})
    private Boolean firstCol;
    @SerializedName(value="firstRow", alternate={"FirstRow"})
    private Boolean firstRow;
    @SerializedName(value="horizontalBanding", alternate={"HorizontalBanding"})
    private Boolean horizontalBanding;
    @SerializedName(value="lastCol", alternate={"LastCol"})
    private Boolean lastCol;
    @SerializedName(value="lastRow", alternate={"LastRow"})
    private Boolean lastRow;
    @SerializedName(value="rightToLeft", alternate={"RightToLeft"})
    private Boolean rightToLeft;
    @SerializedName(value="verticalBanding", alternate={"VerticalBanding"})
    private Boolean verticalBanding;
    @SerializedName(value="transparency", alternate={"Transparency"})
    private Double transparency;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Table() {
        this.setType(ShapeBase.TypeEnum.TABLE);
    }

    public Table style(StyleEnum style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(value="Builtin table style.")
    public StyleEnum getStyle() {
        return this.style;
    }

    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    public Table rows(List<TableRow> rows) {
        this.rows = rows;
        return this;
    }

    public Table addRowsItem(TableRow rowsItem) {
        if (this.rows == null) {
            this.rows = new ArrayList<TableRow>();
        }
        this.rows.add(rowsItem);
        return this;
    }

    @ApiModelProperty(value="Rows.")
    public List<TableRow> getRows() {
        return this.rows;
    }

    public void setRows(List<TableRow> rows) {
        this.rows = rows;
    }

    public Table columns(List<TableColumn> columns) {
        this.columns = columns;
        return this;
    }

    public Table addColumnsItem(TableColumn columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<TableColumn>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @ApiModelProperty(value="Columns.")
    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<TableColumn> columns) {
        this.columns = columns;
    }

    public Table firstCol(Boolean firstCol) {
        this.firstCol = firstCol;
        return this;
    }

    @ApiModelProperty(value="Determines whether the first column of a table has to be drawn with a special formatting.")
    public Boolean isFirstCol() {
        return this.firstCol;
    }

    public void setFirstCol(Boolean firstCol) {
        this.firstCol = firstCol;
    }

    public Table firstRow(Boolean firstRow) {
        this.firstRow = firstRow;
        return this;
    }

    @ApiModelProperty(value="Determines whether the first row of a table has to be drawn with a special formatting.")
    public Boolean isFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(Boolean firstRow) {
        this.firstRow = firstRow;
    }

    public Table horizontalBanding(Boolean horizontalBanding) {
        this.horizontalBanding = horizontalBanding;
        return this;
    }

    @ApiModelProperty(value="Determines whether the even rows has to be drawn with a different formatting.")
    public Boolean isHorizontalBanding() {
        return this.horizontalBanding;
    }

    public void setHorizontalBanding(Boolean horizontalBanding) {
        this.horizontalBanding = horizontalBanding;
    }

    public Table lastCol(Boolean lastCol) {
        this.lastCol = lastCol;
        return this;
    }

    @ApiModelProperty(value="Determines whether the last column of a table has to be drawn with a special formatting.")
    public Boolean isLastCol() {
        return this.lastCol;
    }

    public void setLastCol(Boolean lastCol) {
        this.lastCol = lastCol;
    }

    public Table lastRow(Boolean lastRow) {
        this.lastRow = lastRow;
        return this;
    }

    @ApiModelProperty(value="Determines whether the last row of a table has to be drawn with a special formatting.")
    public Boolean isLastRow() {
        return this.lastRow;
    }

    public void setLastRow(Boolean lastRow) {
        this.lastRow = lastRow;
    }

    public Table rightToLeft(Boolean rightToLeft) {
        this.rightToLeft = rightToLeft;
        return this;
    }

    @ApiModelProperty(value="Determines whether the table has right to left reading order.")
    public Boolean isRightToLeft() {
        return this.rightToLeft;
    }

    public void setRightToLeft(Boolean rightToLeft) {
        this.rightToLeft = rightToLeft;
    }

    public Table verticalBanding(Boolean verticalBanding) {
        this.verticalBanding = verticalBanding;
        return this;
    }

    @ApiModelProperty(value="Determines whether the even columns has to be drawn with a different formatting.")
    public Boolean isVerticalBanding() {
        return this.verticalBanding;
    }

    public void setVerticalBanding(Boolean verticalBanding) {
        this.verticalBanding = verticalBanding;
    }

    public Table transparency(Double transparency) {
        this.transparency = transparency;
        return this;
    }

    @ApiModelProperty(value="Transparency.")
    public Double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals((Object)this.style, (Object)table.style) && Objects.equals(this.rows, table.rows) && Objects.equals(this.columns, table.columns) && Objects.equals(this.firstCol, table.firstCol) && Objects.equals(this.firstRow, table.firstRow) && Objects.equals(this.horizontalBanding, table.horizontalBanding) && Objects.equals(this.lastCol, table.lastCol) && Objects.equals(this.lastRow, table.lastRow) && Objects.equals(this.rightToLeft, table.rightToLeft) && Objects.equals(this.verticalBanding, table.verticalBanding) && Objects.equals(this.transparency, table.transparency) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.style, this.rows, this.columns, this.firstCol, this.firstRow, this.horizontalBanding, this.lastCol, this.lastRow, this.rightToLeft, this.verticalBanding, this.transparency, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Table {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("    rows: ").append(this.toIndentedString(this.rows)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    firstCol: ").append(this.toIndentedString(this.firstCol)).append("\n");
        sb.append("    firstRow: ").append(this.toIndentedString(this.firstRow)).append("\n");
        sb.append("    horizontalBanding: ").append(this.toIndentedString(this.horizontalBanding)).append("\n");
        sb.append("    lastCol: ").append(this.toIndentedString(this.lastCol)).append("\n");
        sb.append("    lastRow: ").append(this.toIndentedString(this.lastRow)).append("\n");
        sb.append("    rightToLeft: ").append(this.toIndentedString(this.rightToLeft)).append("\n");
        sb.append("    verticalBanding: ").append(this.toIndentedString(this.verticalBanding)).append("\n");
        sb.append("    transparency: ").append(this.toIndentedString(this.transparency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ShapeBase.TypeEnum.TABLE);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StyleEnum {
        NONE("None"),
        MEDIUMSTYLE2ACCENT1("MediumStyle2Accent1"),
        MEDIUMSTYLE2("MediumStyle2"),
        NOSTYLENOGRID("NoStyleNoGrid"),
        THEMEDSTYLE1ACCENT1("ThemedStyle1Accent1"),
        THEMEDSTYLE1ACCENT2("ThemedStyle1Accent2"),
        THEMEDSTYLE1ACCENT3("ThemedStyle1Accent3"),
        THEMEDSTYLE1ACCENT4("ThemedStyle1Accent4"),
        THEMEDSTYLE1ACCENT5("ThemedStyle1Accent5"),
        THEMEDSTYLE1ACCENT6("ThemedStyle1Accent6"),
        NOSTYLETABLEGRID("NoStyleTableGrid"),
        THEMEDSTYLE2ACCENT1("ThemedStyle2Accent1"),
        THEMEDSTYLE2ACCENT2("ThemedStyle2Accent2"),
        THEMEDSTYLE2ACCENT3("ThemedStyle2Accent3"),
        THEMEDSTYLE2ACCENT4("ThemedStyle2Accent4"),
        THEMEDSTYLE2ACCENT5("ThemedStyle2Accent5"),
        THEMEDSTYLE2ACCENT6("ThemedStyle2Accent6"),
        LIGHTSTYLE1("LightStyle1"),
        LIGHTSTYLE1ACCENT1("LightStyle1Accent1"),
        LIGHTSTYLE1ACCENT2("LightStyle1Accent2"),
        LIGHTSTYLE1ACCENT3("LightStyle1Accent3"),
        LIGHTSTYLE1ACCENT4("LightStyle1Accent4"),
        LIGHTSTYLE2ACCENT5("LightStyle2Accent5"),
        LIGHTSTYLE1ACCENT6("LightStyle1Accent6"),
        LIGHTSTYLE2("LightStyle2"),
        LIGHTSTYLE2ACCENT1("LightStyle2Accent1"),
        LIGHTSTYLE2ACCENT2("LightStyle2Accent2"),
        LIGHTSTYLE2ACCENT3("LightStyle2Accent3"),
        MEDIUMSTYLE2ACCENT3("MediumStyle2Accent3"),
        MEDIUMSTYLE2ACCENT4("MediumStyle2Accent4"),
        MEDIUMSTYLE2ACCENT5("MediumStyle2Accent5"),
        LIGHTSTYLE2ACCENT6("LightStyle2Accent6"),
        LIGHTSTYLE2ACCENT4("LightStyle2Accent4"),
        LIGHTSTYLE3("LightStyle3"),
        LIGHTSTYLE3ACCENT1("LightStyle3Accent1"),
        MEDIUMSTYLE2ACCENT2("MediumStyle2Accent2"),
        LIGHTSTYLE3ACCENT2("LightStyle3Accent2"),
        LIGHTSTYLE3ACCENT3("LightStyle3Accent3"),
        LIGHTSTYLE3ACCENT4("LightStyle3Accent4"),
        LIGHTSTYLE3ACCENT5("LightStyle3Accent5"),
        LIGHTSTYLE3ACCENT6("LightStyle3Accent6"),
        MEDIUMSTYLE1("MediumStyle1"),
        MEDIUMSTYLE1ACCENT1("MediumStyle1Accent1"),
        MEDIUMSTYLE1ACCENT2("MediumStyle1Accent2"),
        MEDIUMSTYLE1ACCENT3("MediumStyle1Accent3"),
        MEDIUMSTYLE1ACCENT4("MediumStyle1Accent4"),
        MEDIUMSTYLE1ACCENT5("MediumStyle1Accent5"),
        MEDIUMSTYLE1ACCENT6("MediumStyle1Accent6"),
        MEDIUMSTYLE2ACCENT6("MediumStyle2Accent6"),
        MEDIUMSTYLE3("MediumStyle3"),
        MEDIUMSTYLE3ACCENT1("MediumStyle3Accent1"),
        MEDIUMSTYLE3ACCENT2("MediumStyle3Accent2"),
        MEDIUMSTYLE3ACCENT3("MediumStyle3Accent3"),
        MEDIUMSTYLE3ACCENT4("MediumStyle3Accent4"),
        MEDIUMSTYLE3ACCENT5("MediumStyle3Accent5"),
        MEDIUMSTYLE3ACCENT6("MediumStyle3Accent6"),
        MEDIUMSTYLE4("MediumStyle4"),
        MEDIUMSTYLE4ACCENT1("MediumStyle4Accent1"),
        MEDIUMSTYLE4ACCENT2("MediumStyle4Accent2"),
        MEDIUMSTYLE4ACCENT3("MediumStyle4Accent3"),
        MEDIUMSTYLE4ACCENT4("MediumStyle4Accent4"),
        MEDIUMSTYLE4ACCENT5("MediumStyle4Accent5"),
        MEDIUMSTYLE4ACCENT6("MediumStyle4Accent6"),
        DARKSTYLE1("DarkStyle1"),
        DARKSTYLE1ACCENT1("DarkStyle1Accent1"),
        DARKSTYLE1ACCENT2("DarkStyle1Accent2"),
        DARKSTYLE1ACCENT3("DarkStyle1Accent3"),
        DARKSTYLE1ACCENT4("DarkStyle1Accent4"),
        DARKSTYLE1ACCENT5("DarkStyle1Accent5"),
        DARKSTYLE1ACCENT6("DarkStyle1Accent6"),
        DARKSTYLE2("DarkStyle2"),
        DARKSTYLE2ACCENT1ACCENT2("DarkStyle2Accent1Accent2"),
        DARKSTYLE2ACCENT3ACCENT4("DarkStyle2Accent3Accent4"),
        DARKSTYLE2ACCENT5ACCENT6("DarkStyle2Accent5Accent6"),
        LIGHTSTYLE1ACCENT5("LightStyle1Accent5"),
        CUSTOM("Custom");

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StyleEnum fromValue(String text) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StyleEnum> {
            public void write(JsonWriter jsonWriter, StyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StyleEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

