/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceUri;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents text item, referenced by TextItems")
public class TextItem {
    @SerializedName(value="uri", alternate={"Uri"})
    private ResourceUri uri;
    @SerializedName(value="text", alternate={"Text"})
    private String text;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public TextItem uri(ResourceUri uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the URI to resource that contains text")
    public ResourceUri getUri() {
        return this.uri;
    }

    public void setUri(ResourceUri uri) {
        this.uri = uri;
    }

    public TextItem text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the text.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextItem textItem = (TextItem)o;
        return Objects.equals(this.uri, textItem.uri) && Objects.equals(this.text, textItem.text);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextItem {\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

