/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ImageExportOptionsBase;
import com.aspose.slides.model.SlidesLayoutOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in TIFF format.")
public class TiffExportOptions
extends ImageExportOptionsBase {
    @SerializedName(value="compression", alternate={"Compression"})
    private CompressionEnum compression;
    @SerializedName(value="dpiX", alternate={"DpiX"})
    private Integer dpiX;
    @SerializedName(value="dpiY", alternate={"DpiY"})
    private Integer dpiY;
    @SerializedName(value="showHiddenSlides", alternate={"ShowHiddenSlides"})
    private Boolean showHiddenSlides;
    @SerializedName(value="pixelFormat", alternate={"PixelFormat"})
    private PixelFormatEnum pixelFormat;
    @SerializedName(value="slidesLayoutOptions", alternate={"SlidesLayoutOptions"})
    private SlidesLayoutOptions slidesLayoutOptions;
    @SerializedName(value="bwConversionMode", alternate={"BwConversionMode"})
    private BwConversionModeEnum bwConversionMode;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public TiffExportOptions() {
        this.setFormat("TIFF");
    }

    public TiffExportOptions compression(CompressionEnum compression) {
        this.compression = compression;
        return this;
    }

    @ApiModelProperty(value="Compression type.")
    public CompressionEnum getCompression() {
        return this.compression;
    }

    public void setCompression(CompressionEnum compression) {
        this.compression = compression;
    }

    public TiffExportOptions dpiX(Integer dpiX) {
        this.dpiX = dpiX;
        return this;
    }

    @ApiModelProperty(value="Horizontal resolution, in dots per inch.")
    public Integer getDpiX() {
        return this.dpiX;
    }

    public void setDpiX(Integer dpiX) {
        this.dpiX = dpiX;
    }

    public TiffExportOptions dpiY(Integer dpiY) {
        this.dpiY = dpiY;
        return this;
    }

    @ApiModelProperty(value="Vertical resolution, in dots per inch.")
    public Integer getDpiY() {
        return this.dpiY;
    }

    public void setDpiY(Integer dpiY) {
        this.dpiY = dpiY;
    }

    public TiffExportOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should include hidden slides or not. Default is false. ")
    public Boolean isShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    public TiffExportOptions pixelFormat(PixelFormatEnum pixelFormat) {
        this.pixelFormat = pixelFormat;
        return this;
    }

    @ApiModelProperty(value="Specifies the pixel format for the generated images. Read/write ImagePixelFormat.")
    public PixelFormatEnum getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(PixelFormatEnum pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public TiffExportOptions slidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
        return this;
    }

    @ApiModelProperty(value="Slides layouting options")
    public SlidesLayoutOptions getSlidesLayoutOptions() {
        return this.slidesLayoutOptions;
    }

    public void setSlidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
    }

    public TiffExportOptions bwConversionMode(BwConversionModeEnum bwConversionMode) {
        this.bwConversionMode = bwConversionMode;
        return this;
    }

    @ApiModelProperty(value="Specifies the algorithm for converting a color image into a black and white image. This option will applied only if Aspose.Slides.Export.TiffOptions.CompressionType is set to Aspose.Slides.Export.TiffCompressionTypes.CCITT4 or Aspose.Slides.Export.TiffCompressionTypes.CCITT3.")
    public BwConversionModeEnum getBwConversionMode() {
        return this.bwConversionMode;
    }

    public void setBwConversionMode(BwConversionModeEnum bwConversionMode) {
        this.bwConversionMode = bwConversionMode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TiffExportOptions tiffExportOptions = (TiffExportOptions)o;
        return Objects.equals((Object)this.compression, (Object)tiffExportOptions.compression) && Objects.equals(this.dpiX, tiffExportOptions.dpiX) && Objects.equals(this.dpiY, tiffExportOptions.dpiY) && Objects.equals(this.showHiddenSlides, tiffExportOptions.showHiddenSlides) && Objects.equals((Object)this.pixelFormat, (Object)tiffExportOptions.pixelFormat) && Objects.equals(this.slidesLayoutOptions, tiffExportOptions.slidesLayoutOptions) && Objects.equals((Object)this.bwConversionMode, (Object)tiffExportOptions.bwConversionMode) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.compression, this.dpiX, this.dpiY, this.showHiddenSlides, this.pixelFormat, this.slidesLayoutOptions, this.bwConversionMode, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TiffExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    compression: ").append(this.toIndentedString((Object)this.compression)).append("\n");
        sb.append("    dpiX: ").append(this.toIndentedString(this.dpiX)).append("\n");
        sb.append("    dpiY: ").append(this.toIndentedString(this.dpiY)).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("    pixelFormat: ").append(this.toIndentedString((Object)this.pixelFormat)).append("\n");
        sb.append("    slidesLayoutOptions: ").append(this.toIndentedString(this.slidesLayoutOptions)).append("\n");
        sb.append("    bwConversionMode: ").append(this.toIndentedString((Object)this.bwConversionMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BwConversionModeEnum {
        DEFAULT("Default"),
        DITHERING("Dithering"),
        DITHERINGFLOYDSTEINBERG("DitheringFloydSteinberg"),
        AUTO("Auto"),
        AUTOOTSU("AutoOtsu"),
        THRESHOLD25("Threshold25"),
        THRESHOLD50("Threshold50"),
        THRESHOLD75("Threshold75");

        private String value;

        private BwConversionModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BwConversionModeEnum fromValue(String text) {
            for (BwConversionModeEnum b : BwConversionModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BwConversionModeEnum> {
            public void write(JsonWriter jsonWriter, BwConversionModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BwConversionModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BwConversionModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PixelFormatEnum {
        FORMAT1BPPINDEXED("Format1bppIndexed"),
        FORMAT4BPPINDEXED("Format4bppIndexed"),
        FORMAT8BPPINDEXED("Format8bppIndexed"),
        FORMAT24BPPRGB("Format24bppRgb"),
        FORMAT32BPPARGB("Format32bppArgb");

        private String value;

        private PixelFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PixelFormatEnum fromValue(String text) {
            for (PixelFormatEnum b : PixelFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PixelFormatEnum> {
            public void write(JsonWriter jsonWriter, PixelFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PixelFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PixelFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CompressionEnum {
        DEFAULT("Default"),
        NONE("None"),
        CCITT3("CCITT3"),
        CCITT4("CCITT4"),
        LZW("LZW"),
        RLE("RLE");

        private String value;

        private CompressionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CompressionEnum fromValue(String text) {
            for (CompressionEnum b : CompressionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CompressionEnum> {
            public void write(JsonWriter jsonWriter, CompressionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CompressionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CompressionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

