/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceBase;
import com.aspose.slides.model.VbaReference;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents VBA module.")
public class VbaModule
extends ResourceBase {
    @SerializedName(value="name", alternate={"Name"})
    private String name;
    @SerializedName(value="sourceCode", alternate={"SourceCode"})
    private String sourceCode;
    @SerializedName(value="references", alternate={"References"})
    private List<VbaReference> references = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public VbaModule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="VBA module name. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VbaModule sourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
        return this;
    }

    @ApiModelProperty(value="VBA module source code.")
    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public VbaModule references(List<VbaReference> references) {
        this.references = references;
        return this;
    }

    public VbaModule addReferencesItem(VbaReference referencesItem) {
        if (this.references == null) {
            this.references = new ArrayList<VbaReference>();
        }
        this.references.add(referencesItem);
        return this;
    }

    @ApiModelProperty(value="List of references. ")
    public List<VbaReference> getReferences() {
        return this.references;
    }

    public void setReferences(List<VbaReference> references) {
        this.references = references;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VbaModule vbaModule = (VbaModule)o;
        return Objects.equals(this.name, vbaModule.name) && Objects.equals(this.sourceCode, vbaModule.sourceCode) && Objects.equals(this.references, vbaModule.references) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.sourceCode, this.references, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VbaModule {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sourceCode: ").append(this.toIndentedString(this.sourceCode)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

