/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceBase;
import com.aspose.slides.model.ResourceUri;
import com.aspose.slides.model.VbaReference;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="VBA project")
public class VbaProject
extends ResourceBase {
    @SerializedName(value="modules", alternate={"Modules"})
    private List<ResourceUri> modules = null;
    @SerializedName(value="references", alternate={"References"})
    private List<VbaReference> references = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public VbaProject modules(List<ResourceUri> modules) {
        this.modules = modules;
        return this;
    }

    public VbaProject addModulesItem(ResourceUri modulesItem) {
        if (this.modules == null) {
            this.modules = new ArrayList<ResourceUri>();
        }
        this.modules.add(modulesItem);
        return this;
    }

    @ApiModelProperty(value="VBA modules")
    public List<ResourceUri> getModules() {
        return this.modules;
    }

    public void setModules(List<ResourceUri> modules) {
        this.modules = modules;
    }

    public VbaProject references(List<VbaReference> references) {
        this.references = references;
        return this;
    }

    public VbaProject addReferencesItem(VbaReference referencesItem) {
        if (this.references == null) {
            this.references = new ArrayList<VbaReference>();
        }
        this.references.add(referencesItem);
        return this;
    }

    @ApiModelProperty(value="VBA references")
    public List<VbaReference> getReferences() {
        return this.references;
    }

    public void setReferences(List<VbaReference> references) {
        this.references = references;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VbaProject vbaProject = (VbaProject)o;
        return Objects.equals(this.modules, vbaProject.modules) && Objects.equals(this.references, vbaProject.references) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.modules, this.references, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VbaProject {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    modules: ").append(this.toIndentedString(this.modules)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

