/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in an video format.")
public class VideoExportOptions
extends ExportOptions {
    @SerializedName(value="slidesTransitionDuration", alternate={"SlidesTransitionDuration"})
    private Integer slidesTransitionDuration;
    @SerializedName(value="transitionType", alternate={"TransitionType"})
    private TransitionTypeEnum transitionType;
    @SerializedName(value="transitionDuration", alternate={"TransitionDuration"})
    private Integer transitionDuration;
    @SerializedName(value="videoResolutionType", alternate={"VideoResolutionType"})
    private VideoResolutionTypeEnum videoResolutionType;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public VideoExportOptions() {
        this.setFormat("MPEG4");
    }

    public VideoExportOptions slidesTransitionDuration(Integer slidesTransitionDuration) {
        this.slidesTransitionDuration = slidesTransitionDuration;
        return this;
    }

    @ApiModelProperty(value="Slides transition duration.")
    public Integer getSlidesTransitionDuration() {
        return this.slidesTransitionDuration;
    }

    public void setSlidesTransitionDuration(Integer slidesTransitionDuration) {
        this.slidesTransitionDuration = slidesTransitionDuration;
    }

    public VideoExportOptions transitionType(TransitionTypeEnum transitionType) {
        this.transitionType = transitionType;
        return this;
    }

    @ApiModelProperty(value="Video transition type")
    public TransitionTypeEnum getTransitionType() {
        return this.transitionType;
    }

    public void setTransitionType(TransitionTypeEnum transitionType) {
        this.transitionType = transitionType;
    }

    public VideoExportOptions transitionDuration(Integer transitionDuration) {
        this.transitionDuration = transitionDuration;
        return this;
    }

    @ApiModelProperty(value="Duration of transition defined in TransitionType property.")
    public Integer getTransitionDuration() {
        return this.transitionDuration;
    }

    public void setTransitionDuration(Integer transitionDuration) {
        this.transitionDuration = transitionDuration;
    }

    public VideoExportOptions videoResolutionType(VideoResolutionTypeEnum videoResolutionType) {
        this.videoResolutionType = videoResolutionType;
        return this;
    }

    @ApiModelProperty(value="Video resolution type")
    public VideoResolutionTypeEnum getVideoResolutionType() {
        return this.videoResolutionType;
    }

    public void setVideoResolutionType(VideoResolutionTypeEnum videoResolutionType) {
        this.videoResolutionType = videoResolutionType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoExportOptions videoExportOptions = (VideoExportOptions)o;
        return Objects.equals(this.slidesTransitionDuration, videoExportOptions.slidesTransitionDuration) && Objects.equals((Object)this.transitionType, (Object)videoExportOptions.transitionType) && Objects.equals(this.transitionDuration, videoExportOptions.transitionDuration) && Objects.equals((Object)this.videoResolutionType, (Object)videoExportOptions.videoResolutionType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.slidesTransitionDuration, this.transitionType, this.transitionDuration, this.videoResolutionType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    slidesTransitionDuration: ").append(this.toIndentedString(this.slidesTransitionDuration)).append("\n");
        sb.append("    transitionType: ").append(this.toIndentedString((Object)this.transitionType)).append("\n");
        sb.append("    transitionDuration: ").append(this.toIndentedString(this.transitionDuration)).append("\n");
        sb.append("    videoResolutionType: ").append(this.toIndentedString((Object)this.videoResolutionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VideoResolutionTypeEnum {
        FULLHD("FullHD"),
        SD("SD"),
        HD("HD"),
        QHD("QHD");

        private String value;

        private VideoResolutionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VideoResolutionTypeEnum fromValue(String text) {
            for (VideoResolutionTypeEnum b : VideoResolutionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VideoResolutionTypeEnum> {
            public void write(JsonWriter jsonWriter, VideoResolutionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VideoResolutionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VideoResolutionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransitionTypeEnum {
        NONE("None"),
        FADE("Fade"),
        DISTANCE("Distance"),
        SLIDEDOWN("Slidedown"),
        SLIDERIGHT("Slideright"),
        SLIDELEFT("Slideleft"),
        SLIDEUP("Slideup"),
        SMOOTHLEFT("Smoothleft"),
        SMOOTHRIGHT("Smoothright"),
        SMOOTHUP("Smoothup"),
        SMOOTHDOWN("Smoothdown"),
        RECTCROP("Rectcrop"),
        CIRCLECROP("Circlecrop"),
        CIRCLECLOSE("Circleclose"),
        CIRCLEOPEN("Circleopen"),
        HORZCLOSE("Horzclose"),
        HORZOPEN("Horzopen"),
        VERTCLOSE("Vertclose"),
        VERTOPEN("Vertopen"),
        DIAGBL("Diagbl"),
        DIAGBR("Diagbr"),
        DIAGTL("Diagtl"),
        DIAGTR("Diagtr"),
        HLSLICE("Hlslice"),
        HRSLICE("Hrslice"),
        VUSLICE("Vuslice"),
        VDSLICE("Vdslice"),
        DISSOLVE("Dissolve"),
        PIXELIZE("Pixelize"),
        RADIAL("Radial");

        private String value;

        private TransitionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransitionTypeEnum fromValue(String text) {
            for (TransitionTypeEnum b : TransitionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TransitionTypeEnum> {
            public void write(JsonWriter jsonWriter, TransitionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransitionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransitionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

