/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.DataSource;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents Excel spreadsheet data source.")
public class Workbook
extends DataSource {
    @SerializedName(value="worksheetIndex", alternate={"WorksheetIndex"})
    private Integer worksheetIndex;
    @SerializedName(value="columnIndex", alternate={"ColumnIndex"})
    private Integer columnIndex;
    @SerializedName(value="rowIndex", alternate={"RowIndex"})
    private Integer rowIndex;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Workbook() {
        this.setType(DataSource.TypeEnum.WORKBOOK);
    }

    public Workbook worksheetIndex(Integer worksheetIndex) {
        this.worksheetIndex = worksheetIndex;
        return this;
    }

    @ApiModelProperty(required=true, value="Worksheet index.")
    public Integer getWorksheetIndex() {
        return this.worksheetIndex;
    }

    public void setWorksheetIndex(Integer worksheetIndex) {
        this.worksheetIndex = worksheetIndex;
    }

    public Workbook columnIndex(Integer columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }

    @ApiModelProperty(required=true, value="Column index of the first value.")
    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(Integer columnIndex) {
        this.columnIndex = columnIndex;
    }

    public Workbook rowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    @ApiModelProperty(required=true, value="Row index of the first value.")
    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workbook workbook = (Workbook)o;
        return Objects.equals(this.worksheetIndex, workbook.worksheetIndex) && Objects.equals(this.columnIndex, workbook.columnIndex) && Objects.equals(this.rowIndex, workbook.rowIndex) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.worksheetIndex, this.columnIndex, this.rowIndex, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workbook {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    worksheetIndex: ").append(this.toIndentedString(this.worksheetIndex)).append("\n");
        sb.append("    columnIndex: ").append(this.toIndentedString(this.columnIndex)).append("\n");
        sb.append("    rowIndex: ").append(this.toIndentedString(this.rowIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)DataSource.TypeEnum.WORKBOOK);
    }
}

