/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.Baseline;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents baseline values of a resource assignment.")
public class AssignmentBaseline
extends Baseline {
    @SerializedName(value="Start")
    private OffsetDateTime start = null;
    @SerializedName(value="Finish")
    private OffsetDateTime finish = null;

    public AssignmentBaseline start(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the scheduled start date of the resource assignment when the baseline was saved. The start date of the resource assignment when this baseline was saved.")
    public OffsetDateTime getStart() {
        return this.start;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public AssignmentBaseline finish(OffsetDateTime finish) {
        this.finish = finish;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the scheduled finish date of the resource assignment when the baseline was saved. The finish date of the resource assignment when this baseline was saved.")
    public OffsetDateTime getFinish() {
        return this.finish;
    }

    public void setFinish(OffsetDateTime finish) {
        this.finish = finish;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentBaseline assignmentBaseline = (AssignmentBaseline)o;
        return Objects.equals(this.start, assignmentBaseline.start) && Objects.equals(this.finish, assignmentBaseline.finish) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.start, this.finish, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssignmentBaseline {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    finish: ").append(this.toIndentedString(this.finish)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

