/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.WeekDay;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a calendar used in a project.")
public class Calendar {
    @SerializedName(value="Guid")
    private String guid = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="Uid")
    private Integer uid = null;
    @SerializedName(value="Days")
    private List<WeekDay> days = null;
    @SerializedName(value="IsBaseCalendar")
    private Boolean isBaseCalendar = null;
    @SerializedName(value="BaseCalendar")
    private Calendar baseCalendar = null;
    @SerializedName(value="IsBaselineCalendar")
    private Boolean isBaselineCalendar = null;

    public Calendar guid(String guid) {
        this.guid = guid;
        return this;
    }

    @ApiModelProperty(value="Gets calendar's Guid.")
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Calendar name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the calendar.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Calendar uid(Integer uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the calendar.")
    public Integer getUid() {
        return this.uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public Calendar days(List<WeekDay> days) {
        this.days = days;
        return this;
    }

    public Calendar addDaysItem(WeekDay daysItem) {
        if (this.days == null) {
            this.days = new ArrayList<WeekDay>();
        }
        this.days.add(daysItem);
        return this;
    }

    @ApiModelProperty(value="The collection of weekdays that defines the calendar.")
    public List<WeekDay> getDays() {
        return this.days;
    }

    public void setDays(List<WeekDay> days) {
        this.days = days;
    }

    public Calendar isBaseCalendar(Boolean isBaseCalendar) {
        this.isBaseCalendar = isBaseCalendar;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the calendar is a base calendar.")
    public Boolean isIsBaseCalendar() {
        return this.isBaseCalendar;
    }

    public void setIsBaseCalendar(Boolean isBaseCalendar) {
        this.isBaseCalendar = isBaseCalendar;
    }

    public Calendar baseCalendar(Calendar baseCalendar) {
        this.baseCalendar = baseCalendar;
        return this;
    }

    @ApiModelProperty(value="The base calendar on which this calendar depends. Only applicable if the calendar is not a base calendar.")
    public Calendar getBaseCalendar() {
        return this.baseCalendar;
    }

    public void setBaseCalendar(Calendar baseCalendar) {
        this.baseCalendar = baseCalendar;
    }

    public Calendar isBaselineCalendar(Boolean isBaselineCalendar) {
        this.isBaselineCalendar = isBaselineCalendar;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether the calendar is a baseline calendar.")
    public Boolean isIsBaselineCalendar() {
        return this.isBaselineCalendar;
    }

    public void setIsBaselineCalendar(Boolean isBaselineCalendar) {
        this.isBaselineCalendar = isBaselineCalendar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Calendar calendar = (Calendar)o;
        return Objects.equals(this.guid, calendar.guid) && Objects.equals(this.name, calendar.name) && Objects.equals(this.uid, calendar.uid) && Objects.equals(this.days, calendar.days) && Objects.equals(this.isBaseCalendar, calendar.isBaseCalendar) && Objects.equals(this.baseCalendar, calendar.baseCalendar) && Objects.equals(this.isBaselineCalendar, calendar.isBaselineCalendar);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.name, this.uid, this.days, this.isBaseCalendar, this.baseCalendar, this.isBaselineCalendar);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Calendar {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    days: ").append(this.toIndentedString(this.days)).append("\n");
        sb.append("    isBaseCalendar: ").append(this.toIndentedString(this.isBaseCalendar)).append("\n");
        sb.append("    baseCalendar: ").append(this.toIndentedString(this.baseCalendar)).append("\n");
        sb.append("    isBaselineCalendar: ").append(this.toIndentedString(this.isBaselineCalendar)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

