/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.OutlineMask;
import com.aspose.tasks.cloud.model.OutlineValue;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents an outline code definition.")
public class OutlineCodeDefinition {
    @SerializedName(value="Guid")
    private String guid = null;
    @SerializedName(value="FieldId")
    private String fieldId = null;
    @SerializedName(value="FieldName")
    private String fieldName = null;
    @SerializedName(value="Alias")
    private String alias = null;
    @SerializedName(value="PhoneticAlias")
    private String phoneticAlias = null;
    @SerializedName(value="Values")
    private List<OutlineValue> values = null;
    @SerializedName(value="Enterprise")
    private Boolean enterprise = null;
    @SerializedName(value="EnterpriseOutlineCodeAlias")
    private Integer enterpriseOutlineCodeAlias = null;
    @SerializedName(value="ResourceSubstitutionEnabled")
    private Boolean resourceSubstitutionEnabled = null;
    @SerializedName(value="LeafOnly")
    private Boolean leafOnly = null;
    @SerializedName(value="AllLevelsRequired")
    private Boolean allLevelsRequired = null;
    @SerializedName(value="OnlyTableValuesAllowed")
    private Boolean onlyTableValuesAllowed = null;
    @SerializedName(value="Masks")
    private List<OutlineMask> masks = null;
    @SerializedName(value="ShowIndent")
    private Boolean showIndent = null;

    public OutlineCodeDefinition guid(String guid) {
        this.guid = guid;
        return this;
    }

    @ApiModelProperty(value="The Guid of an outline code.")
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public OutlineCodeDefinition fieldId(String fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    @ApiModelProperty(value="Corresponds to the field number of an outline code.")
    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public OutlineCodeDefinition fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @ApiModelProperty(value="The name of a custom outline code.")
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public OutlineCodeDefinition alias(String alias) {
        this.alias = alias;
        return this;
    }

    @ApiModelProperty(value="The alias of a custom outline code.")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public OutlineCodeDefinition phoneticAlias(String phoneticAlias) {
        this.phoneticAlias = phoneticAlias;
        return this;
    }

    @ApiModelProperty(value="The phonetic pronunciation of the alias of the custom outline code.")
    public String getPhoneticAlias() {
        return this.phoneticAlias;
    }

    public void setPhoneticAlias(String phoneticAlias) {
        this.phoneticAlias = phoneticAlias;
    }

    public OutlineCodeDefinition values(List<OutlineValue> values) {
        this.values = values;
        return this;
    }

    public OutlineCodeDefinition addValuesItem(OutlineValue valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<OutlineValue>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(value="Returns List&lt;OutlineValue&gt; Values. The values of the table associated with this outline code.")
    public List<OutlineValue> getValues() {
        return this.values;
    }

    public void setValues(List<OutlineValue> values) {
        this.values = values;
    }

    public OutlineCodeDefinition enterprise(Boolean enterprise) {
        this.enterprise = enterprise;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a custom outline code is an enterprise custom outline code.")
    public Boolean isEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(Boolean enterprise) {
        this.enterprise = enterprise;
    }

    public OutlineCodeDefinition enterpriseOutlineCodeAlias(Integer enterpriseOutlineCodeAlias) {
        this.enterpriseOutlineCodeAlias = enterpriseOutlineCodeAlias;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference to another custom field for which this outline code definition is an alias.")
    public Integer getEnterpriseOutlineCodeAlias() {
        return this.enterpriseOutlineCodeAlias;
    }

    public void setEnterpriseOutlineCodeAlias(Integer enterpriseOutlineCodeAlias) {
        this.enterpriseOutlineCodeAlias = enterpriseOutlineCodeAlias;
    }

    public OutlineCodeDefinition resourceSubstitutionEnabled(Boolean resourceSubstitutionEnabled) {
        this.resourceSubstitutionEnabled = resourceSubstitutionEnabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the custom outline code can be used by the Resource Substitution Wizard in Microsoft Project.")
    public Boolean isResourceSubstitutionEnabled() {
        return this.resourceSubstitutionEnabled;
    }

    public void setResourceSubstitutionEnabled(Boolean resourceSubstitutionEnabled) {
        this.resourceSubstitutionEnabled = resourceSubstitutionEnabled;
    }

    public OutlineCodeDefinition leafOnly(Boolean leafOnly) {
        this.leafOnly = leafOnly;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the values specified in this outline code field must be leaf values.")
    public Boolean isLeafOnly() {
        return this.leafOnly;
    }

    public void setLeafOnly(Boolean leafOnly) {
        this.leafOnly = leafOnly;
    }

    public OutlineCodeDefinition allLevelsRequired(Boolean allLevelsRequired) {
        this.allLevelsRequired = allLevelsRequired;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the new codes must have all levels. Not available for Enterprise Codes.")
    public Boolean isAllLevelsRequired() {
        return this.allLevelsRequired;
    }

    public void setAllLevelsRequired(Boolean allLevelsRequired) {
        this.allLevelsRequired = allLevelsRequired;
    }

    public OutlineCodeDefinition onlyTableValuesAllowed(Boolean onlyTableValuesAllowed) {
        this.onlyTableValuesAllowed = onlyTableValuesAllowed;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the values specified must come from values table.")
    public Boolean isOnlyTableValuesAllowed() {
        return this.onlyTableValuesAllowed;
    }

    public void setOnlyTableValuesAllowed(Boolean onlyTableValuesAllowed) {
        this.onlyTableValuesAllowed = onlyTableValuesAllowed;
    }

    public OutlineCodeDefinition masks(List<OutlineMask> masks) {
        this.masks = masks;
        return this;
    }

    public OutlineCodeDefinition addMasksItem(OutlineMask masksItem) {
        if (this.masks == null) {
            this.masks = new ArrayList<OutlineMask>();
        }
        this.masks.add(masksItem);
        return this;
    }

    @ApiModelProperty(value="Returns List&lt;OutlineMask&gt; Masks. The table of entries that define the outline code mask.")
    public List<OutlineMask> getMasks() {
        return this.masks;
    }

    public void setMasks(List<OutlineMask> masks) {
        this.masks = masks;
    }

    public OutlineCodeDefinition showIndent(Boolean showIndent) {
        this.showIndent = showIndent;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the indents of this outline code must be shown.")
    public Boolean isShowIndent() {
        return this.showIndent;
    }

    public void setShowIndent(Boolean showIndent) {
        this.showIndent = showIndent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlineCodeDefinition outlineCodeDefinition = (OutlineCodeDefinition)o;
        return Objects.equals(this.guid, outlineCodeDefinition.guid) && Objects.equals(this.fieldId, outlineCodeDefinition.fieldId) && Objects.equals(this.fieldName, outlineCodeDefinition.fieldName) && Objects.equals(this.alias, outlineCodeDefinition.alias) && Objects.equals(this.phoneticAlias, outlineCodeDefinition.phoneticAlias) && Objects.equals(this.values, outlineCodeDefinition.values) && Objects.equals(this.enterprise, outlineCodeDefinition.enterprise) && Objects.equals(this.enterpriseOutlineCodeAlias, outlineCodeDefinition.enterpriseOutlineCodeAlias) && Objects.equals(this.resourceSubstitutionEnabled, outlineCodeDefinition.resourceSubstitutionEnabled) && Objects.equals(this.leafOnly, outlineCodeDefinition.leafOnly) && Objects.equals(this.allLevelsRequired, outlineCodeDefinition.allLevelsRequired) && Objects.equals(this.onlyTableValuesAllowed, outlineCodeDefinition.onlyTableValuesAllowed) && Objects.equals(this.masks, outlineCodeDefinition.masks) && Objects.equals(this.showIndent, outlineCodeDefinition.showIndent);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.fieldId, this.fieldName, this.alias, this.phoneticAlias, this.values, this.enterprise, this.enterpriseOutlineCodeAlias, this.resourceSubstitutionEnabled, this.leafOnly, this.allLevelsRequired, this.onlyTableValuesAllowed, this.masks, this.showIndent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutlineCodeDefinition {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    fieldId: ").append(this.toIndentedString(this.fieldId)).append("\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    phoneticAlias: ").append(this.toIndentedString(this.phoneticAlias)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    enterprise: ").append(this.toIndentedString(this.enterprise)).append("\n");
        sb.append("    enterpriseOutlineCodeAlias: ").append(this.toIndentedString(this.enterpriseOutlineCodeAlias)).append("\n");
        sb.append("    resourceSubstitutionEnabled: ").append(this.toIndentedString(this.resourceSubstitutionEnabled)).append("\n");
        sb.append("    leafOnly: ").append(this.toIndentedString(this.leafOnly)).append("\n");
        sb.append("    allLevelsRequired: ").append(this.toIndentedString(this.allLevelsRequired)).append("\n");
        sb.append("    onlyTableValuesAllowed: ").append(this.toIndentedString(this.onlyTableValuesAllowed)).append("\n");
        sb.append("    masks: ").append(this.toIndentedString(this.masks)).append("\n");
        sb.append("    showIndent: ").append(this.toIndentedString(this.showIndent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

