/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Brief info about the published project available on Project Online.")
public class ProjectInfo {
    @SerializedName(value="Id")
    private String id = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="CreatedDate")
    private OffsetDateTime createdDate = null;
    @SerializedName(value="IsCheckedOut")
    private Boolean isCheckedOut = null;
    @SerializedName(value="LastPublishedDate")
    private OffsetDateTime lastPublishedDate = null;
    @SerializedName(value="LastSavedDate")
    private OffsetDateTime lastSavedDate = null;
    @SerializedName(value="Description")
    private String description = null;

    public ProjectInfo id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the project.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProjectInfo name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the project.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProjectInfo createdDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time when the project was created.")
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public ProjectInfo isCheckedOut(Boolean isCheckedOut) {
        this.isCheckedOut = isCheckedOut;
        return this;
    }

    @ApiModelProperty(required=true, value="Value indicating whether the project is checked out.")
    public Boolean isIsCheckedOut() {
        return this.isCheckedOut;
    }

    public void setIsCheckedOut(Boolean isCheckedOut) {
        this.isCheckedOut = isCheckedOut;
    }

    public ProjectInfo lastPublishedDate(OffsetDateTime lastPublishedDate) {
        this.lastPublishedDate = lastPublishedDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The most recent date when the project was published.")
    public OffsetDateTime getLastPublishedDate() {
        return this.lastPublishedDate;
    }

    public void setLastPublishedDate(OffsetDateTime lastPublishedDate) {
        this.lastPublishedDate = lastPublishedDate;
    }

    public ProjectInfo lastSavedDate(OffsetDateTime lastSavedDate) {
        this.lastSavedDate = lastSavedDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The most recent date when the project was saved.")
    public OffsetDateTime getLastSavedDate() {
        return this.lastSavedDate;
    }

    public void setLastSavedDate(OffsetDateTime lastSavedDate) {
        this.lastSavedDate = lastSavedDate;
    }

    public ProjectInfo description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the project.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectInfo projectInfo = (ProjectInfo)o;
        return Objects.equals(this.id, projectInfo.id) && Objects.equals(this.name, projectInfo.name) && Objects.equals(this.createdDate, projectInfo.createdDate) && Objects.equals(this.isCheckedOut, projectInfo.isCheckedOut) && Objects.equals(this.lastPublishedDate, projectInfo.lastPublishedDate) && Objects.equals(this.lastSavedDate, projectInfo.lastSavedDate) && Objects.equals(this.description, projectInfo.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.createdDate, this.isCheckedOut, this.lastPublishedDate, this.lastSavedDate, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    isCheckedOut: ").append(this.toIndentedString(this.isCheckedOut)).append("\n");
        sb.append("    lastPublishedDate: ").append(this.toIndentedString(this.lastPublishedDate)).append("\n");
        sb.append("    lastSavedDate: ").append(this.toIndentedString(this.lastSavedDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

