/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.DayOfWeek;
import com.aspose.tasks.cloud.model.Month;
import com.aspose.tasks.cloud.model.OrdinalNumber;
import com.aspose.tasks.cloud.model.RecurrencePattern;
import com.aspose.tasks.cloud.model.WeekDayType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents the details of a recurring task in a project.")
public class RecurringInfo {
    @SerializedName(value="RecurrencePattern")
    private RecurrencePattern recurrencePattern = null;
    @SerializedName(value="StartDate")
    private OffsetDateTime startDate = null;
    @SerializedName(value="EndDate")
    private OffsetDateTime endDate = null;
    @SerializedName(value="Duration")
    private String duration = null;
    @SerializedName(value="Occurrences")
    private Integer occurrences = null;
    @SerializedName(value="UseEndDate")
    private Boolean useEndDate = null;
    @SerializedName(value="DailyRepetitions")
    private Integer dailyRepetitions = null;
    @SerializedName(value="DailyUseWorkdays")
    private Boolean dailyUseWorkdays = null;
    @SerializedName(value="WeeklyRepetitions")
    private Integer weeklyRepetitions = null;
    @SerializedName(value="WeeklyDays")
    private WeekDayType weeklyDays = null;
    @SerializedName(value="MonthlyUseOrdinalDay")
    private Boolean monthlyUseOrdinalDay = null;
    @SerializedName(value="MonthlyOrdinalNumber")
    private OrdinalNumber monthlyOrdinalNumber = null;
    @SerializedName(value="MonthlyOrdinalDay")
    private DayOfWeek monthlyOrdinalDay = null;
    @SerializedName(value="MonthlyOrdinalRepetitions")
    private Integer monthlyOrdinalRepetitions = null;
    @SerializedName(value="MonthlyDay")
    private Integer monthlyDay = null;
    @SerializedName(value="MonthlyRepetitions")
    private Integer monthlyRepetitions = null;
    @SerializedName(value="YearlyUseOrdinalDay")
    private Boolean yearlyUseOrdinalDay = null;
    @SerializedName(value="YearlyDate")
    private OffsetDateTime yearlyDate = null;
    @SerializedName(value="YearlyOrdinalNumber")
    private OrdinalNumber yearlyOrdinalNumber = null;
    @SerializedName(value="YearlyOrdinalDay")
    private DayOfWeek yearlyOrdinalDay = null;
    @SerializedName(value="YearlyOrdinalMonth")
    private Month yearlyOrdinalMonth = null;

    public RecurringInfo recurrencePattern(RecurrencePattern recurrencePattern) {
        this.recurrencePattern = recurrencePattern;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents a recurrence pattern of the recurring task. Can be one of the values of  enum.")
    public RecurrencePattern getRecurrencePattern() {
        return this.recurrencePattern;
    }

    public void setRecurrencePattern(RecurrencePattern recurrencePattern) {
        this.recurrencePattern = recurrencePattern;
    }

    public RecurringInfo startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the date for the occurrences to begin.")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public RecurringInfo endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the date for the occurrences to end.")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public RecurringInfo duration(String duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the duration for one occurrence of the recurring task. the instance of  class.")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public RecurringInfo occurrences(Integer occurrences) {
        this.occurrences = occurrences;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a number of occurrences of the recurring task.")
    public Integer getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(Integer occurrences) {
        this.occurrences = occurrences;
    }

    public RecurringInfo useEndDate(Boolean useEndDate) {
        this.useEndDate = useEndDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether to use the end date or a number of occurrences for the recurring task.")
    public Boolean isUseEndDate() {
        return this.useEndDate;
    }

    public void setUseEndDate(Boolean useEndDate) {
        this.useEndDate = useEndDate;
    }

    public RecurringInfo dailyRepetitions(Integer dailyRepetitions) {
        this.dailyRepetitions = dailyRepetitions;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies an interval between repetitions for the daily recurrence pattern.")
    public Integer getDailyRepetitions() {
        return this.dailyRepetitions;
    }

    public void setDailyRepetitions(Integer dailyRepetitions) {
        this.dailyRepetitions = dailyRepetitions;
    }

    public RecurringInfo dailyUseWorkdays(Boolean dailyUseWorkdays) {
        this.dailyUseWorkdays = dailyUseWorkdays;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether to use workdays for the daily recurrence pattern.")
    public Boolean isDailyUseWorkdays() {
        return this.dailyUseWorkdays;
    }

    public void setDailyUseWorkdays(Boolean dailyUseWorkdays) {
        this.dailyUseWorkdays = dailyUseWorkdays;
    }

    public RecurringInfo weeklyRepetitions(Integer weeklyRepetitions) {
        this.weeklyRepetitions = weeklyRepetitions;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies an interval between repetitions for the weekly recurrence pattern.")
    public Integer getWeeklyRepetitions() {
        return this.weeklyRepetitions;
    }

    public void setWeeklyRepetitions(Integer weeklyRepetitions) {
        this.weeklyRepetitions = weeklyRepetitions;
    }

    public RecurringInfo weeklyDays(WeekDayType weeklyDays) {
        this.weeklyDays = weeklyDays;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a collection of days used in the weekly recurrence pattern.")
    public WeekDayType getWeeklyDays() {
        return this.weeklyDays;
    }

    public void setWeeklyDays(WeekDayType weeklyDays) {
        this.weeklyDays = weeklyDays;
    }

    public RecurringInfo monthlyUseOrdinalDay(Boolean monthlyUseOrdinalDay) {
        this.monthlyUseOrdinalDay = monthlyUseOrdinalDay;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether to use ordinal day for the monthly recurrence pattern.")
    public Boolean isMonthlyUseOrdinalDay() {
        return this.monthlyUseOrdinalDay;
    }

    public void setMonthlyUseOrdinalDay(Boolean monthlyUseOrdinalDay) {
        this.monthlyUseOrdinalDay = monthlyUseOrdinalDay;
    }

    public RecurringInfo monthlyOrdinalNumber(OrdinalNumber monthlyOrdinalNumber) {
        this.monthlyOrdinalNumber = monthlyOrdinalNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies an ordinal number of the monthly recurrence pattern. Can be one of the values of  enum.")
    public OrdinalNumber getMonthlyOrdinalNumber() {
        return this.monthlyOrdinalNumber;
    }

    public void setMonthlyOrdinalNumber(OrdinalNumber monthlyOrdinalNumber) {
        this.monthlyOrdinalNumber = monthlyOrdinalNumber;
    }

    public RecurringInfo monthlyOrdinalDay(DayOfWeek monthlyOrdinalDay) {
        this.monthlyOrdinalDay = monthlyOrdinalDay;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a day of the monthly recurrence pattern when using ordinal day. Can be one of the values of  enum.")
    public DayOfWeek getMonthlyOrdinalDay() {
        return this.monthlyOrdinalDay;
    }

    public void setMonthlyOrdinalDay(DayOfWeek monthlyOrdinalDay) {
        this.monthlyOrdinalDay = monthlyOrdinalDay;
    }

    public RecurringInfo monthlyOrdinalRepetitions(Integer monthlyOrdinalRepetitions) {
        this.monthlyOrdinalRepetitions = monthlyOrdinalRepetitions;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a number of repetitions for the monthly recurrence pattern when using ordinal day.")
    public Integer getMonthlyOrdinalRepetitions() {
        return this.monthlyOrdinalRepetitions;
    }

    public void setMonthlyOrdinalRepetitions(Integer monthlyOrdinalRepetitions) {
        this.monthlyOrdinalRepetitions = monthlyOrdinalRepetitions;
    }

    public RecurringInfo monthlyDay(Integer monthlyDay) {
        this.monthlyDay = monthlyDay;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a number of day of the monthly recurrence pattern.")
    public Integer getMonthlyDay() {
        return this.monthlyDay;
    }

    public void setMonthlyDay(Integer monthlyDay) {
        this.monthlyDay = monthlyDay;
    }

    public RecurringInfo monthlyRepetitions(Integer monthlyRepetitions) {
        this.monthlyRepetitions = monthlyRepetitions;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a number of repetitions for the monthly recurrence pattern.")
    public Integer getMonthlyRepetitions() {
        return this.monthlyRepetitions;
    }

    public void setMonthlyRepetitions(Integer monthlyRepetitions) {
        this.monthlyRepetitions = monthlyRepetitions;
    }

    public RecurringInfo yearlyUseOrdinalDay(Boolean yearlyUseOrdinalDay) {
        this.yearlyUseOrdinalDay = yearlyUseOrdinalDay;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether to use ordinal day for the yearly recurrence pattern.")
    public Boolean isYearlyUseOrdinalDay() {
        return this.yearlyUseOrdinalDay;
    }

    public void setYearlyUseOrdinalDay(Boolean yearlyUseOrdinalDay) {
        this.yearlyUseOrdinalDay = yearlyUseOrdinalDay;
    }

    public RecurringInfo yearlyDate(OffsetDateTime yearlyDate) {
        this.yearlyDate = yearlyDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a date for the yearly recurrence pattern.")
    public OffsetDateTime getYearlyDate() {
        return this.yearlyDate;
    }

    public void setYearlyDate(OffsetDateTime yearlyDate) {
        this.yearlyDate = yearlyDate;
    }

    public RecurringInfo yearlyOrdinalNumber(OrdinalNumber yearlyOrdinalNumber) {
        this.yearlyOrdinalNumber = yearlyOrdinalNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies an ordinal number of the yearly recurrence pattern. Can be one of the values of  enum.")
    public OrdinalNumber getYearlyOrdinalNumber() {
        return this.yearlyOrdinalNumber;
    }

    public void setYearlyOrdinalNumber(OrdinalNumber yearlyOrdinalNumber) {
        this.yearlyOrdinalNumber = yearlyOrdinalNumber;
    }

    public RecurringInfo yearlyOrdinalDay(DayOfWeek yearlyOrdinalDay) {
        this.yearlyOrdinalDay = yearlyOrdinalDay;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a weekday of the yearly recurrence pattern when using ordinal day. Can be one of the values of  enum.")
    public DayOfWeek getYearlyOrdinalDay() {
        return this.yearlyOrdinalDay;
    }

    public void setYearlyOrdinalDay(DayOfWeek yearlyOrdinalDay) {
        this.yearlyOrdinalDay = yearlyOrdinalDay;
    }

    public RecurringInfo yearlyOrdinalMonth(Month yearlyOrdinalMonth) {
        this.yearlyOrdinalMonth = yearlyOrdinalMonth;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a month of the yearly recurrence pattern when using ordinal day. Can be one of the values of  enum.")
    public Month getYearlyOrdinalMonth() {
        return this.yearlyOrdinalMonth;
    }

    public void setYearlyOrdinalMonth(Month yearlyOrdinalMonth) {
        this.yearlyOrdinalMonth = yearlyOrdinalMonth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringInfo recurringInfo = (RecurringInfo)o;
        return Objects.equals((Object)this.recurrencePattern, (Object)recurringInfo.recurrencePattern) && Objects.equals(this.startDate, recurringInfo.startDate) && Objects.equals(this.endDate, recurringInfo.endDate) && Objects.equals(this.duration, recurringInfo.duration) && Objects.equals(this.occurrences, recurringInfo.occurrences) && Objects.equals(this.useEndDate, recurringInfo.useEndDate) && Objects.equals(this.dailyRepetitions, recurringInfo.dailyRepetitions) && Objects.equals(this.dailyUseWorkdays, recurringInfo.dailyUseWorkdays) && Objects.equals(this.weeklyRepetitions, recurringInfo.weeklyRepetitions) && Objects.equals((Object)this.weeklyDays, (Object)recurringInfo.weeklyDays) && Objects.equals(this.monthlyUseOrdinalDay, recurringInfo.monthlyUseOrdinalDay) && Objects.equals((Object)this.monthlyOrdinalNumber, (Object)recurringInfo.monthlyOrdinalNumber) && Objects.equals((Object)this.monthlyOrdinalDay, (Object)recurringInfo.monthlyOrdinalDay) && Objects.equals(this.monthlyOrdinalRepetitions, recurringInfo.monthlyOrdinalRepetitions) && Objects.equals(this.monthlyDay, recurringInfo.monthlyDay) && Objects.equals(this.monthlyRepetitions, recurringInfo.monthlyRepetitions) && Objects.equals(this.yearlyUseOrdinalDay, recurringInfo.yearlyUseOrdinalDay) && Objects.equals(this.yearlyDate, recurringInfo.yearlyDate) && Objects.equals((Object)this.yearlyOrdinalNumber, (Object)recurringInfo.yearlyOrdinalNumber) && Objects.equals((Object)this.yearlyOrdinalDay, (Object)recurringInfo.yearlyOrdinalDay) && Objects.equals((Object)this.yearlyOrdinalMonth, (Object)recurringInfo.yearlyOrdinalMonth);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recurrencePattern, this.startDate, this.endDate, this.duration, this.occurrences, this.useEndDate, this.dailyRepetitions, this.dailyUseWorkdays, this.weeklyRepetitions, this.weeklyDays, this.monthlyUseOrdinalDay, this.monthlyOrdinalNumber, this.monthlyOrdinalDay, this.monthlyOrdinalRepetitions, this.monthlyDay, this.monthlyRepetitions, this.yearlyUseOrdinalDay, this.yearlyDate, this.yearlyOrdinalNumber, this.yearlyOrdinalDay, this.yearlyOrdinalMonth});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringInfo {\n");
        sb.append("    recurrencePattern: ").append(this.toIndentedString((Object)this.recurrencePattern)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    occurrences: ").append(this.toIndentedString(this.occurrences)).append("\n");
        sb.append("    useEndDate: ").append(this.toIndentedString(this.useEndDate)).append("\n");
        sb.append("    dailyRepetitions: ").append(this.toIndentedString(this.dailyRepetitions)).append("\n");
        sb.append("    dailyUseWorkdays: ").append(this.toIndentedString(this.dailyUseWorkdays)).append("\n");
        sb.append("    weeklyRepetitions: ").append(this.toIndentedString(this.weeklyRepetitions)).append("\n");
        sb.append("    weeklyDays: ").append(this.toIndentedString((Object)this.weeklyDays)).append("\n");
        sb.append("    monthlyUseOrdinalDay: ").append(this.toIndentedString(this.monthlyUseOrdinalDay)).append("\n");
        sb.append("    monthlyOrdinalNumber: ").append(this.toIndentedString((Object)this.monthlyOrdinalNumber)).append("\n");
        sb.append("    monthlyOrdinalDay: ").append(this.toIndentedString((Object)this.monthlyOrdinalDay)).append("\n");
        sb.append("    monthlyOrdinalRepetitions: ").append(this.toIndentedString(this.monthlyOrdinalRepetitions)).append("\n");
        sb.append("    monthlyDay: ").append(this.toIndentedString(this.monthlyDay)).append("\n");
        sb.append("    monthlyRepetitions: ").append(this.toIndentedString(this.monthlyRepetitions)).append("\n");
        sb.append("    yearlyUseOrdinalDay: ").append(this.toIndentedString(this.yearlyUseOrdinalDay)).append("\n");
        sb.append("    yearlyDate: ").append(this.toIndentedString(this.yearlyDate)).append("\n");
        sb.append("    yearlyOrdinalNumber: ").append(this.toIndentedString((Object)this.yearlyOrdinalNumber)).append("\n");
        sb.append("    yearlyOrdinalDay: ").append(this.toIndentedString((Object)this.yearlyOrdinalDay)).append("\n");
        sb.append("    yearlyOrdinalMonth: ").append(this.toIndentedString((Object)this.yearlyOrdinalMonth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

