/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.Baseline;
import com.aspose.tasks.cloud.model.BookingType;
import com.aspose.tasks.cloud.model.CostAccrualType;
import com.aspose.tasks.cloud.model.ExtendedAttribute;
import com.aspose.tasks.cloud.model.OutlineCode;
import com.aspose.tasks.cloud.model.RateFormatType;
import com.aspose.tasks.cloud.model.ResourceType;
import com.aspose.tasks.cloud.model.WorkGroupType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents a project resource.")
public class Resource {
    @SerializedName(value="IsRoot")
    private Boolean isRoot = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="Uid")
    private Integer uid = null;
    @SerializedName(value="Id")
    private Integer id = null;
    @SerializedName(value="Guid")
    private String guid = null;
    @SerializedName(value="Type")
    private ResourceType type = null;
    @SerializedName(value="IsNull")
    private Boolean isNull = null;
    @SerializedName(value="Initials")
    private String initials = null;
    @SerializedName(value="Phonetics")
    private String phonetics = null;
    @SerializedName(value="NtAccount")
    private String ntAccount = null;
    @SerializedName(value="WindowsUserAccount")
    private String windowsUserAccount = null;
    @SerializedName(value="Workgroup")
    private WorkGroupType workgroup = null;
    @SerializedName(value="MaterialLabel")
    private String materialLabel = null;
    @SerializedName(value="Code")
    private String code = null;
    @SerializedName(value="Group")
    private String group = null;
    @SerializedName(value="EmailAddress")
    private String emailAddress = null;
    @SerializedName(value="Hyperlink")
    private String hyperlink = null;
    @SerializedName(value="HyperlinkAddress")
    private String hyperlinkAddress = null;
    @SerializedName(value="HyperlinkSubAddress")
    private String hyperlinkSubAddress = null;
    @SerializedName(value="MaxUnits")
    private Double maxUnits = 1.0;
    @SerializedName(value="PeakUnits")
    private Double peakUnits = null;
    @SerializedName(value="OverAllocated")
    private Boolean overAllocated = null;
    @SerializedName(value="AvailableFrom")
    private OffsetDateTime availableFrom = null;
    @SerializedName(value="AvailableTo")
    private OffsetDateTime availableTo = null;
    @SerializedName(value="Start")
    private OffsetDateTime start = null;
    @SerializedName(value="Finish")
    private OffsetDateTime finish = null;
    @SerializedName(value="CanLevel")
    private Boolean canLevel = true;
    @SerializedName(value="AccrueAt")
    private CostAccrualType accrueAt = null;
    @SerializedName(value="Work")
    private String work = null;
    @SerializedName(value="RegularWork")
    private String regularWork = null;
    @SerializedName(value="OvertimeWork")
    private String overtimeWork = null;
    @SerializedName(value="ActualWork")
    private String actualWork = null;
    @SerializedName(value="RemainingWork")
    private String remainingWork = null;
    @SerializedName(value="ActualOvertimeWork")
    private String actualOvertimeWork = null;
    @SerializedName(value="RemainingOvertimeWork")
    private String remainingOvertimeWork = null;
    @SerializedName(value="PercentWorkComplete")
    private Integer percentWorkComplete = null;
    @SerializedName(value="StandardRate")
    private BigDecimal standardRate = null;
    @SerializedName(value="StandardRateFormat")
    private RateFormatType standardRateFormat = null;
    @SerializedName(value="Cost")
    private BigDecimal cost = null;
    @SerializedName(value="OvertimeRateFormat")
    private RateFormatType overtimeRateFormat = null;
    @SerializedName(value="OvertimeCost")
    private BigDecimal overtimeCost = null;
    @SerializedName(value="CostPerUse")
    private BigDecimal costPerUse = null;
    @SerializedName(value="ActualCost")
    private BigDecimal actualCost = null;
    @SerializedName(value="ActualOvertimeCost")
    private BigDecimal actualOvertimeCost = null;
    @SerializedName(value="RemainingCost")
    private BigDecimal remainingCost = null;
    @SerializedName(value="RemainingOvertimeCost")
    private BigDecimal remainingOvertimeCost = null;
    @SerializedName(value="WorkVariance")
    private Double workVariance = null;
    @SerializedName(value="CostVariance")
    private Double costVariance = null;
    @SerializedName(value="Sv")
    private Double sv = null;
    @SerializedName(value="Cv")
    private Double cv = null;
    @SerializedName(value="Acwp")
    private Double acwp = null;
    @SerializedName(value="CalendarUid")
    private Integer calendarUid = null;
    @SerializedName(value="NotesText")
    private String notesText = null;
    @SerializedName(value="Notes")
    private String notes = null;
    @SerializedName(value="NotesRTF")
    private String notesRTF = null;
    @SerializedName(value="Bcws")
    private Double bcws = null;
    @SerializedName(value="Bcwp")
    private Double bcwp = null;
    @SerializedName(value="IsGeneric")
    private Boolean isGeneric = null;
    @SerializedName(value="IsInactive")
    private Boolean isInactive = null;
    @SerializedName(value="IsEnterprise")
    private Boolean isEnterprise = null;
    @SerializedName(value="BookingType")
    private BookingType bookingType = null;
    @SerializedName(value="ActualWorkProtected")
    private String actualWorkProtected = null;
    @SerializedName(value="ActualOvertimeWorkProtected")
    private String actualOvertimeWorkProtected = null;
    @SerializedName(value="ActiveDirectoryGuid")
    private String activeDirectoryGuid = null;
    @SerializedName(value="CreationDate")
    private OffsetDateTime creationDate = null;
    @SerializedName(value="CostCenter")
    private String costCenter = null;
    @SerializedName(value="IsCostResource")
    private Boolean isCostResource = null;
    @SerializedName(value="TeamAssignmentPool")
    private Boolean teamAssignmentPool = null;
    @SerializedName(value="AssignmentOwner")
    private String assignmentOwner = null;
    @SerializedName(value="AssignmentOwnerGuid")
    private String assignmentOwnerGuid = null;
    @SerializedName(value="IsBudget")
    private Boolean isBudget = null;
    @SerializedName(value="BudgetWork")
    private String budgetWork = null;
    @SerializedName(value="BudgetCost")
    private BigDecimal budgetCost = null;
    @SerializedName(value="OvertimeRate")
    private BigDecimal overtimeRate = null;
    @SerializedName(value="Baselines")
    private List<Baseline> baselines = null;
    @SerializedName(value="ExtendedAttributes")
    private List<ExtendedAttribute> extendedAttributes = null;
    @SerializedName(value="OutlineCodes")
    private List<OutlineCode> outlineCodes = null;

    public Resource isRoot(Boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    @ApiModelProperty(required=true, value="        Gets the flag indicating whether resource is a root resource. Root resource is         a special resource which is intended to support internals of MS Project's formats         and is not intended to be used directly from the user's code.     ")
    public Boolean isIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
    }

    public Resource name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of a resource.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource uid(Integer uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of a resource.")
    public Integer getUid() {
        return this.uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public Resource id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The position identifier of a resource within the list of resources.")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Resource guid(String guid) {
        this.guid = guid;
        return this;
    }

    @ApiModelProperty(value="Contains the generated unique identification code for the resource.             ")
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Resource type(ResourceType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of a resource.")
    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public Resource isNull(Boolean isNull) {
        this.isNull = isNull;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a resource is null.")
    public Boolean isIsNull() {
        return this.isNull;
    }

    public void setIsNull(Boolean isNull) {
        this.isNull = isNull;
    }

    public Resource initials(String initials) {
        this.initials = initials;
        return this;
    }

    @ApiModelProperty(value="The initials of a resource.")
    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    public Resource phonetics(String phonetics) {
        this.phonetics = phonetics;
        return this;
    }

    @ApiModelProperty(value="The phonetic spelling of the resource name. For use with Japanese only.")
    public String getPhonetics() {
        return this.phonetics;
    }

    public void setPhonetics(String phonetics) {
        this.phonetics = phonetics;
    }

    public Resource ntAccount(String ntAccount) {
        this.ntAccount = ntAccount;
        return this;
    }

    @ApiModelProperty(value="The NT account associated with a resource.")
    public String getNtAccount() {
        return this.ntAccount;
    }

    public void setNtAccount(String ntAccount) {
        this.ntAccount = ntAccount;
    }

    public Resource windowsUserAccount(String windowsUserAccount) {
        this.windowsUserAccount = windowsUserAccount;
        return this;
    }

    @ApiModelProperty(value="The NT account associated with a resource.")
    public String getWindowsUserAccount() {
        return this.windowsUserAccount;
    }

    public void setWindowsUserAccount(String windowsUserAccount) {
        this.windowsUserAccount = windowsUserAccount;
    }

    public Resource workgroup(WorkGroupType workgroup) {
        this.workgroup = workgroup;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of a workgroup to which a resource belongs.  type.")
    public WorkGroupType getWorkgroup() {
        return this.workgroup;
    }

    public void setWorkgroup(WorkGroupType workgroup) {
        this.workgroup = workgroup;
    }

    public Resource materialLabel(String materialLabel) {
        this.materialLabel = materialLabel;
        return this;
    }

    @ApiModelProperty(value="The unit of measure for the material resource. Read/write String.")
    public String getMaterialLabel() {
        return this.materialLabel;
    }

    public void setMaterialLabel(String materialLabel) {
        this.materialLabel = materialLabel;
    }

    public Resource code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="The code or other information about a resource.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Resource group(String group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="The group to which a resource belongs.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Resource emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Resource hyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
        return this;
    }

    @ApiModelProperty(value="The title of a hyperlink associated with a resource.")
    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
    }

    public Resource hyperlinkAddress(String hyperlinkAddress) {
        this.hyperlinkAddress = hyperlinkAddress;
        return this;
    }

    @ApiModelProperty(value="The hyperlink associated with a resource.")
    public String getHyperlinkAddress() {
        return this.hyperlinkAddress;
    }

    public void setHyperlinkAddress(String hyperlinkAddress) {
        this.hyperlinkAddress = hyperlinkAddress;
    }

    public Resource hyperlinkSubAddress(String hyperlinkSubAddress) {
        this.hyperlinkSubAddress = hyperlinkSubAddress;
        return this;
    }

    @ApiModelProperty(value="The document bookmark of a hyperlink associated with a resource. Read/write String.")
    public String getHyperlinkSubAddress() {
        return this.hyperlinkSubAddress;
    }

    public void setHyperlinkSubAddress(String hyperlinkSubAddress) {
        this.hyperlinkSubAddress = hyperlinkSubAddress;
    }

    public Resource maxUnits(Double maxUnits) {
        this.maxUnits = maxUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="The maximum number of units of a resource is available.")
    public Double getMaxUnits() {
        return this.maxUnits;
    }

    public void setMaxUnits(Double maxUnits) {
        this.maxUnits = maxUnits;
    }

    public Resource peakUnits(Double peakUnits) {
        this.peakUnits = peakUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="The largest number of units assigned to a resource at any time.")
    public Double getPeakUnits() {
        return this.peakUnits;
    }

    public void setPeakUnits(Double peakUnits) {
        this.peakUnits = peakUnits;
    }

    public Resource overAllocated(Boolean overAllocated) {
        this.overAllocated = overAllocated;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Boolean isOverAllocated() {
        return this.overAllocated;
    }

    public void setOverAllocated(Boolean overAllocated) {
        this.overAllocated = overAllocated;
    }

    public Resource availableFrom(OffsetDateTime availableFrom) {
        this.availableFrom = availableFrom;
        return this;
    }

    @ApiModelProperty(required=true, value="The first date when a resource is available.")
    public OffsetDateTime getAvailableFrom() {
        return this.availableFrom;
    }

    public void setAvailableFrom(OffsetDateTime availableFrom) {
        this.availableFrom = availableFrom;
    }

    public Resource availableTo(OffsetDateTime availableTo) {
        this.availableTo = availableTo;
        return this;
    }

    @ApiModelProperty(required=true, value="The last date when a resource is available.")
    public OffsetDateTime getAvailableTo() {
        return this.availableTo;
    }

    public void setAvailableTo(OffsetDateTime availableTo) {
        this.availableTo = availableTo;
    }

    public Resource start(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(required=true, value="The scheduled start date of a resource.")
    public OffsetDateTime getStart() {
        return this.start;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public Resource finish(OffsetDateTime finish) {
        this.finish = finish;
        return this;
    }

    @ApiModelProperty(required=true, value="The scheduled finish date of a resource.")
    public OffsetDateTime getFinish() {
        return this.finish;
    }

    public void setFinish(OffsetDateTime finish) {
        this.finish = finish;
    }

    public Resource canLevel(Boolean canLevel) {
        this.canLevel = canLevel;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a resource can be leveled.")
    public Boolean isCanLevel() {
        return this.canLevel;
    }

    public void setCanLevel(Boolean canLevel) {
        this.canLevel = canLevel;
    }

    public Resource accrueAt(CostAccrualType accrueAt) {
        this.accrueAt = accrueAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines how cost is accrued against the resource.")
    public CostAccrualType getAccrueAt() {
        return this.accrueAt;
    }

    public void setAccrueAt(CostAccrualType accrueAt) {
        this.accrueAt = accrueAt;
    }

    public Resource work(String work) {
        this.work = work;
        return this;
    }

    @ApiModelProperty(required=true, value="The total work assigned to a resource across all assigned tasks.")
    public String getWork() {
        return this.work;
    }

    public void setWork(String work) {
        this.work = work;
    }

    public Resource regularWork(String regularWork) {
        this.regularWork = regularWork;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of non-overtime work assigned to a resource.")
    public String getRegularWork() {
        return this.regularWork;
    }

    public void setRegularWork(String regularWork) {
        this.regularWork = regularWork;
    }

    public Resource overtimeWork(String overtimeWork) {
        this.overtimeWork = overtimeWork;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of overtime work assigned to a resource.")
    public String getOvertimeWork() {
        return this.overtimeWork;
    }

    public void setOvertimeWork(String overtimeWork) {
        this.overtimeWork = overtimeWork;
    }

    public Resource actualWork(String actualWork) {
        this.actualWork = actualWork;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of actual work performed by a resource.")
    public String getActualWork() {
        return this.actualWork;
    }

    public void setActualWork(String actualWork) {
        this.actualWork = actualWork;
    }

    public Resource remainingWork(String remainingWork) {
        this.remainingWork = remainingWork;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of remaining work required to complete all assigned tasks.")
    public String getRemainingWork() {
        return this.remainingWork;
    }

    public void setRemainingWork(String remainingWork) {
        this.remainingWork = remainingWork;
    }

    public Resource actualOvertimeWork(String actualOvertimeWork) {
        this.actualOvertimeWork = actualOvertimeWork;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of actual overtime work performed by a resource.")
    public String getActualOvertimeWork() {
        return this.actualOvertimeWork;
    }

    public void setActualOvertimeWork(String actualOvertimeWork) {
        this.actualOvertimeWork = actualOvertimeWork;
    }

    public Resource remainingOvertimeWork(String remainingOvertimeWork) {
        this.remainingOvertimeWork = remainingOvertimeWork;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of remaining overtime work required to complete all tasks.")
    public String getRemainingOvertimeWork() {
        return this.remainingOvertimeWork;
    }

    public void setRemainingOvertimeWork(String remainingOvertimeWork) {
        this.remainingOvertimeWork = remainingOvertimeWork;
    }

    public Resource percentWorkComplete(Integer percentWorkComplete) {
        this.percentWorkComplete = percentWorkComplete;
        return this;
    }

    @ApiModelProperty(required=true, value="The percentage of work completed across all tasks.")
    public Integer getPercentWorkComplete() {
        return this.percentWorkComplete;
    }

    public void setPercentWorkComplete(Integer percentWorkComplete) {
        this.percentWorkComplete = percentWorkComplete;
    }

    public Resource standardRate(BigDecimal standardRate) {
        this.standardRate = standardRate;
        return this;
    }

    @ApiModelProperty(required=true, value="The standard rate of a resource. This value retrieved from the current date if a rate table exists for a resource.")
    public BigDecimal getStandardRate() {
        return this.standardRate;
    }

    public void setStandardRate(BigDecimal standardRate) {
        this.standardRate = standardRate;
    }

    public Resource standardRateFormat(RateFormatType standardRateFormat) {
        this.standardRateFormat = standardRateFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="The units used by Microsoft Project to display the standard rate.")
    public RateFormatType getStandardRateFormat() {
        return this.standardRateFormat;
    }

    public void setStandardRateFormat(RateFormatType standardRateFormat) {
        this.standardRateFormat = standardRateFormat;
    }

    public Resource cost(BigDecimal cost) {
        this.cost = cost;
        return this;
    }

    @ApiModelProperty(required=true, value="The total project cost for a resource across all assigned tasks.")
    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public Resource overtimeRateFormat(RateFormatType overtimeRateFormat) {
        this.overtimeRateFormat = overtimeRateFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="The units used by Microsoft Project to display the overtime rate.")
    public RateFormatType getOvertimeRateFormat() {
        return this.overtimeRateFormat;
    }

    public void setOvertimeRateFormat(RateFormatType overtimeRateFormat) {
        this.overtimeRateFormat = overtimeRateFormat;
    }

    public Resource overtimeCost(BigDecimal overtimeCost) {
        this.overtimeCost = overtimeCost;
        return this;
    }

    @ApiModelProperty(required=true, value="The total overtime cost of a resource including actual and remaining overtime costs.")
    public BigDecimal getOvertimeCost() {
        return this.overtimeCost;
    }

    public void setOvertimeCost(BigDecimal overtimeCost) {
        this.overtimeCost = overtimeCost;
    }

    public Resource costPerUse(BigDecimal costPerUse) {
        this.costPerUse = costPerUse;
        return this;
    }

    @ApiModelProperty(required=true, value="The cost per use of a resource. This value retrieved from the current date if a rate table exists for the resource.")
    public BigDecimal getCostPerUse() {
        return this.costPerUse;
    }

    public void setCostPerUse(BigDecimal costPerUse) {
        this.costPerUse = costPerUse;
    }

    public Resource actualCost(BigDecimal actualCost) {
        this.actualCost = actualCost;
        return this;
    }

    @ApiModelProperty(required=true, value="The actual cost incurred by the resource across all assigned tasks.")
    public BigDecimal getActualCost() {
        return this.actualCost;
    }

    public void setActualCost(BigDecimal actualCost) {
        this.actualCost = actualCost;
    }

    public Resource actualOvertimeCost(BigDecimal actualOvertimeCost) {
        this.actualOvertimeCost = actualOvertimeCost;
        return this;
    }

    @ApiModelProperty(required=true, value="The actual overtime cost incurred by the resource across all assigned tasks.")
    public BigDecimal getActualOvertimeCost() {
        return this.actualOvertimeCost;
    }

    public void setActualOvertimeCost(BigDecimal actualOvertimeCost) {
        this.actualOvertimeCost = actualOvertimeCost;
    }

    public Resource remainingCost(BigDecimal remainingCost) {
        this.remainingCost = remainingCost;
        return this;
    }

    @ApiModelProperty(required=true, value="The remaining projected cost of a resource to complete all assigned tasks.")
    public BigDecimal getRemainingCost() {
        return this.remainingCost;
    }

    public void setRemainingCost(BigDecimal remainingCost) {
        this.remainingCost = remainingCost;
    }

    public Resource remainingOvertimeCost(BigDecimal remainingOvertimeCost) {
        this.remainingOvertimeCost = remainingOvertimeCost;
        return this;
    }

    @ApiModelProperty(required=true, value="The remaining projected overtime cost of a resource to complete all assigned tasks.")
    public BigDecimal getRemainingOvertimeCost() {
        return this.remainingOvertimeCost;
    }

    public void setRemainingOvertimeCost(BigDecimal remainingOvertimeCost) {
        this.remainingOvertimeCost = remainingOvertimeCost;
    }

    public Resource workVariance(Double workVariance) {
        this.workVariance = workVariance;
        return this;
    }

    @ApiModelProperty(required=true, value="The difference between a baseline work and a work")
    public Double getWorkVariance() {
        return this.workVariance;
    }

    public void setWorkVariance(Double workVariance) {
        this.workVariance = workVariance;
    }

    public Resource costVariance(Double costVariance) {
        this.costVariance = costVariance;
        return this;
    }

    @ApiModelProperty(required=true, value="The difference between a baseline cost and a cost.")
    public Double getCostVariance() {
        return this.costVariance;
    }

    public void setCostVariance(Double costVariance) {
        this.costVariance = costVariance;
    }

    public Resource sv(Double sv) {
        this.sv = sv;
        return this;
    }

    @ApiModelProperty(required=true, value="The earned value schedule variance, through the project status date.")
    public Double getSv() {
        return this.sv;
    }

    public void setSv(Double sv) {
        this.sv = sv;
    }

    public Resource cv(Double cv) {
        this.cv = cv;
        return this;
    }

    @ApiModelProperty(required=true, value="The earned value cost variance, through the project status date.")
    public Double getCv() {
        return this.cv;
    }

    public void setCv(Double cv) {
        this.cv = cv;
    }

    public Resource acwp(Double acwp) {
        this.acwp = acwp;
        return this;
    }

    @ApiModelProperty(required=true, value="The actual cost of a work performed by a resource for the project to-date.")
    public Double getAcwp() {
        return this.acwp;
    }

    public void setAcwp(Double acwp) {
        this.acwp = acwp;
    }

    public Resource calendarUid(Integer calendarUid) {
        this.calendarUid = calendarUid;
        return this;
    }

    @ApiModelProperty(required=true, value="The calendar of a resource.")
    public Integer getCalendarUid() {
        return this.calendarUid;
    }

    public void setCalendarUid(Integer calendarUid) {
        this.calendarUid = calendarUid;
    }

    public Resource notesText(String notesText) {
        this.notesText = notesText;
        return this;
    }

    @ApiModelProperty(value="Notes' plain text extracted from RTF data.")
    public String getNotesText() {
        return this.notesText;
    }

    public void setNotesText(String notesText) {
        this.notesText = notesText;
    }

    public Resource notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="The text notes associated with a resource.")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Resource notesRTF(String notesRTF) {
        this.notesRTF = notesRTF;
        return this;
    }

    @ApiModelProperty(value="The text notes in RTF format. Supported for MPP formats only.")
    public String getNotesRTF() {
        return this.notesRTF;
    }

    public void setNotesRTF(String notesRTF) {
        this.notesRTF = notesRTF;
    }

    public Resource bcws(Double bcws) {
        this.bcws = bcws;
        return this;
    }

    @ApiModelProperty(required=true, value="The budget cost of a work scheduled for a resource.")
    public Double getBcws() {
        return this.bcws;
    }

    public void setBcws(Double bcws) {
        this.bcws = bcws;
    }

    public Resource bcwp(Double bcwp) {
        this.bcwp = bcwp;
        return this;
    }

    @ApiModelProperty(required=true, value="The budgeted cost of a work performed by a resource for the project to-date.")
    public Double getBcwp() {
        return this.bcwp;
    }

    public void setBcwp(Double bcwp) {
        this.bcwp = bcwp;
    }

    public Resource isGeneric(Boolean isGeneric) {
        this.isGeneric = isGeneric;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a resource is generic.")
    public Boolean isIsGeneric() {
        return this.isGeneric;
    }

    public void setIsGeneric(Boolean isGeneric) {
        this.isGeneric = isGeneric;
    }

    public Resource isInactive(Boolean isInactive) {
        this.isInactive = isInactive;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a resource is inactive.")
    public Boolean isIsInactive() {
        return this.isInactive;
    }

    public void setIsInactive(Boolean isInactive) {
        this.isInactive = isInactive;
    }

    public Resource isEnterprise(Boolean isEnterprise) {
        this.isEnterprise = isEnterprise;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a resource is an Enterprise resource.")
    public Boolean isIsEnterprise() {
        return this.isEnterprise;
    }

    public void setIsEnterprise(Boolean isEnterprise) {
        this.isEnterprise = isEnterprise;
    }

    public Resource bookingType(BookingType bookingType) {
        this.bookingType = bookingType;
        return this;
    }

    @ApiModelProperty(required=true, value="The booking type of a resource.")
    public BookingType getBookingType() {
        return this.bookingType;
    }

    public void setBookingType(BookingType bookingType) {
        this.bookingType = bookingType;
    }

    public Resource actualWorkProtected(String actualWorkProtected) {
        this.actualWorkProtected = actualWorkProtected;
        return this;
    }

    @ApiModelProperty(required=true, value="The duration through which actual work is protected.")
    public String getActualWorkProtected() {
        return this.actualWorkProtected;
    }

    public void setActualWorkProtected(String actualWorkProtected) {
        this.actualWorkProtected = actualWorkProtected;
    }

    public Resource actualOvertimeWorkProtected(String actualOvertimeWorkProtected) {
        this.actualOvertimeWorkProtected = actualOvertimeWorkProtected;
        return this;
    }

    @ApiModelProperty(required=true, value="The duration through which actual overtime work is protected.")
    public String getActualOvertimeWorkProtected() {
        return this.actualOvertimeWorkProtected;
    }

    public void setActualOvertimeWorkProtected(String actualOvertimeWorkProtected) {
        this.actualOvertimeWorkProtected = actualOvertimeWorkProtected;
    }

    public Resource activeDirectoryGuid(String activeDirectoryGuid) {
        this.activeDirectoryGuid = activeDirectoryGuid;
        return this;
    }

    @ApiModelProperty(value="The Active Directory Guid for a resource.")
    public String getActiveDirectoryGuid() {
        return this.activeDirectoryGuid;
    }

    public void setActiveDirectoryGuid(String activeDirectoryGuid) {
        this.activeDirectoryGuid = activeDirectoryGuid;
    }

    public Resource creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date when a resource was created.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public Resource costCenter(String costCenter) {
        this.costCenter = costCenter;
        return this;
    }

    @ApiModelProperty(value="Indicates which cost center the costs accrued by the resource should be charged to.")
    public String getCostCenter() {
        return this.costCenter;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    public Resource isCostResource(Boolean isCostResource) {
        this.isCostResource = isCostResource;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a resource is a cost resource.")
    public Boolean isIsCostResource() {
        return this.isCostResource;
    }

    public void setIsCostResource(Boolean isCostResource) {
        this.isCostResource = isCostResource;
    }

    public Resource teamAssignmentPool(Boolean teamAssignmentPool) {
        this.teamAssignmentPool = teamAssignmentPool;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the current resource is a team resource.             ")
    public Boolean isTeamAssignmentPool() {
        return this.teamAssignmentPool;
    }

    public void setTeamAssignmentPool(Boolean teamAssignmentPool) {
        this.teamAssignmentPool = teamAssignmentPool;
    }

    public Resource assignmentOwner(String assignmentOwner) {
        this.assignmentOwner = assignmentOwner;
        return this;
    }

    @ApiModelProperty(value="The name of an assignment owner.")
    public String getAssignmentOwner() {
        return this.assignmentOwner;
    }

    public void setAssignmentOwner(String assignmentOwner) {
        this.assignmentOwner = assignmentOwner;
    }

    public Resource assignmentOwnerGuid(String assignmentOwnerGuid) {
        this.assignmentOwnerGuid = assignmentOwnerGuid;
        return this;
    }

    @ApiModelProperty(value="The GUID of an assignment owner.")
    public String getAssignmentOwnerGuid() {
        return this.assignmentOwnerGuid;
    }

    public void setAssignmentOwnerGuid(String assignmentOwnerGuid) {
        this.assignmentOwnerGuid = assignmentOwnerGuid;
    }

    public Resource isBudget(Boolean isBudget) {
        this.isBudget = isBudget;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a resource is a budget resource.")
    public Boolean isIsBudget() {
        return this.isBudget;
    }

    public void setIsBudget(Boolean isBudget) {
        this.isBudget = isBudget;
    }

    public Resource budgetWork(String budgetWork) {
        this.budgetWork = budgetWork;
        return this;
    }

    @ApiModelProperty(required=true, value="The budget work for a budget work or material resource.")
    public String getBudgetWork() {
        return this.budgetWork;
    }

    public void setBudgetWork(String budgetWork) {
        this.budgetWork = budgetWork;
    }

    public Resource budgetCost(BigDecimal budgetCost) {
        this.budgetCost = budgetCost;
        return this;
    }

    @ApiModelProperty(required=true, value="The budget cost for a budget cost resource.")
    public BigDecimal getBudgetCost() {
        return this.budgetCost;
    }

    public void setBudgetCost(BigDecimal budgetCost) {
        this.budgetCost = budgetCost;
    }

    public Resource overtimeRate(BigDecimal overtimeRate) {
        this.overtimeRate = overtimeRate;
        return this;
    }

    @ApiModelProperty(required=true, value="The overtime rate of a resource. This value retrieved from the current date if a rate table exists for a resource.")
    public BigDecimal getOvertimeRate() {
        return this.overtimeRate;
    }

    public void setOvertimeRate(BigDecimal overtimeRate) {
        this.overtimeRate = overtimeRate;
    }

    public Resource baselines(List<Baseline> baselines) {
        this.baselines = baselines;
        return this;
    }

    public Resource addBaselinesItem(Baseline baselinesItem) {
        if (this.baselines == null) {
            this.baselines = new ArrayList<Baseline>();
        }
        this.baselines.add(baselinesItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the collection of baseline values of the resource.")
    public List<Baseline> getBaselines() {
        return this.baselines;
    }

    public void setBaselines(List<Baseline> baselines) {
        this.baselines = baselines;
    }

    public Resource extendedAttributes(List<ExtendedAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
        return this;
    }

    public Resource addExtendedAttributesItem(ExtendedAttribute extendedAttributesItem) {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new ArrayList<ExtendedAttribute>();
        }
        this.extendedAttributes.add(extendedAttributesItem);
        return this;
    }

    @ApiModelProperty(value="Resource extended attributes.")
    public List<ExtendedAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<ExtendedAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    public Resource outlineCodes(List<OutlineCode> outlineCodes) {
        this.outlineCodes = outlineCodes;
        return this;
    }

    public Resource addOutlineCodesItem(OutlineCode outlineCodesItem) {
        if (this.outlineCodes == null) {
            this.outlineCodes = new ArrayList<OutlineCode>();
        }
        this.outlineCodes.add(outlineCodesItem);
        return this;
    }

    @ApiModelProperty(value="Resource outline codes.")
    public List<OutlineCode> getOutlineCodes() {
        return this.outlineCodes;
    }

    public void setOutlineCodes(List<OutlineCode> outlineCodes) {
        this.outlineCodes = outlineCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.isRoot, resource.isRoot) && Objects.equals(this.name, resource.name) && Objects.equals(this.uid, resource.uid) && Objects.equals(this.id, resource.id) && Objects.equals(this.guid, resource.guid) && Objects.equals((Object)this.type, (Object)resource.type) && Objects.equals(this.isNull, resource.isNull) && Objects.equals(this.initials, resource.initials) && Objects.equals(this.phonetics, resource.phonetics) && Objects.equals(this.ntAccount, resource.ntAccount) && Objects.equals(this.windowsUserAccount, resource.windowsUserAccount) && Objects.equals((Object)this.workgroup, (Object)resource.workgroup) && Objects.equals(this.materialLabel, resource.materialLabel) && Objects.equals(this.code, resource.code) && Objects.equals(this.group, resource.group) && Objects.equals(this.emailAddress, resource.emailAddress) && Objects.equals(this.hyperlink, resource.hyperlink) && Objects.equals(this.hyperlinkAddress, resource.hyperlinkAddress) && Objects.equals(this.hyperlinkSubAddress, resource.hyperlinkSubAddress) && Objects.equals(this.maxUnits, resource.maxUnits) && Objects.equals(this.peakUnits, resource.peakUnits) && Objects.equals(this.overAllocated, resource.overAllocated) && Objects.equals(this.availableFrom, resource.availableFrom) && Objects.equals(this.availableTo, resource.availableTo) && Objects.equals(this.start, resource.start) && Objects.equals(this.finish, resource.finish) && Objects.equals(this.canLevel, resource.canLevel) && Objects.equals((Object)this.accrueAt, (Object)resource.accrueAt) && Objects.equals(this.work, resource.work) && Objects.equals(this.regularWork, resource.regularWork) && Objects.equals(this.overtimeWork, resource.overtimeWork) && Objects.equals(this.actualWork, resource.actualWork) && Objects.equals(this.remainingWork, resource.remainingWork) && Objects.equals(this.actualOvertimeWork, resource.actualOvertimeWork) && Objects.equals(this.remainingOvertimeWork, resource.remainingOvertimeWork) && Objects.equals(this.percentWorkComplete, resource.percentWorkComplete) && Objects.equals(this.standardRate, resource.standardRate) && Objects.equals((Object)this.standardRateFormat, (Object)resource.standardRateFormat) && Objects.equals(this.cost, resource.cost) && Objects.equals((Object)this.overtimeRateFormat, (Object)resource.overtimeRateFormat) && Objects.equals(this.overtimeCost, resource.overtimeCost) && Objects.equals(this.costPerUse, resource.costPerUse) && Objects.equals(this.actualCost, resource.actualCost) && Objects.equals(this.actualOvertimeCost, resource.actualOvertimeCost) && Objects.equals(this.remainingCost, resource.remainingCost) && Objects.equals(this.remainingOvertimeCost, resource.remainingOvertimeCost) && Objects.equals(this.workVariance, resource.workVariance) && Objects.equals(this.costVariance, resource.costVariance) && Objects.equals(this.sv, resource.sv) && Objects.equals(this.cv, resource.cv) && Objects.equals(this.acwp, resource.acwp) && Objects.equals(this.calendarUid, resource.calendarUid) && Objects.equals(this.notesText, resource.notesText) && Objects.equals(this.notes, resource.notes) && Objects.equals(this.notesRTF, resource.notesRTF) && Objects.equals(this.bcws, resource.bcws) && Objects.equals(this.bcwp, resource.bcwp) && Objects.equals(this.isGeneric, resource.isGeneric) && Objects.equals(this.isInactive, resource.isInactive) && Objects.equals(this.isEnterprise, resource.isEnterprise) && Objects.equals((Object)this.bookingType, (Object)resource.bookingType) && Objects.equals(this.actualWorkProtected, resource.actualWorkProtected) && Objects.equals(this.actualOvertimeWorkProtected, resource.actualOvertimeWorkProtected) && Objects.equals(this.activeDirectoryGuid, resource.activeDirectoryGuid) && Objects.equals(this.creationDate, resource.creationDate) && Objects.equals(this.costCenter, resource.costCenter) && Objects.equals(this.isCostResource, resource.isCostResource) && Objects.equals(this.teamAssignmentPool, resource.teamAssignmentPool) && Objects.equals(this.assignmentOwner, resource.assignmentOwner) && Objects.equals(this.assignmentOwnerGuid, resource.assignmentOwnerGuid) && Objects.equals(this.isBudget, resource.isBudget) && Objects.equals(this.budgetWork, resource.budgetWork) && Objects.equals(this.budgetCost, resource.budgetCost) && Objects.equals(this.overtimeRate, resource.overtimeRate) && Objects.equals(this.baselines, resource.baselines) && Objects.equals(this.extendedAttributes, resource.extendedAttributes) && Objects.equals(this.outlineCodes, resource.outlineCodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isRoot, this.name, this.uid, this.id, this.guid, this.type, this.isNull, this.initials, this.phonetics, this.ntAccount, this.windowsUserAccount, this.workgroup, this.materialLabel, this.code, this.group, this.emailAddress, this.hyperlink, this.hyperlinkAddress, this.hyperlinkSubAddress, this.maxUnits, this.peakUnits, this.overAllocated, this.availableFrom, this.availableTo, this.start, this.finish, this.canLevel, this.accrueAt, this.work, this.regularWork, this.overtimeWork, this.actualWork, this.remainingWork, this.actualOvertimeWork, this.remainingOvertimeWork, this.percentWorkComplete, this.standardRate, this.standardRateFormat, this.cost, this.overtimeRateFormat, this.overtimeCost, this.costPerUse, this.actualCost, this.actualOvertimeCost, this.remainingCost, this.remainingOvertimeCost, this.workVariance, this.costVariance, this.sv, this.cv, this.acwp, this.calendarUid, this.notesText, this.notes, this.notesRTF, this.bcws, this.bcwp, this.isGeneric, this.isInactive, this.isEnterprise, this.bookingType, this.actualWorkProtected, this.actualOvertimeWorkProtected, this.activeDirectoryGuid, this.creationDate, this.costCenter, this.isCostResource, this.teamAssignmentPool, this.assignmentOwner, this.assignmentOwnerGuid, this.isBudget, this.budgetWork, this.budgetCost, this.overtimeRate, this.baselines, this.extendedAttributes, this.outlineCodes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resource {\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    isNull: ").append(this.toIndentedString(this.isNull)).append("\n");
        sb.append("    initials: ").append(this.toIndentedString(this.initials)).append("\n");
        sb.append("    phonetics: ").append(this.toIndentedString(this.phonetics)).append("\n");
        sb.append("    ntAccount: ").append(this.toIndentedString(this.ntAccount)).append("\n");
        sb.append("    windowsUserAccount: ").append(this.toIndentedString(this.windowsUserAccount)).append("\n");
        sb.append("    workgroup: ").append(this.toIndentedString((Object)this.workgroup)).append("\n");
        sb.append("    materialLabel: ").append(this.toIndentedString(this.materialLabel)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    hyperlink: ").append(this.toIndentedString(this.hyperlink)).append("\n");
        sb.append("    hyperlinkAddress: ").append(this.toIndentedString(this.hyperlinkAddress)).append("\n");
        sb.append("    hyperlinkSubAddress: ").append(this.toIndentedString(this.hyperlinkSubAddress)).append("\n");
        sb.append("    maxUnits: ").append(this.toIndentedString(this.maxUnits)).append("\n");
        sb.append("    peakUnits: ").append(this.toIndentedString(this.peakUnits)).append("\n");
        sb.append("    overAllocated: ").append(this.toIndentedString(this.overAllocated)).append("\n");
        sb.append("    availableFrom: ").append(this.toIndentedString(this.availableFrom)).append("\n");
        sb.append("    availableTo: ").append(this.toIndentedString(this.availableTo)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    finish: ").append(this.toIndentedString(this.finish)).append("\n");
        sb.append("    canLevel: ").append(this.toIndentedString(this.canLevel)).append("\n");
        sb.append("    accrueAt: ").append(this.toIndentedString((Object)this.accrueAt)).append("\n");
        sb.append("    work: ").append(this.toIndentedString(this.work)).append("\n");
        sb.append("    regularWork: ").append(this.toIndentedString(this.regularWork)).append("\n");
        sb.append("    overtimeWork: ").append(this.toIndentedString(this.overtimeWork)).append("\n");
        sb.append("    actualWork: ").append(this.toIndentedString(this.actualWork)).append("\n");
        sb.append("    remainingWork: ").append(this.toIndentedString(this.remainingWork)).append("\n");
        sb.append("    actualOvertimeWork: ").append(this.toIndentedString(this.actualOvertimeWork)).append("\n");
        sb.append("    remainingOvertimeWork: ").append(this.toIndentedString(this.remainingOvertimeWork)).append("\n");
        sb.append("    percentWorkComplete: ").append(this.toIndentedString(this.percentWorkComplete)).append("\n");
        sb.append("    standardRate: ").append(this.toIndentedString(this.standardRate)).append("\n");
        sb.append("    standardRateFormat: ").append(this.toIndentedString((Object)this.standardRateFormat)).append("\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    overtimeRateFormat: ").append(this.toIndentedString((Object)this.overtimeRateFormat)).append("\n");
        sb.append("    overtimeCost: ").append(this.toIndentedString(this.overtimeCost)).append("\n");
        sb.append("    costPerUse: ").append(this.toIndentedString(this.costPerUse)).append("\n");
        sb.append("    actualCost: ").append(this.toIndentedString(this.actualCost)).append("\n");
        sb.append("    actualOvertimeCost: ").append(this.toIndentedString(this.actualOvertimeCost)).append("\n");
        sb.append("    remainingCost: ").append(this.toIndentedString(this.remainingCost)).append("\n");
        sb.append("    remainingOvertimeCost: ").append(this.toIndentedString(this.remainingOvertimeCost)).append("\n");
        sb.append("    workVariance: ").append(this.toIndentedString(this.workVariance)).append("\n");
        sb.append("    costVariance: ").append(this.toIndentedString(this.costVariance)).append("\n");
        sb.append("    sv: ").append(this.toIndentedString(this.sv)).append("\n");
        sb.append("    cv: ").append(this.toIndentedString(this.cv)).append("\n");
        sb.append("    acwp: ").append(this.toIndentedString(this.acwp)).append("\n");
        sb.append("    calendarUid: ").append(this.toIndentedString(this.calendarUid)).append("\n");
        sb.append("    notesText: ").append(this.toIndentedString(this.notesText)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    notesRTF: ").append(this.toIndentedString(this.notesRTF)).append("\n");
        sb.append("    bcws: ").append(this.toIndentedString(this.bcws)).append("\n");
        sb.append("    bcwp: ").append(this.toIndentedString(this.bcwp)).append("\n");
        sb.append("    isGeneric: ").append(this.toIndentedString(this.isGeneric)).append("\n");
        sb.append("    isInactive: ").append(this.toIndentedString(this.isInactive)).append("\n");
        sb.append("    isEnterprise: ").append(this.toIndentedString(this.isEnterprise)).append("\n");
        sb.append("    bookingType: ").append(this.toIndentedString((Object)this.bookingType)).append("\n");
        sb.append("    actualWorkProtected: ").append(this.toIndentedString(this.actualWorkProtected)).append("\n");
        sb.append("    actualOvertimeWorkProtected: ").append(this.toIndentedString(this.actualOvertimeWorkProtected)).append("\n");
        sb.append("    activeDirectoryGuid: ").append(this.toIndentedString(this.activeDirectoryGuid)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    costCenter: ").append(this.toIndentedString(this.costCenter)).append("\n");
        sb.append("    isCostResource: ").append(this.toIndentedString(this.isCostResource)).append("\n");
        sb.append("    teamAssignmentPool: ").append(this.toIndentedString(this.teamAssignmentPool)).append("\n");
        sb.append("    assignmentOwner: ").append(this.toIndentedString(this.assignmentOwner)).append("\n");
        sb.append("    assignmentOwnerGuid: ").append(this.toIndentedString(this.assignmentOwnerGuid)).append("\n");
        sb.append("    isBudget: ").append(this.toIndentedString(this.isBudget)).append("\n");
        sb.append("    budgetWork: ").append(this.toIndentedString(this.budgetWork)).append("\n");
        sb.append("    budgetCost: ").append(this.toIndentedString(this.budgetCost)).append("\n");
        sb.append("    overtimeRate: ").append(this.toIndentedString(this.overtimeRate)).append("\n");
        sb.append("    baselines: ").append(this.toIndentedString(this.baselines)).append("\n");
        sb.append("    extendedAttributes: ").append(this.toIndentedString(this.extendedAttributes)).append("\n");
        sb.append("    outlineCodes: ").append(this.toIndentedString(this.outlineCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

