/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.BackgroundPattern;
import com.aspose.tasks.cloud.model.Colors;
import com.aspose.tasks.cloud.model.Field;
import com.aspose.tasks.cloud.model.TextItemType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a text style in a view table.")
public class TableTextStyle {
    @SerializedName(value="RowUid")
    private Integer rowUid = null;
    @SerializedName(value="Field")
    private Field field = null;
    @SerializedName(value="ItemType")
    private TextItemType itemType = null;
    @SerializedName(value="Color")
    private Colors color = null;
    @SerializedName(value="BackgroundPattern")
    private BackgroundPattern backgroundPattern = null;
    @SerializedName(value="BackgroundColor")
    private Colors backgroundColor = null;

    public TableTextStyle rowUid(Integer rowUid) {
        this.rowUid = rowUid;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets a row unique id. Return -1 if the style is to be applied to all rows of a view.")
    public Integer getRowUid() {
        return this.rowUid;
    }

    public void setRowUid(Integer rowUid) {
        this.rowUid = rowUid;
    }

    public TableTextStyle field(Field field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a field the style is to be applied to.")
    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public TableTextStyle itemType(TextItemType itemType) {
        this.itemType = itemType;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns a value of the TextItemType enum.")
    public TextItemType getItemType() {
        return this.itemType;
    }

    public void setItemType(TextItemType itemType) {
        this.itemType = itemType;
    }

    public TableTextStyle color(Colors color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets color of the text.")
    public Colors getColor() {
        return this.color;
    }

    public void setColor(Colors color) {
        this.color = color;
    }

    public TableTextStyle backgroundPattern(BackgroundPattern backgroundPattern) {
        this.backgroundPattern = backgroundPattern;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets background pattern of the text style.")
    public BackgroundPattern getBackgroundPattern() {
        return this.backgroundPattern;
    }

    public void setBackgroundPattern(BackgroundPattern backgroundPattern) {
        this.backgroundPattern = backgroundPattern;
    }

    public TableTextStyle backgroundColor(Colors backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets background color of the text style.")
    public Colors getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Colors backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableTextStyle tableTextStyle = (TableTextStyle)o;
        return Objects.equals(this.rowUid, tableTextStyle.rowUid) && Objects.equals((Object)this.field, (Object)tableTextStyle.field) && Objects.equals((Object)this.itemType, (Object)tableTextStyle.itemType) && Objects.equals((Object)this.color, (Object)tableTextStyle.color) && Objects.equals((Object)this.backgroundPattern, (Object)tableTextStyle.backgroundPattern) && Objects.equals((Object)this.backgroundColor, (Object)tableTextStyle.backgroundColor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rowUid, this.field, this.itemType, this.color, this.backgroundPattern, this.backgroundColor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableTextStyle {\n");
        sb.append("    rowUid: ").append(this.toIndentedString(this.rowUid)).append("\n");
        sb.append("    field: ").append(this.toIndentedString((Object)this.field)).append("\n");
        sb.append("    itemType: ").append(this.toIndentedString((Object)this.itemType)).append("\n");
        sb.append("    color: ").append(this.toIndentedString((Object)this.color)).append("\n");
        sb.append("    backgroundPattern: ").append(this.toIndentedString((Object)this.backgroundPattern)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString((Object)this.backgroundColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

