/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.ItemType;
import com.aspose.tasks.cloud.model.ViewScreen;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a view in Project")
public class View {
    @SerializedName(value="ShowInMenu")
    private Boolean showInMenu = null;
    @SerializedName(value="Type")
    private ItemType type = null;
    @SerializedName(value="Screen")
    private ViewScreen screen = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="Uid")
    private Integer uid = null;

    public View showInMenu(Boolean showInMenu) {
        this.showInMenu = showInMenu;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a value indicating whether Microsoft Project shows the single view  name in the View or the Other Views drop-down lists in the Ribbon")
    public Boolean isShowInMenu() {
        return this.showInMenu;
    }

    public void setShowInMenu(Boolean showInMenu) {
        this.showInMenu = showInMenu;
    }

    public View type(ItemType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the type of item in the single view, such as tasks or resources. Read-only.")
    public ItemType getType() {
        return this.type;
    }

    public void setType(ItemType type) {
        this.type = type;
    }

    public View screen(ViewScreen screen) {
        this.screen = screen;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the screen type for the single view. Read-only.")
    public ViewScreen getScreen() {
        return this.screen;
    }

    public void setScreen(ViewScreen screen) {
        this.screen = screen;
    }

    public View name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the name of a view object.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public View uid(Integer uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the unique identifier of a view.")
    public Integer getUid() {
        return this.uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        return Objects.equals(this.showInMenu, view.showInMenu) && Objects.equals((Object)this.type, (Object)view.type) && Objects.equals((Object)this.screen, (Object)view.screen) && Objects.equals(this.name, view.name) && Objects.equals(this.uid, view.uid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.showInMenu, this.type, this.screen, this.name, this.uid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class View {\n");
        sb.append("    showInMenu: ").append(this.toIndentedString(this.showInMenu)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    screen: ").append(this.toIndentedString((Object)this.screen)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

