/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.WBSCodeMask;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WBSDefinition {
    @SerializedName(value="CodePrefix")
    private String codePrefix = null;
    @SerializedName(value="GenerateWBSCode")
    private Boolean generateWBSCode = null;
    @SerializedName(value="VerifyUniqueness")
    private Boolean verifyUniqueness = null;
    @SerializedName(value="CodeMaskCollection")
    private List<WBSCodeMask> codeMaskCollection = null;

    public WBSDefinition codePrefix(String codePrefix) {
        this.codePrefix = codePrefix;
        return this;
    }

    @ApiModelProperty(value="Project Code Prefix.")
    public String getCodePrefix() {
        return this.codePrefix;
    }

    public void setCodePrefix(String codePrefix) {
        this.codePrefix = codePrefix;
    }

    public WBSDefinition generateWBSCode(Boolean generateWBSCode) {
        this.generateWBSCode = generateWBSCode;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether to generate WBS code for new task.")
    public Boolean isGenerateWBSCode() {
        return this.generateWBSCode;
    }

    public void setGenerateWBSCode(Boolean generateWBSCode) {
        this.generateWBSCode = generateWBSCode;
    }

    public WBSDefinition verifyUniqueness(Boolean verifyUniqueness) {
        this.verifyUniqueness = verifyUniqueness;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether to verify uniqueness of new WBS codes.")
    public Boolean isVerifyUniqueness() {
        return this.verifyUniqueness;
    }

    public void setVerifyUniqueness(Boolean verifyUniqueness) {
        this.verifyUniqueness = verifyUniqueness;
    }

    public WBSDefinition codeMaskCollection(List<WBSCodeMask> codeMaskCollection) {
        this.codeMaskCollection = codeMaskCollection;
        return this;
    }

    public WBSDefinition addCodeMaskCollectionItem(WBSCodeMask codeMaskCollectionItem) {
        if (this.codeMaskCollection == null) {
            this.codeMaskCollection = new ArrayList<WBSCodeMask>();
        }
        this.codeMaskCollection.add(codeMaskCollectionItem);
        return this;
    }

    @ApiModelProperty(value="Collection of WBSCodeMask objects.")
    public List<WBSCodeMask> getCodeMaskCollection() {
        return this.codeMaskCollection;
    }

    public void setCodeMaskCollection(List<WBSCodeMask> codeMaskCollection) {
        this.codeMaskCollection = codeMaskCollection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WBSDefinition wbSDefinition = (WBSDefinition)o;
        return Objects.equals(this.codePrefix, wbSDefinition.codePrefix) && Objects.equals(this.generateWBSCode, wbSDefinition.generateWBSCode) && Objects.equals(this.verifyUniqueness, wbSDefinition.verifyUniqueness) && Objects.equals(this.codeMaskCollection, wbSDefinition.codeMaskCollection);
    }

    public int hashCode() {
        return Objects.hash(this.codePrefix, this.generateWBSCode, this.verifyUniqueness, this.codeMaskCollection);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WBSDefinition {\n");
        sb.append("    codePrefix: ").append(this.toIndentedString(this.codePrefix)).append("\n");
        sb.append("    generateWBSCode: ").append(this.toIndentedString(this.generateWBSCode)).append("\n");
        sb.append("    verifyUniqueness: ").append(this.toIndentedString(this.verifyUniqueness)).append("\n");
        sb.append("    codeMaskCollection: ").append(this.toIndentedString(this.codeMaskCollection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

