/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.DayType;
import com.aspose.tasks.cloud.model.WorkingTime;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class WeekDay {
    @SerializedName(value="DayType")
    private DayType dayType = null;
    @SerializedName(value="DayWorking")
    private Boolean dayWorking = null;
    @SerializedName(value="FromDate")
    private OffsetDateTime fromDate = null;
    @SerializedName(value="ToDate")
    private OffsetDateTime toDate = null;
    @SerializedName(value="WorkingTimes")
    private List<WorkingTime> workingTimes = null;

    public WeekDay dayType(DayType dayType) {
        this.dayType = dayType;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the type of a day.")
    public DayType getDayType() {
        return this.dayType;
    }

    public void setDayType(DayType dayType) {
        this.dayType = dayType;
    }

    public WeekDay dayWorking(Boolean dayWorking) {
        this.dayWorking = dayWorking;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the specified date or day type is working.")
    public Boolean isDayWorking() {
        return this.dayWorking;
    }

    public void setDayWorking(Boolean dayWorking) {
        this.dayWorking = dayWorking;
    }

    public WeekDay fromDate(OffsetDateTime fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the beginning of an exception time.")
    public OffsetDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(OffsetDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public WeekDay toDate(OffsetDateTime toDate) {
        this.toDate = toDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the end of an exception time.")
    public OffsetDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(OffsetDateTime toDate) {
        this.toDate = toDate;
    }

    public WeekDay workingTimes(List<WorkingTime> workingTimes) {
        this.workingTimes = workingTimes;
        return this;
    }

    public WeekDay addWorkingTimesItem(WorkingTime workingTimesItem) {
        if (this.workingTimes == null) {
            this.workingTimes = new ArrayList<WorkingTime>();
        }
        this.workingTimes.add(workingTimesItem);
        return this;
    }

    @ApiModelProperty(value="The collection of working times that define the time worked on the weekday.")
    public List<WorkingTime> getWorkingTimes() {
        return this.workingTimes;
    }

    public void setWorkingTimes(List<WorkingTime> workingTimes) {
        this.workingTimes = workingTimes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeekDay weekDay = (WeekDay)o;
        return Objects.equals((Object)this.dayType, (Object)weekDay.dayType) && Objects.equals(this.dayWorking, weekDay.dayWorking) && Objects.equals(this.fromDate, weekDay.fromDate) && Objects.equals(this.toDate, weekDay.toDate) && Objects.equals(this.workingTimes, weekDay.workingTimes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dayType, this.dayWorking, this.fromDate, this.toDate, this.workingTimes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WeekDay {\n");
        sb.append("    dayType: ").append(this.toIndentedString((Object)this.dayType)).append("\n");
        sb.append("    dayWorking: ").append(this.toIndentedString(this.dayWorking)).append("\n");
        sb.append("    fromDate: ").append(this.toIndentedString(this.fromDate)).append("\n");
        sb.append("    toDate: ").append(this.toIndentedString(this.toDate)).append("\n");
        sb.append("    workingTimes: ").append(this.toIndentedString(this.workingTimes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

