/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.WeekDay;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class WorkWeek {
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="FromDate")
    private OffsetDateTime fromDate = null;
    @SerializedName(value="ToDate")
    private OffsetDateTime toDate = null;
    @SerializedName(value="WeekDays")
    private List<WeekDay> weekDays = null;

    public WorkWeek name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Determines the name of a work week.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkWeek fromDate(OffsetDateTime fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the beginning of a work week.")
    public OffsetDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(OffsetDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public WorkWeek toDate(OffsetDateTime toDate) {
        this.toDate = toDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets the end of a work week.")
    public OffsetDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(OffsetDateTime toDate) {
        this.toDate = toDate;
    }

    public WorkWeek weekDays(List<WeekDay> weekDays) {
        this.weekDays = weekDays;
        return this;
    }

    public WorkWeek addWeekDaysItem(WeekDay weekDaysItem) {
        if (this.weekDays == null) {
            this.weekDays = new ArrayList<WeekDay>();
        }
        this.weekDays.add(weekDaysItem);
        return this;
    }

    @ApiModelProperty(value="The collection of week days that define the working time of current working week.")
    public List<WeekDay> getWeekDays() {
        return this.weekDays;
    }

    public void setWeekDays(List<WeekDay> weekDays) {
        this.weekDays = weekDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkWeek workWeek = (WorkWeek)o;
        return Objects.equals(this.name, workWeek.name) && Objects.equals(this.fromDate, workWeek.fromDate) && Objects.equals(this.toDate, workWeek.toDate) && Objects.equals(this.weekDays, workWeek.weekDays);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fromDate, this.toDate, this.weekDays);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkWeek {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fromDate: ").append(this.toIndentedString(this.fromDate)).append("\n");
        sb.append("    toDate: ").append(this.toIndentedString(this.toDate)).append("\n");
        sb.append("    weekDays: ").append(this.toIndentedString(this.weekDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

