/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.api;

import com.aspose.tasks.cloud.ApiCallback;
import com.aspose.tasks.cloud.ApiClient;
import com.aspose.tasks.cloud.ApiException;
import com.aspose.tasks.cloud.ApiResponse;
import com.aspose.tasks.cloud.Configuration;
import com.aspose.tasks.cloud.Pair;
import com.aspose.tasks.cloud.ProgressRequestBody;
import com.aspose.tasks.cloud.ProgressResponseBody;
import com.aspose.tasks.cloud.model.Calendar;
import com.aspose.tasks.cloud.model.CalendarException;
import com.aspose.tasks.cloud.model.DiscUsage;
import com.aspose.tasks.cloud.model.DocumentProperty;
import com.aspose.tasks.cloud.model.ExtendedAttributeDefinition;
import com.aspose.tasks.cloud.model.FileVersions;
import com.aspose.tasks.cloud.model.FilesList;
import com.aspose.tasks.cloud.model.FilesUploadResult;
import com.aspose.tasks.cloud.model.LevelingOptions;
import com.aspose.tasks.cloud.model.ObjectExist;
import com.aspose.tasks.cloud.model.ProjectServerSaveOptionsDTO;
import com.aspose.tasks.cloud.model.RecurringInfo;
import com.aspose.tasks.cloud.model.Resource;
import com.aspose.tasks.cloud.model.ResourceAssignment;
import com.aspose.tasks.cloud.model.StorageExist;
import com.aspose.tasks.cloud.model.TableTextStyle;
import com.aspose.tasks.cloud.model.Task;
import com.aspose.tasks.cloud.model.TaskCreationRequest;
import com.aspose.tasks.cloud.model.TaskLink;
import com.aspose.tasks.cloud.model.requests.ClearLevelingRequest;
import com.aspose.tasks.cloud.model.requests.CopyFileRequest;
import com.aspose.tasks.cloud.model.requests.CopyFolderRequest;
import com.aspose.tasks.cloud.model.requests.CreateFolderRequest;
import com.aspose.tasks.cloud.model.requests.CreateNewProjectRequest;
import com.aspose.tasks.cloud.model.requests.CreateTableTextStyleRequest;
import com.aspose.tasks.cloud.model.requests.DeleteAssignmentRequest;
import com.aspose.tasks.cloud.model.requests.DeleteCalendarExceptionRequest;
import com.aspose.tasks.cloud.model.requests.DeleteCalendarRequest;
import com.aspose.tasks.cloud.model.requests.DeleteExtendedAttributeByIndexRequest;
import com.aspose.tasks.cloud.model.requests.DeleteFileRequest;
import com.aspose.tasks.cloud.model.requests.DeleteFolderRequest;
import com.aspose.tasks.cloud.model.requests.DeleteOutlineCodeByIndexRequest;
import com.aspose.tasks.cloud.model.requests.DeleteResourceRequest;
import com.aspose.tasks.cloud.model.requests.DeleteTableTextStyleRequest;
import com.aspose.tasks.cloud.model.requests.DeleteTaskLinkRequest;
import com.aspose.tasks.cloud.model.requests.DeleteTaskRequest;
import com.aspose.tasks.cloud.model.requests.DownloadFileRequest;
import com.aspose.tasks.cloud.model.requests.GetAllTableTextStylesRequest;
import com.aspose.tasks.cloud.model.requests.GetAssignmentRequest;
import com.aspose.tasks.cloud.model.requests.GetAssignmentTimephasedDataRequest;
import com.aspose.tasks.cloud.model.requests.GetAssignmentsRequest;
import com.aspose.tasks.cloud.model.requests.GetCalendarExceptionsRequest;
import com.aspose.tasks.cloud.model.requests.GetCalendarRequest;
import com.aspose.tasks.cloud.model.requests.GetCalendarWorkWeeksRequest;
import com.aspose.tasks.cloud.model.requests.GetCalendarsRequest;
import com.aspose.tasks.cloud.model.requests.GetCriticalPathRequest;
import com.aspose.tasks.cloud.model.requests.GetDiscUsageRequest;
import com.aspose.tasks.cloud.model.requests.GetDocumentPropertiesRequest;
import com.aspose.tasks.cloud.model.requests.GetDocumentPropertyRequest;
import com.aspose.tasks.cloud.model.requests.GetExtendedAttributeByIndexRequest;
import com.aspose.tasks.cloud.model.requests.GetExtendedAttributesRequest;
import com.aspose.tasks.cloud.model.requests.GetFileVersionsRequest;
import com.aspose.tasks.cloud.model.requests.GetFilesListRequest;
import com.aspose.tasks.cloud.model.requests.GetOutlineCodeByIndexRequest;
import com.aspose.tasks.cloud.model.requests.GetOutlineCodesRequest;
import com.aspose.tasks.cloud.model.requests.GetPageCountRequest;
import com.aspose.tasks.cloud.model.requests.GetPrimaveraTaskPropertiesRequest;
import com.aspose.tasks.cloud.model.requests.GetProjectIdsRequest;
import com.aspose.tasks.cloud.model.requests.GetProjectListRequest;
import com.aspose.tasks.cloud.model.requests.GetReportPdfRequest;
import com.aspose.tasks.cloud.model.requests.GetResourceAssignmentsRequest;
import com.aspose.tasks.cloud.model.requests.GetResourceRequest;
import com.aspose.tasks.cloud.model.requests.GetResourceTimephasedDataRequest;
import com.aspose.tasks.cloud.model.requests.GetResourcesRequest;
import com.aspose.tasks.cloud.model.requests.GetRiskAnalysisReportRequest;
import com.aspose.tasks.cloud.model.requests.GetTableTextStyleRequest;
import com.aspose.tasks.cloud.model.requests.GetTaskAssignmentsRequest;
import com.aspose.tasks.cloud.model.requests.GetTaskDocumentRequest;
import com.aspose.tasks.cloud.model.requests.GetTaskDocumentWithFormatRequest;
import com.aspose.tasks.cloud.model.requests.GetTaskLinksRequest;
import com.aspose.tasks.cloud.model.requests.GetTaskRecurringInfoRequest;
import com.aspose.tasks.cloud.model.requests.GetTaskRequest;
import com.aspose.tasks.cloud.model.requests.GetTaskTimephasedDataRequest;
import com.aspose.tasks.cloud.model.requests.GetTasksRequest;
import com.aspose.tasks.cloud.model.requests.GetVbaProjectRequest;
import com.aspose.tasks.cloud.model.requests.GetViewsRequest;
import com.aspose.tasks.cloud.model.requests.GetWbsDefinitionRequest;
import com.aspose.tasks.cloud.model.requests.LevelTasksRequest;
import com.aspose.tasks.cloud.model.requests.MoveFileRequest;
import com.aspose.tasks.cloud.model.requests.MoveFolderRequest;
import com.aspose.tasks.cloud.model.requests.ObjectExistsRequest;
import com.aspose.tasks.cloud.model.requests.PostAssignmentRequest;
import com.aspose.tasks.cloud.model.requests.PostCalendarExceptionRequest;
import com.aspose.tasks.cloud.model.requests.PostCalendarRequest;
import com.aspose.tasks.cloud.model.requests.PostDocumentPropertyRequest;
import com.aspose.tasks.cloud.model.requests.PostResourceRequest;
import com.aspose.tasks.cloud.model.requests.PostTaskLinkRequest;
import com.aspose.tasks.cloud.model.requests.PostTaskRecurringInfoRequest;
import com.aspose.tasks.cloud.model.requests.PostTaskRequest;
import com.aspose.tasks.cloud.model.requests.PostTasksRequest;
import com.aspose.tasks.cloud.model.requests.PutAssignmentRequest;
import com.aspose.tasks.cloud.model.requests.PutCalendarExceptionRequest;
import com.aspose.tasks.cloud.model.requests.PutCalendarRequest;
import com.aspose.tasks.cloud.model.requests.PutDocumentPropertyRequest;
import com.aspose.tasks.cloud.model.requests.PutExtendedAttributeRequest;
import com.aspose.tasks.cloud.model.requests.PutImportProjectFromDbRequest;
import com.aspose.tasks.cloud.model.requests.PutImportProjectFromFileRequest;
import com.aspose.tasks.cloud.model.requests.PutImportProjectFromProjectOnlineRequest;
import com.aspose.tasks.cloud.model.requests.PutMoveTaskRequest;
import com.aspose.tasks.cloud.model.requests.PutMoveTaskToSiblingRequest;
import com.aspose.tasks.cloud.model.requests.PutRecalculateProjectRequest;
import com.aspose.tasks.cloud.model.requests.PutRecalculateProjectResourceFieldsRequest;
import com.aspose.tasks.cloud.model.requests.PutRecalculateProjectUncompleteWorkToStartAfterRequest;
import com.aspose.tasks.cloud.model.requests.PutRecalculateProjectWorkAsCompleteRequest;
import com.aspose.tasks.cloud.model.requests.PutRenumberWbsCodeRequest;
import com.aspose.tasks.cloud.model.requests.PutResourceRequest;
import com.aspose.tasks.cloud.model.requests.PutTaskLinkRequest;
import com.aspose.tasks.cloud.model.requests.PutTaskRecurringInfoRequest;
import com.aspose.tasks.cloud.model.requests.PutTaskRequest;
import com.aspose.tasks.cloud.model.requests.StorageExistsRequest;
import com.aspose.tasks.cloud.model.requests.UpdateProjectRequest;
import com.aspose.tasks.cloud.model.requests.UpdateTableTextStyleRequest;
import com.aspose.tasks.cloud.model.requests.UploadFileRequest;
import com.aspose.tasks.cloud.model.responses.AsposeResponse;
import com.aspose.tasks.cloud.model.responses.AssignmentItemResponse;
import com.aspose.tasks.cloud.model.responses.AssignmentItemsResponse;
import com.aspose.tasks.cloud.model.responses.AssignmentResponse;
import com.aspose.tasks.cloud.model.responses.AssignmentsResponse;
import com.aspose.tasks.cloud.model.responses.CalendarExceptionsResponse;
import com.aspose.tasks.cloud.model.responses.CalendarItemResponse;
import com.aspose.tasks.cloud.model.responses.CalendarItemsResponse;
import com.aspose.tasks.cloud.model.responses.CalendarResponse;
import com.aspose.tasks.cloud.model.responses.CalendarWorkWeeksResponse;
import com.aspose.tasks.cloud.model.responses.DocumentPropertiesResponse;
import com.aspose.tasks.cloud.model.responses.DocumentPropertyResponse;
import com.aspose.tasks.cloud.model.responses.ExtendedAttributeItemResponse;
import com.aspose.tasks.cloud.model.responses.ExtendedAttributeItemsResponse;
import com.aspose.tasks.cloud.model.responses.ExtendedAttributeResponse;
import com.aspose.tasks.cloud.model.responses.LevelingResponse;
import com.aspose.tasks.cloud.model.responses.OutlineCodeItemsResponse;
import com.aspose.tasks.cloud.model.responses.OutlineCodeResponse;
import com.aspose.tasks.cloud.model.responses.PageCountResponse;
import com.aspose.tasks.cloud.model.responses.PrimaveraTaskPropertiesResponse;
import com.aspose.tasks.cloud.model.responses.ProjectIdsResponse;
import com.aspose.tasks.cloud.model.responses.ProjectListResponse;
import com.aspose.tasks.cloud.model.responses.ProjectRecalculateResponse;
import com.aspose.tasks.cloud.model.responses.RecurringInfoResponse;
import com.aspose.tasks.cloud.model.responses.ResourceItemResponse;
import com.aspose.tasks.cloud.model.responses.ResourceItemsResponse;
import com.aspose.tasks.cloud.model.responses.ResourceResponse;
import com.aspose.tasks.cloud.model.responses.TableTextStyleResponse;
import com.aspose.tasks.cloud.model.responses.TableTextStylesResponse;
import com.aspose.tasks.cloud.model.responses.TaskItemResponse;
import com.aspose.tasks.cloud.model.responses.TaskItemsResponse;
import com.aspose.tasks.cloud.model.responses.TaskLinkResponse;
import com.aspose.tasks.cloud.model.responses.TaskLinksResponse;
import com.aspose.tasks.cloud.model.responses.TaskResponse;
import com.aspose.tasks.cloud.model.responses.TimephasedDataResponse;
import com.aspose.tasks.cloud.model.responses.VbaProjectResponse;
import com.aspose.tasks.cloud.model.responses.ViewsResponse;
import com.aspose.tasks.cloud.model.responses.WBSDefinitionResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class TasksApi {
    private Integer NotAuth = 401;
    private Integer BadRequest = 400;
    private ApiClient apiClient;

    public TasksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TasksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call copyFileCall(CopyFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/file/copy/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getsrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destPath", request.getdestPath());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "srcStorageName", request.getsrcStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destStorageName", request.getdestStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getversionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call copyFileValidateBeforeCall(CopyFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsrcPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'srcPath' when calling copyFile");
        }
        if (request.getdestPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'destPath' when calling copyFile");
        }
        Call call = this.copyFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void copyFile(CopyFileRequest request) throws ApiException {
        try {
            this.copyFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.copyFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> copyFileWithHttpInfo(CopyFileRequest request) throws ApiException {
        Call call = this.copyFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call copyFileAsync(CopyFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call deleteFileCall(DeleteFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getversionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFileValidateBeforeCall(DeleteFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'path' when calling deleteFile");
        }
        Call call = this.deleteFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFile(DeleteFileRequest request) throws ApiException {
        try {
            this.deleteFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.deleteFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> deleteFileWithHttpInfo(DeleteFileRequest request) throws ApiException {
        Call call = this.deleteFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFileAsync(DeleteFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call downloadFileCall(DownloadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getversionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"multipart/form-data"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadFileValidateBeforeCall(DownloadFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'path' when calling downloadFile");
        }
        Call call = this.downloadFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File downloadFile(DownloadFileRequest request) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadFileWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<File> resp = this.downloadFileWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<File> downloadFileWithHttpInfo(DownloadFileRequest request) throws ApiException {
        Call call = this.downloadFileValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadFileAsync(DownloadFileRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadFileValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call moveFileCall(MoveFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/file/move/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getsrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destPath", request.getdestPath());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "srcStorageName", request.getsrcStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destStorageName", request.getdestStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getversionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call moveFileValidateBeforeCall(MoveFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsrcPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'srcPath' when calling moveFile");
        }
        if (request.getdestPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'destPath' when calling moveFile");
        }
        Call call = this.moveFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void moveFile(MoveFileRequest request) throws ApiException {
        try {
            this.moveFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.moveFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> moveFileWithHttpInfo(MoveFileRequest request) throws ApiException {
        Call call = this.moveFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call moveFileAsync(MoveFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.moveFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call uploadFileCall(UploadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        if (request.getfile() != null) {
            localVarFormParams.put("file", request.getfile());
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadFileValidateBeforeCall(UploadFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'path' when calling uploadFile");
        }
        if (request.getfile() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'file' when calling uploadFile");
        }
        Call call = this.uploadFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public FilesUploadResult uploadFile(UploadFileRequest request) throws ApiException {
        try {
            ApiResponse<FilesUploadResult> resp = this.uploadFileWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<FilesUploadResult> resp = this.uploadFileWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<FilesUploadResult> uploadFileWithHttpInfo(UploadFileRequest request) throws ApiException {
        Call call = this.uploadFileValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<FilesUploadResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uploadFileAsync(UploadFileRequest request, final ApiCallback<FilesUploadResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadFileValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FilesUploadResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call copyFolderCall(CopyFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/folder/copy/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getsrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destPath", request.getdestPath());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "srcStorageName", request.getsrcStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destStorageName", request.getdestStorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call copyFolderValidateBeforeCall(CopyFolderRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsrcPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'srcPath' when calling copyFolder");
        }
        if (request.getdestPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'destPath' when calling copyFolder");
        }
        Call call = this.copyFolderCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void copyFolder(CopyFolderRequest request) throws ApiException {
        try {
            this.copyFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.copyFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> copyFolderWithHttpInfo(CopyFolderRequest request) throws ApiException {
        Call call = this.copyFolderValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call copyFolderAsync(CopyFolderRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call createFolderCall(CreateFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createFolderValidateBeforeCall(CreateFolderRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'path' when calling createFolder");
        }
        Call call = this.createFolderCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void createFolder(CreateFolderRequest request) throws ApiException {
        try {
            this.createFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.createFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> createFolderWithHttpInfo(CreateFolderRequest request) throws ApiException {
        Call call = this.createFolderValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call createFolderAsync(CreateFolderRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call deleteFolderCall(DeleteFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "recursive", request.getrecursive());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFolderValidateBeforeCall(DeleteFolderRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'path' when calling deleteFolder");
        }
        Call call = this.deleteFolderCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFolder(DeleteFolderRequest request) throws ApiException {
        try {
            this.deleteFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.deleteFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> deleteFolderWithHttpInfo(DeleteFolderRequest request) throws ApiException {
        Call call = this.deleteFolderValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFolderAsync(DeleteFolderRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getFilesListCall(GetFilesListRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFilesListValidateBeforeCall(GetFilesListRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'path' when calling getFilesList");
        }
        Call call = this.getFilesListCall(request, progressListener, progressRequestListener);
        return call;
    }

    public FilesList getFilesList(GetFilesListRequest request) throws ApiException {
        try {
            ApiResponse<FilesList> resp = this.getFilesListWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<FilesList> resp = this.getFilesListWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<FilesList> getFilesListWithHttpInfo(GetFilesListRequest request) throws ApiException {
        Call call = this.getFilesListValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<FilesList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFilesListAsync(GetFilesListRequest request, final ApiCallback<FilesList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFilesListValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FilesList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call moveFolderCall(MoveFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/folder/move/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getsrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destPath", request.getdestPath());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "srcStorageName", request.getsrcStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destStorageName", request.getdestStorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call moveFolderValidateBeforeCall(MoveFolderRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsrcPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'srcPath' when calling moveFolder");
        }
        if (request.getdestPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'destPath' when calling moveFolder");
        }
        Call call = this.moveFolderCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void moveFolder(MoveFolderRequest request) throws ApiException {
        try {
            this.moveFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.moveFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> moveFolderWithHttpInfo(MoveFolderRequest request) throws ApiException {
        Call call = this.moveFolderValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call moveFolderAsync(MoveFolderRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.moveFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getDiscUsageCall(GetDiscUsageRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/disc";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDiscUsageValidateBeforeCall(GetDiscUsageRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDiscUsageCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DiscUsage getDiscUsage(GetDiscUsageRequest request) throws ApiException {
        try {
            ApiResponse<DiscUsage> resp = this.getDiscUsageWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<DiscUsage> resp = this.getDiscUsageWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<DiscUsage> getDiscUsageWithHttpInfo(GetDiscUsageRequest request) throws ApiException {
        Call call = this.getDiscUsageValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DiscUsage>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDiscUsageAsync(GetDiscUsageRequest request, final ApiCallback<DiscUsage> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDiscUsageValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DiscUsage>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getFileVersionsCall(GetFileVersionsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/version/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFileVersionsValidateBeforeCall(GetFileVersionsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'path' when calling getFileVersions");
        }
        Call call = this.getFileVersionsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public FileVersions getFileVersions(GetFileVersionsRequest request) throws ApiException {
        try {
            ApiResponse<FileVersions> resp = this.getFileVersionsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<FileVersions> resp = this.getFileVersionsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<FileVersions> getFileVersionsWithHttpInfo(GetFileVersionsRequest request) throws ApiException {
        Call call = this.getFileVersionsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<FileVersions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFileVersionsAsync(GetFileVersionsRequest request, final ApiCallback<FileVersions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFileVersionsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileVersions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call objectExistsCall(ObjectExistsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/exist/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getstorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getversionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call objectExistsValidateBeforeCall(ObjectExistsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'path' when calling objectExists");
        }
        Call call = this.objectExistsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ObjectExist objectExists(ObjectExistsRequest request) throws ApiException {
        try {
            ApiResponse<ObjectExist> resp = this.objectExistsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ObjectExist> resp = this.objectExistsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ObjectExist> objectExistsWithHttpInfo(ObjectExistsRequest request) throws ApiException {
        Call call = this.objectExistsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ObjectExist>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call objectExistsAsync(ObjectExistsRequest request, final ApiCallback<ObjectExist> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.objectExistsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ObjectExist>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call storageExistsCall(StorageExistsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/storage/{storageName}/exist".replaceAll("\\{storageName\\}", this.apiClient.escapeString(request.getstorageName().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call storageExistsValidateBeforeCall(StorageExistsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getstorageName() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'storageName' when calling storageExists");
        }
        Call call = this.storageExistsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public StorageExist storageExists(StorageExistsRequest request) throws ApiException {
        try {
            ApiResponse<StorageExist> resp = this.storageExistsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<StorageExist> resp = this.storageExistsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<StorageExist> storageExistsWithHttpInfo(StorageExistsRequest request) throws ApiException {
        Call call = this.storageExistsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<StorageExist>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call storageExistsAsync(StorageExistsRequest request, final ApiCallback<StorageExist> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.storageExistsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StorageExist>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteAssignmentCall(DeleteAssignmentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/assignments/{assignmentUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{assignmentUid\\}", this.apiClient.escapeString(request.getassignmentUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAssignmentValidateBeforeCall(DeleteAssignmentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteAssignment");
        }
        if (request.getassignmentUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'assignmentUid' when calling deleteAssignment");
        }
        Call call = this.deleteAssignmentCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteAssignment(DeleteAssignmentRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteAssignmentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteAssignmentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteAssignmentWithHttpInfo(DeleteAssignmentRequest request) throws ApiException {
        Call call = this.deleteAssignmentValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAssignmentAsync(DeleteAssignmentRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAssignmentValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAssignmentCall(GetAssignmentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/assignments/{assignmentUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{assignmentUid\\}", this.apiClient.escapeString(request.getassignmentUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAssignmentValidateBeforeCall(GetAssignmentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getAssignment");
        }
        if (request.getassignmentUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'assignmentUid' when calling getAssignment");
        }
        Call call = this.getAssignmentCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AssignmentResponse getAssignment(GetAssignmentRequest request) throws ApiException {
        try {
            ApiResponse<AssignmentResponse> resp = this.getAssignmentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AssignmentResponse> resp = this.getAssignmentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AssignmentResponse> getAssignmentWithHttpInfo(GetAssignmentRequest request) throws ApiException {
        Call call = this.getAssignmentValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AssignmentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAssignmentAsync(GetAssignmentRequest request, final ApiCallback<AssignmentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAssignmentValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AssignmentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAssignmentTimephasedDataCall(GetAssignmentTimephasedDataRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/assignments/{assignmentUid}/timeScaleData".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{assignmentUid\\}", this.apiClient.escapeString(request.getassignmentUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "type", request.gettype());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "startDate", request.getstartDate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "endDate", request.getendDate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAssignmentTimephasedDataValidateBeforeCall(GetAssignmentTimephasedDataRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getAssignmentTimephasedData");
        }
        if (request.getassignmentUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'assignmentUid' when calling getAssignmentTimephasedData");
        }
        Call call = this.getAssignmentTimephasedDataCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TimephasedDataResponse getAssignmentTimephasedData(GetAssignmentTimephasedDataRequest request) throws ApiException {
        try {
            ApiResponse<TimephasedDataResponse> resp = this.getAssignmentTimephasedDataWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TimephasedDataResponse> resp = this.getAssignmentTimephasedDataWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TimephasedDataResponse> getAssignmentTimephasedDataWithHttpInfo(GetAssignmentTimephasedDataRequest request) throws ApiException {
        Call call = this.getAssignmentTimephasedDataValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TimephasedDataResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAssignmentTimephasedDataAsync(GetAssignmentTimephasedDataRequest request, final ApiCallback<TimephasedDataResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAssignmentTimephasedDataValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TimephasedDataResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAssignmentsCall(GetAssignmentsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/assignments".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAssignmentsValidateBeforeCall(GetAssignmentsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getAssignments");
        }
        Call call = this.getAssignmentsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AssignmentItemsResponse getAssignments(GetAssignmentsRequest request) throws ApiException {
        try {
            ApiResponse<AssignmentItemsResponse> resp = this.getAssignmentsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AssignmentItemsResponse> resp = this.getAssignmentsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AssignmentItemsResponse> getAssignmentsWithHttpInfo(GetAssignmentsRequest request) throws ApiException {
        Call call = this.getAssignmentsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AssignmentItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAssignmentsAsync(GetAssignmentsRequest request, final ApiCallback<AssignmentItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAssignmentsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AssignmentItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postAssignmentCall(PostAssignmentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/assignments".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "taskUid", request.gettaskUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "resourceUid", request.getresourceUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "units", request.getunits());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "cost", request.getcost());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postAssignmentValidateBeforeCall(PostAssignmentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postAssignment");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling postAssignment");
        }
        if (request.getresourceUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'resourceUid' when calling postAssignment");
        }
        Call call = this.postAssignmentCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AssignmentItemResponse postAssignment(PostAssignmentRequest request) throws ApiException {
        try {
            ApiResponse<AssignmentItemResponse> resp = this.postAssignmentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AssignmentItemResponse> resp = this.postAssignmentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AssignmentItemResponse> postAssignmentWithHttpInfo(PostAssignmentRequest request) throws ApiException {
        Call call = this.postAssignmentValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AssignmentItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postAssignmentAsync(PostAssignmentRequest request, final ApiCallback<AssignmentItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postAssignmentValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AssignmentItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putAssignmentCall(PutAssignmentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ResourceAssignment localVarPostBody = request.getassignment();
        String localVarPath = "/tasks/{name}/assignments/{assignmentUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{assignmentUid\\}", this.apiClient.escapeString(request.getassignmentUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "mode", request.getmode());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "recalculate", request.getrecalculate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putAssignmentValidateBeforeCall(PutAssignmentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putAssignment");
        }
        if (request.getassignmentUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'assignmentUid' when calling putAssignment");
        }
        if (request.getassignment() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'assignment' when calling putAssignment");
        }
        Call call = this.putAssignmentCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AssignmentResponse putAssignment(PutAssignmentRequest request) throws ApiException {
        try {
            ApiResponse<AssignmentResponse> resp = this.putAssignmentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AssignmentResponse> resp = this.putAssignmentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AssignmentResponse> putAssignmentWithHttpInfo(PutAssignmentRequest request) throws ApiException {
        Call call = this.putAssignmentValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AssignmentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putAssignmentAsync(PutAssignmentRequest request, final ApiCallback<AssignmentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putAssignmentValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AssignmentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteCalendarCall(DeleteCalendarRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/calendars/{calendarUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{calendarUid\\}", this.apiClient.escapeString(request.getcalendarUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCalendarValidateBeforeCall(DeleteCalendarRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteCalendar");
        }
        if (request.getcalendarUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarUid' when calling deleteCalendar");
        }
        Call call = this.deleteCalendarCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteCalendar(DeleteCalendarRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteCalendarWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteCalendarWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteCalendarWithHttpInfo(DeleteCalendarRequest request) throws ApiException {
        Call call = this.deleteCalendarValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteCalendarAsync(DeleteCalendarRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCalendarValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteCalendarExceptionCall(DeleteCalendarExceptionRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/calendars/{calendarUid}/calendarExceptions/{index}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{calendarUid\\}", this.apiClient.escapeString(request.getcalendarUid().toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(request.getindex().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCalendarExceptionValidateBeforeCall(DeleteCalendarExceptionRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteCalendarException");
        }
        if (request.getcalendarUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarUid' when calling deleteCalendarException");
        }
        if (request.getindex() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'index' when calling deleteCalendarException");
        }
        Call call = this.deleteCalendarExceptionCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteCalendarException(DeleteCalendarExceptionRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteCalendarExceptionWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteCalendarExceptionWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteCalendarExceptionWithHttpInfo(DeleteCalendarExceptionRequest request) throws ApiException {
        Call call = this.deleteCalendarExceptionValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteCalendarExceptionAsync(DeleteCalendarExceptionRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCalendarExceptionValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getCalendarCall(GetCalendarRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/calendars/{calendarUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{calendarUid\\}", this.apiClient.escapeString(request.getcalendarUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCalendarValidateBeforeCall(GetCalendarRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getCalendar");
        }
        if (request.getcalendarUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarUid' when calling getCalendar");
        }
        Call call = this.getCalendarCall(request, progressListener, progressRequestListener);
        return call;
    }

    public CalendarResponse getCalendar(GetCalendarRequest request) throws ApiException {
        try {
            ApiResponse<CalendarResponse> resp = this.getCalendarWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<CalendarResponse> resp = this.getCalendarWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<CalendarResponse> getCalendarWithHttpInfo(GetCalendarRequest request) throws ApiException {
        Call call = this.getCalendarValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<CalendarResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCalendarAsync(GetCalendarRequest request, final ApiCallback<CalendarResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCalendarValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CalendarResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getCalendarExceptionsCall(GetCalendarExceptionsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/calendars/{calendarUid}/calendarExceptions".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{calendarUid\\}", this.apiClient.escapeString(request.getcalendarUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCalendarExceptionsValidateBeforeCall(GetCalendarExceptionsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getCalendarExceptions");
        }
        if (request.getcalendarUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarUid' when calling getCalendarExceptions");
        }
        Call call = this.getCalendarExceptionsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public CalendarExceptionsResponse getCalendarExceptions(GetCalendarExceptionsRequest request) throws ApiException {
        try {
            ApiResponse<CalendarExceptionsResponse> resp = this.getCalendarExceptionsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<CalendarExceptionsResponse> resp = this.getCalendarExceptionsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<CalendarExceptionsResponse> getCalendarExceptionsWithHttpInfo(GetCalendarExceptionsRequest request) throws ApiException {
        Call call = this.getCalendarExceptionsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<CalendarExceptionsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCalendarExceptionsAsync(GetCalendarExceptionsRequest request, final ApiCallback<CalendarExceptionsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCalendarExceptionsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CalendarExceptionsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getCalendarWorkWeeksCall(GetCalendarWorkWeeksRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/calendars/{calendarUid}/workWeeks".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{calendarUid\\}", this.apiClient.escapeString(request.getcalendarUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCalendarWorkWeeksValidateBeforeCall(GetCalendarWorkWeeksRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getCalendarWorkWeeks");
        }
        if (request.getcalendarUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarUid' when calling getCalendarWorkWeeks");
        }
        Call call = this.getCalendarWorkWeeksCall(request, progressListener, progressRequestListener);
        return call;
    }

    public CalendarWorkWeeksResponse getCalendarWorkWeeks(GetCalendarWorkWeeksRequest request) throws ApiException {
        try {
            ApiResponse<CalendarWorkWeeksResponse> resp = this.getCalendarWorkWeeksWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<CalendarWorkWeeksResponse> resp = this.getCalendarWorkWeeksWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<CalendarWorkWeeksResponse> getCalendarWorkWeeksWithHttpInfo(GetCalendarWorkWeeksRequest request) throws ApiException {
        Call call = this.getCalendarWorkWeeksValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<CalendarWorkWeeksResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCalendarWorkWeeksAsync(GetCalendarWorkWeeksRequest request, final ApiCallback<CalendarWorkWeeksResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCalendarWorkWeeksValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CalendarWorkWeeksResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getCalendarsCall(GetCalendarsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/calendars".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCalendarsValidateBeforeCall(GetCalendarsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getCalendars");
        }
        Call call = this.getCalendarsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public CalendarItemsResponse getCalendars(GetCalendarsRequest request) throws ApiException {
        try {
            ApiResponse<CalendarItemsResponse> resp = this.getCalendarsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<CalendarItemsResponse> resp = this.getCalendarsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<CalendarItemsResponse> getCalendarsWithHttpInfo(GetCalendarsRequest request) throws ApiException {
        Call call = this.getCalendarsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<CalendarItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCalendarsAsync(GetCalendarsRequest request, final ApiCallback<CalendarItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCalendarsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CalendarItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postCalendarCall(PostCalendarRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Calendar localVarPostBody = request.getcalendar();
        String localVarPath = "/tasks/{name}/calendars".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCalendarValidateBeforeCall(PostCalendarRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postCalendar");
        }
        if (request.getcalendar() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendar' when calling postCalendar");
        }
        Call call = this.postCalendarCall(request, progressListener, progressRequestListener);
        return call;
    }

    public CalendarItemResponse postCalendar(PostCalendarRequest request) throws ApiException {
        try {
            ApiResponse<CalendarItemResponse> resp = this.postCalendarWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<CalendarItemResponse> resp = this.postCalendarWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<CalendarItemResponse> postCalendarWithHttpInfo(PostCalendarRequest request) throws ApiException {
        Call call = this.postCalendarValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<CalendarItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCalendarAsync(PostCalendarRequest request, final ApiCallback<CalendarItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCalendarValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CalendarItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postCalendarExceptionCall(PostCalendarExceptionRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CalendarException localVarPostBody = request.getcalendarException();
        String localVarPath = "/tasks/{name}/calendars/{calendarUid}/calendarExceptions".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{calendarUid\\}", this.apiClient.escapeString(request.getcalendarUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCalendarExceptionValidateBeforeCall(PostCalendarExceptionRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postCalendarException");
        }
        if (request.getcalendarUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarUid' when calling postCalendarException");
        }
        if (request.getcalendarException() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarException' when calling postCalendarException");
        }
        Call call = this.postCalendarExceptionCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse postCalendarException(PostCalendarExceptionRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.postCalendarExceptionWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.postCalendarExceptionWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> postCalendarExceptionWithHttpInfo(PostCalendarExceptionRequest request) throws ApiException {
        Call call = this.postCalendarExceptionValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCalendarExceptionAsync(PostCalendarExceptionRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCalendarExceptionValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putCalendarCall(PutCalendarRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Calendar localVarPostBody = request.getcalendar();
        String localVarPath = "/tasks/{name}/calendars".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "calendarUid", request.getcalendarUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putCalendarValidateBeforeCall(PutCalendarRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putCalendar");
        }
        if (request.getcalendarUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarUid' when calling putCalendar");
        }
        if (request.getcalendar() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendar' when calling putCalendar");
        }
        Call call = this.putCalendarCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putCalendar(PutCalendarRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putCalendarWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putCalendarWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putCalendarWithHttpInfo(PutCalendarRequest request) throws ApiException {
        Call call = this.putCalendarValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putCalendarAsync(PutCalendarRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putCalendarValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putCalendarExceptionCall(PutCalendarExceptionRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CalendarException localVarPostBody = request.getcalendarException();
        String localVarPath = "/tasks/{name}/calendars/{calendarUid}/calendarExceptions/{index}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{calendarUid\\}", this.apiClient.escapeString(request.getcalendarUid().toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(request.getindex().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putCalendarExceptionValidateBeforeCall(PutCalendarExceptionRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putCalendarException");
        }
        if (request.getcalendarUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarUid' when calling putCalendarException");
        }
        if (request.getindex() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'index' when calling putCalendarException");
        }
        if (request.getcalendarException() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarException' when calling putCalendarException");
        }
        Call call = this.putCalendarExceptionCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putCalendarException(PutCalendarExceptionRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putCalendarExceptionWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putCalendarExceptionWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putCalendarExceptionWithHttpInfo(PutCalendarExceptionRequest request) throws ApiException {
        Call call = this.putCalendarExceptionValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putCalendarExceptionAsync(PutCalendarExceptionRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putCalendarExceptionValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getCriticalPathCall(GetCriticalPathRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/criticalPath".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCriticalPathValidateBeforeCall(GetCriticalPathRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getCriticalPath");
        }
        Call call = this.getCriticalPathCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskItemsResponse getCriticalPath(GetCriticalPathRequest request) throws ApiException {
        try {
            ApiResponse<TaskItemsResponse> resp = this.getCriticalPathWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskItemsResponse> resp = this.getCriticalPathWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskItemsResponse> getCriticalPathWithHttpInfo(GetCriticalPathRequest request) throws ApiException {
        Call call = this.getCriticalPathValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCriticalPathAsync(GetCriticalPathRequest request, final ApiCallback<TaskItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCriticalPathValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getPageCountCall(GetPageCountRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/pagecount".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "pageSize", request.getpageSize());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "presentationFormat", request.getpresentationFormat());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "timescale", request.gettimescale());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "startDate", request.getstartDate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "endDate", request.getendDate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPageCountValidateBeforeCall(GetPageCountRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getPageCount");
        }
        Call call = this.getPageCountCall(request, progressListener, progressRequestListener);
        return call;
    }

    public PageCountResponse getPageCount(GetPageCountRequest request) throws ApiException {
        try {
            ApiResponse<PageCountResponse> resp = this.getPageCountWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<PageCountResponse> resp = this.getPageCountWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<PageCountResponse> getPageCountWithHttpInfo(GetPageCountRequest request) throws ApiException {
        Call call = this.getPageCountValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<PageCountResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPageCountAsync(GetPageCountRequest request, final ApiCallback<PageCountResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPageCountValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageCountResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getProjectIdsCall(GetProjectIdsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/projectids".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getProjectIdsValidateBeforeCall(GetProjectIdsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getProjectIds");
        }
        Call call = this.getProjectIdsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ProjectIdsResponse getProjectIds(GetProjectIdsRequest request) throws ApiException {
        try {
            ApiResponse<ProjectIdsResponse> resp = this.getProjectIdsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ProjectIdsResponse> resp = this.getProjectIdsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ProjectIdsResponse> getProjectIdsWithHttpInfo(GetProjectIdsRequest request) throws ApiException {
        Call call = this.getProjectIdsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ProjectIdsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getProjectIdsAsync(GetProjectIdsRequest request, final ApiCallback<ProjectIdsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getProjectIdsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProjectIdsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTaskDocumentCall(GetTaskDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"multipart/form-data"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaskDocumentValidateBeforeCall(GetTaskDocumentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTaskDocument");
        }
        Call call = this.getTaskDocumentCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File getTaskDocument(GetTaskDocumentRequest request) throws ApiException {
        try {
            ApiResponse<File> resp = this.getTaskDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<File> resp = this.getTaskDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<File> getTaskDocumentWithHttpInfo(GetTaskDocumentRequest request) throws ApiException {
        Call call = this.getTaskDocumentValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaskDocumentAsync(GetTaskDocumentRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaskDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTaskDocumentWithFormatCall(GetTaskDocumentWithFormatRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/format".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "format", request.getformat());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "returnAsZipArchive", request.getreturnAsZipArchive());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"multipart/form-data"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaskDocumentWithFormatValidateBeforeCall(GetTaskDocumentWithFormatRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTaskDocumentWithFormat");
        }
        if (request.getformat() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'format' when calling getTaskDocumentWithFormat");
        }
        Call call = this.getTaskDocumentWithFormatCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File getTaskDocumentWithFormat(GetTaskDocumentWithFormatRequest request) throws ApiException {
        try {
            ApiResponse<File> resp = this.getTaskDocumentWithFormatWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<File> resp = this.getTaskDocumentWithFormatWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<File> getTaskDocumentWithFormatWithHttpInfo(GetTaskDocumentWithFormatRequest request) throws ApiException {
        Call call = this.getTaskDocumentWithFormatValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaskDocumentWithFormatAsync(GetTaskDocumentWithFormatRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaskDocumentWithFormatValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putImportProjectFromDbCall(PutImportProjectFromDbRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = request.getconnectionString();
        String localVarPath = "/tasks/importfromdb";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "databaseType", request.getdatabaseType());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "projectUid", request.getprojectUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "filename", request.getfilename());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "format", request.getformat());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "databaseSchema", request.getdatabaseSchema());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putImportProjectFromDbValidateBeforeCall(PutImportProjectFromDbRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getdatabaseType() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'databaseType' when calling putImportProjectFromDb");
        }
        if (request.getconnectionString() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'connectionString' when calling putImportProjectFromDb");
        }
        if (request.getprojectUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'projectUid' when calling putImportProjectFromDb");
        }
        if (request.getfilename() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'filename' when calling putImportProjectFromDb");
        }
        Call call = this.putImportProjectFromDbCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putImportProjectFromDb(PutImportProjectFromDbRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putImportProjectFromDbWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putImportProjectFromDbWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putImportProjectFromDbWithHttpInfo(PutImportProjectFromDbRequest request) throws ApiException {
        Call call = this.putImportProjectFromDbValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putImportProjectFromDbAsync(PutImportProjectFromDbRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putImportProjectFromDbValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putImportProjectFromFileCall(PutImportProjectFromFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/import".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "projectUid", request.getprojectUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "filename", request.getfilename());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileType", request.getfileType());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "outputFileFormat", request.getoutputFileFormat());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putImportProjectFromFileValidateBeforeCall(PutImportProjectFromFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putImportProjectFromFile");
        }
        if (request.getprojectUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'projectUid' when calling putImportProjectFromFile");
        }
        if (request.getfilename() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'filename' when calling putImportProjectFromFile");
        }
        Call call = this.putImportProjectFromFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putImportProjectFromFile(PutImportProjectFromFileRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putImportProjectFromFileWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putImportProjectFromFileWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putImportProjectFromFileWithHttpInfo(PutImportProjectFromFileRequest request) throws ApiException {
        Call call = this.putImportProjectFromFileValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putImportProjectFromFileAsync(PutImportProjectFromFileRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putImportProjectFromFileValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putImportProjectFromProjectOnlineCall(PutImportProjectFromProjectOnlineRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = request.getguid();
        String localVarPath = "/tasks/{name}/importfromprojectonline".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "siteUrl", request.getsiteUrl());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "userName", request.getuserName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "format", request.getformat());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (request.getxProjectOnlineToken() != null) {
            localVarHeaderParams.put("xProjectOnlineToken", this.apiClient.parameterToString(request.getxProjectOnlineToken()));
        }
        if (request.getxSharepointPassword() != null) {
            localVarHeaderParams.put("xSharepointPassword", this.apiClient.parameterToString(request.getxSharepointPassword()));
        }
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putImportProjectFromProjectOnlineValidateBeforeCall(PutImportProjectFromProjectOnlineRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putImportProjectFromProjectOnline");
        }
        if (request.getguid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'guid' when calling putImportProjectFromProjectOnline");
        }
        if (request.getsiteUrl() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'siteUrl' when calling putImportProjectFromProjectOnline");
        }
        Call call = this.putImportProjectFromProjectOnlineCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putImportProjectFromProjectOnline(PutImportProjectFromProjectOnlineRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putImportProjectFromProjectOnlineWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putImportProjectFromProjectOnlineWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putImportProjectFromProjectOnlineWithHttpInfo(PutImportProjectFromProjectOnlineRequest request) throws ApiException {
        Call call = this.putImportProjectFromProjectOnlineValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putImportProjectFromProjectOnlineAsync(PutImportProjectFromProjectOnlineRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putImportProjectFromProjectOnlineValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getDocumentPropertiesCall(GetDocumentPropertiesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/documentproperties".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDocumentPropertiesValidateBeforeCall(GetDocumentPropertiesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getDocumentProperties");
        }
        Call call = this.getDocumentPropertiesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentPropertiesResponse getDocumentProperties(GetDocumentPropertiesRequest request) throws ApiException {
        try {
            ApiResponse<DocumentPropertiesResponse> resp = this.getDocumentPropertiesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<DocumentPropertiesResponse> resp = this.getDocumentPropertiesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<DocumentPropertiesResponse> getDocumentPropertiesWithHttpInfo(GetDocumentPropertiesRequest request) throws ApiException {
        Call call = this.getDocumentPropertiesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentPropertiesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDocumentPropertiesAsync(GetDocumentPropertiesRequest request, final ApiCallback<DocumentPropertiesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDocumentPropertiesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentPropertiesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getDocumentPropertyCall(GetDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/documentproperties/{propertyName}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{propertyName\\}", this.apiClient.escapeString(request.getpropertyName().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDocumentPropertyValidateBeforeCall(GetDocumentPropertyRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getDocumentProperty");
        }
        if (request.getpropertyName() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'propertyName' when calling getDocumentProperty");
        }
        Call call = this.getDocumentPropertyCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentPropertyResponse getDocumentProperty(GetDocumentPropertyRequest request) throws ApiException {
        try {
            ApiResponse<DocumentPropertyResponse> resp = this.getDocumentPropertyWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<DocumentPropertyResponse> resp = this.getDocumentPropertyWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<DocumentPropertyResponse> getDocumentPropertyWithHttpInfo(GetDocumentPropertyRequest request) throws ApiException {
        Call call = this.getDocumentPropertyValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentPropertyResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDocumentPropertyAsync(GetDocumentPropertyRequest request, final ApiCallback<DocumentPropertyResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentPropertyResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postDocumentPropertyCall(PostDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DocumentProperty localVarPostBody = request.getproperty();
        String localVarPath = "/tasks/{name}/documentproperties/{propertyName}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{propertyName\\}", this.apiClient.escapeString(request.getpropertyName().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "filename", request.getfilename());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postDocumentPropertyValidateBeforeCall(PostDocumentPropertyRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postDocumentProperty");
        }
        if (request.getpropertyName() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'propertyName' when calling postDocumentProperty");
        }
        if (request.getproperty() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'property' when calling postDocumentProperty");
        }
        Call call = this.postDocumentPropertyCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentPropertyResponse postDocumentProperty(PostDocumentPropertyRequest request) throws ApiException {
        try {
            ApiResponse<DocumentPropertyResponse> resp = this.postDocumentPropertyWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<DocumentPropertyResponse> resp = this.postDocumentPropertyWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<DocumentPropertyResponse> postDocumentPropertyWithHttpInfo(PostDocumentPropertyRequest request) throws ApiException {
        Call call = this.postDocumentPropertyValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentPropertyResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postDocumentPropertyAsync(PostDocumentPropertyRequest request, final ApiCallback<DocumentPropertyResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentPropertyResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putDocumentPropertyCall(PutDocumentPropertyRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DocumentProperty localVarPostBody = request.getproperty();
        String localVarPath = "/tasks/{name}/documentproperties/{propertyName}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{propertyName\\}", this.apiClient.escapeString(request.getpropertyName().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "filename", request.getfilename());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putDocumentPropertyValidateBeforeCall(PutDocumentPropertyRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putDocumentProperty");
        }
        if (request.getpropertyName() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'propertyName' when calling putDocumentProperty");
        }
        if (request.getproperty() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'property' when calling putDocumentProperty");
        }
        Call call = this.putDocumentPropertyCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentPropertyResponse putDocumentProperty(PutDocumentPropertyRequest request) throws ApiException {
        try {
            ApiResponse<DocumentPropertyResponse> resp = this.putDocumentPropertyWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<DocumentPropertyResponse> resp = this.putDocumentPropertyWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<DocumentPropertyResponse> putDocumentPropertyWithHttpInfo(PutDocumentPropertyRequest request) throws ApiException {
        Call call = this.putDocumentPropertyValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentPropertyResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putDocumentPropertyAsync(PutDocumentPropertyRequest request, final ApiCallback<DocumentPropertyResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putDocumentPropertyValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentPropertyResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteExtendedAttributeByIndexCall(DeleteExtendedAttributeByIndexRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/extendedAttributes/{index}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(request.getindex().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteExtendedAttributeByIndexValidateBeforeCall(DeleteExtendedAttributeByIndexRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteExtendedAttributeByIndex");
        }
        if (request.getindex() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'index' when calling deleteExtendedAttributeByIndex");
        }
        Call call = this.deleteExtendedAttributeByIndexCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteExtendedAttributeByIndex(DeleteExtendedAttributeByIndexRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteExtendedAttributeByIndexWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteExtendedAttributeByIndexWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteExtendedAttributeByIndexWithHttpInfo(DeleteExtendedAttributeByIndexRequest request) throws ApiException {
        Call call = this.deleteExtendedAttributeByIndexValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteExtendedAttributeByIndexAsync(DeleteExtendedAttributeByIndexRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteExtendedAttributeByIndexValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getExtendedAttributeByIndexCall(GetExtendedAttributeByIndexRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/extendedAttributes/{index}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(request.getindex().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getExtendedAttributeByIndexValidateBeforeCall(GetExtendedAttributeByIndexRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getExtendedAttributeByIndex");
        }
        if (request.getindex() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'index' when calling getExtendedAttributeByIndex");
        }
        Call call = this.getExtendedAttributeByIndexCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ExtendedAttributeResponse getExtendedAttributeByIndex(GetExtendedAttributeByIndexRequest request) throws ApiException {
        try {
            ApiResponse<ExtendedAttributeResponse> resp = this.getExtendedAttributeByIndexWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ExtendedAttributeResponse> resp = this.getExtendedAttributeByIndexWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ExtendedAttributeResponse> getExtendedAttributeByIndexWithHttpInfo(GetExtendedAttributeByIndexRequest request) throws ApiException {
        Call call = this.getExtendedAttributeByIndexValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ExtendedAttributeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getExtendedAttributeByIndexAsync(GetExtendedAttributeByIndexRequest request, final ApiCallback<ExtendedAttributeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getExtendedAttributeByIndexValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ExtendedAttributeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getExtendedAttributesCall(GetExtendedAttributesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/extendedAttributes".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getExtendedAttributesValidateBeforeCall(GetExtendedAttributesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getExtendedAttributes");
        }
        Call call = this.getExtendedAttributesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ExtendedAttributeItemsResponse getExtendedAttributes(GetExtendedAttributesRequest request) throws ApiException {
        try {
            ApiResponse<ExtendedAttributeItemsResponse> resp = this.getExtendedAttributesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ExtendedAttributeItemsResponse> resp = this.getExtendedAttributesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ExtendedAttributeItemsResponse> getExtendedAttributesWithHttpInfo(GetExtendedAttributesRequest request) throws ApiException {
        Call call = this.getExtendedAttributesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ExtendedAttributeItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getExtendedAttributesAsync(GetExtendedAttributesRequest request, final ApiCallback<ExtendedAttributeItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getExtendedAttributesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ExtendedAttributeItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putExtendedAttributeCall(PutExtendedAttributeRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ExtendedAttributeDefinition localVarPostBody = request.getextendedAttribute();
        String localVarPath = "/tasks/{name}/extendedAttributes".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putExtendedAttributeValidateBeforeCall(PutExtendedAttributeRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getextendedAttribute() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'extendedAttribute' when calling putExtendedAttribute");
        }
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putExtendedAttribute");
        }
        Call call = this.putExtendedAttributeCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ExtendedAttributeItemResponse putExtendedAttribute(PutExtendedAttributeRequest request) throws ApiException {
        try {
            ApiResponse<ExtendedAttributeItemResponse> resp = this.putExtendedAttributeWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ExtendedAttributeItemResponse> resp = this.putExtendedAttributeWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ExtendedAttributeItemResponse> putExtendedAttributeWithHttpInfo(PutExtendedAttributeRequest request) throws ApiException {
        Call call = this.putExtendedAttributeValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ExtendedAttributeItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putExtendedAttributeAsync(PutExtendedAttributeRequest request, final ApiCallback<ExtendedAttributeItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putExtendedAttributeValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ExtendedAttributeItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteOutlineCodeByIndexCall(DeleteOutlineCodeByIndexRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/outlineCodes/{index}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(request.getindex().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteOutlineCodeByIndexValidateBeforeCall(DeleteOutlineCodeByIndexRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteOutlineCodeByIndex");
        }
        if (request.getindex() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'index' when calling deleteOutlineCodeByIndex");
        }
        Call call = this.deleteOutlineCodeByIndexCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteOutlineCodeByIndex(DeleteOutlineCodeByIndexRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteOutlineCodeByIndexWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteOutlineCodeByIndexWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteOutlineCodeByIndexWithHttpInfo(DeleteOutlineCodeByIndexRequest request) throws ApiException {
        Call call = this.deleteOutlineCodeByIndexValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteOutlineCodeByIndexAsync(DeleteOutlineCodeByIndexRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteOutlineCodeByIndexValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getOutlineCodeByIndexCall(GetOutlineCodeByIndexRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/outlineCodes/{index}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(request.getindex().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOutlineCodeByIndexValidateBeforeCall(GetOutlineCodeByIndexRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getOutlineCodeByIndex");
        }
        if (request.getindex() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'index' when calling getOutlineCodeByIndex");
        }
        Call call = this.getOutlineCodeByIndexCall(request, progressListener, progressRequestListener);
        return call;
    }

    public OutlineCodeResponse getOutlineCodeByIndex(GetOutlineCodeByIndexRequest request) throws ApiException {
        try {
            ApiResponse<OutlineCodeResponse> resp = this.getOutlineCodeByIndexWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<OutlineCodeResponse> resp = this.getOutlineCodeByIndexWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<OutlineCodeResponse> getOutlineCodeByIndexWithHttpInfo(GetOutlineCodeByIndexRequest request) throws ApiException {
        Call call = this.getOutlineCodeByIndexValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<OutlineCodeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOutlineCodeByIndexAsync(GetOutlineCodeByIndexRequest request, final ApiCallback<OutlineCodeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOutlineCodeByIndexValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OutlineCodeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getOutlineCodesCall(GetOutlineCodesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/outlineCodes".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOutlineCodesValidateBeforeCall(GetOutlineCodesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getOutlineCodes");
        }
        Call call = this.getOutlineCodesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public OutlineCodeItemsResponse getOutlineCodes(GetOutlineCodesRequest request) throws ApiException {
        try {
            ApiResponse<OutlineCodeItemsResponse> resp = this.getOutlineCodesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<OutlineCodeItemsResponse> resp = this.getOutlineCodesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<OutlineCodeItemsResponse> getOutlineCodesWithHttpInfo(GetOutlineCodesRequest request) throws ApiException {
        Call call = this.getOutlineCodesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<OutlineCodeItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOutlineCodesAsync(GetOutlineCodesRequest request, final ApiCallback<OutlineCodeItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOutlineCodesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OutlineCodeItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call createNewProjectCall(CreateNewProjectRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ProjectServerSaveOptionsDTO localVarPostBody = request.getsaveOptions();
        String localVarPath = "/tasks/projectOnline/{siteUrl}/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{siteUrl\\}", this.apiClient.escapeString(request.getsiteUrl().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "userName", request.getuserName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (request.getxProjectOnlineToken() != null) {
            localVarHeaderParams.put("xProjectOnlineToken", this.apiClient.parameterToString(request.getxProjectOnlineToken()));
        }
        if (request.getxSharepointPassword() != null) {
            localVarHeaderParams.put("xSharepointPassword", this.apiClient.parameterToString(request.getxSharepointPassword()));
        }
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createNewProjectValidateBeforeCall(CreateNewProjectRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling createNewProject");
        }
        if (request.getsiteUrl() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'siteUrl' when calling createNewProject");
        }
        Call call = this.createNewProjectCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse createNewProject(CreateNewProjectRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.createNewProjectWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.createNewProjectWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> createNewProjectWithHttpInfo(CreateNewProjectRequest request) throws ApiException {
        Call call = this.createNewProjectValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createNewProjectAsync(CreateNewProjectRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createNewProjectValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getProjectListCall(GetProjectListRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/projectOnline/projectList";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "siteUrl", request.getsiteUrl());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "userName", request.getuserName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (request.getxProjectOnlineToken() != null) {
            localVarHeaderParams.put("xProjectOnlineToken", this.apiClient.parameterToString(request.getxProjectOnlineToken()));
        }
        if (request.getxSharepointPassword() != null) {
            localVarHeaderParams.put("xSharepointPassword", this.apiClient.parameterToString(request.getxSharepointPassword()));
        }
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getProjectListValidateBeforeCall(GetProjectListRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsiteUrl() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'siteUrl' when calling getProjectList");
        }
        Call call = this.getProjectListCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ProjectListResponse getProjectList(GetProjectListRequest request) throws ApiException {
        try {
            ApiResponse<ProjectListResponse> resp = this.getProjectListWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ProjectListResponse> resp = this.getProjectListWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ProjectListResponse> getProjectListWithHttpInfo(GetProjectListRequest request) throws ApiException {
        Call call = this.getProjectListValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ProjectListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getProjectListAsync(GetProjectListRequest request, final ApiCallback<ProjectListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getProjectListValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProjectListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateProjectCall(UpdateProjectRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ProjectServerSaveOptionsDTO localVarPostBody = request.getsaveOptions();
        String localVarPath = "/tasks/projectOnline/{siteUrl}/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{siteUrl\\}", this.apiClient.escapeString(request.getsiteUrl().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "userName", request.getuserName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (request.getxProjectOnlineToken() != null) {
            localVarHeaderParams.put("xProjectOnlineToken", this.apiClient.parameterToString(request.getxProjectOnlineToken()));
        }
        if (request.getxSharepointPassword() != null) {
            localVarHeaderParams.put("xSharepointPassword", this.apiClient.parameterToString(request.getxSharepointPassword()));
        }
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateProjectValidateBeforeCall(UpdateProjectRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling updateProject");
        }
        if (request.getsiteUrl() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'siteUrl' when calling updateProject");
        }
        Call call = this.updateProjectCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse updateProject(UpdateProjectRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.updateProjectWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.updateProjectWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> updateProjectWithHttpInfo(UpdateProjectRequest request) throws ApiException {
        Call call = this.updateProjectValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateProjectAsync(UpdateProjectRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateProjectValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putRecalculateProjectCall(PutRecalculateProjectRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/recalculate/project".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "mode", request.getmode());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "validate", request.getvalidate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putRecalculateProjectValidateBeforeCall(PutRecalculateProjectRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putRecalculateProject");
        }
        Call call = this.putRecalculateProjectCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ProjectRecalculateResponse putRecalculateProject(PutRecalculateProjectRequest request) throws ApiException {
        try {
            ApiResponse<ProjectRecalculateResponse> resp = this.putRecalculateProjectWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ProjectRecalculateResponse> resp = this.putRecalculateProjectWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ProjectRecalculateResponse> putRecalculateProjectWithHttpInfo(PutRecalculateProjectRequest request) throws ApiException {
        Call call = this.putRecalculateProjectValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ProjectRecalculateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putRecalculateProjectAsync(PutRecalculateProjectRequest request, final ApiCallback<ProjectRecalculateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putRecalculateProjectValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProjectRecalculateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putRecalculateProjectResourceFieldsCall(PutRecalculateProjectResourceFieldsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/recalculate/resourceFields".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putRecalculateProjectResourceFieldsValidateBeforeCall(PutRecalculateProjectResourceFieldsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putRecalculateProjectResourceFields");
        }
        Call call = this.putRecalculateProjectResourceFieldsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putRecalculateProjectResourceFields(PutRecalculateProjectResourceFieldsRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putRecalculateProjectResourceFieldsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putRecalculateProjectResourceFieldsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putRecalculateProjectResourceFieldsWithHttpInfo(PutRecalculateProjectResourceFieldsRequest request) throws ApiException {
        Call call = this.putRecalculateProjectResourceFieldsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putRecalculateProjectResourceFieldsAsync(PutRecalculateProjectResourceFieldsRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putRecalculateProjectResourceFieldsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putRecalculateProjectUncompleteWorkToStartAfterCall(PutRecalculateProjectUncompleteWorkToStartAfterRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OffsetDateTime localVarPostBody = request.getafter();
        String localVarPath = "/tasks/{name}/recalculate/uncompleteWorkToStartAfter".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putRecalculateProjectUncompleteWorkToStartAfterValidateBeforeCall(PutRecalculateProjectUncompleteWorkToStartAfterRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putRecalculateProjectUncompleteWorkToStartAfter");
        }
        if (request.getafter() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'after' when calling putRecalculateProjectUncompleteWorkToStartAfter");
        }
        Call call = this.putRecalculateProjectUncompleteWorkToStartAfterCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putRecalculateProjectUncompleteWorkToStartAfter(PutRecalculateProjectUncompleteWorkToStartAfterRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putRecalculateProjectUncompleteWorkToStartAfterWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putRecalculateProjectUncompleteWorkToStartAfterWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putRecalculateProjectUncompleteWorkToStartAfterWithHttpInfo(PutRecalculateProjectUncompleteWorkToStartAfterRequest request) throws ApiException {
        Call call = this.putRecalculateProjectUncompleteWorkToStartAfterValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putRecalculateProjectUncompleteWorkToStartAfterAsync(PutRecalculateProjectUncompleteWorkToStartAfterRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putRecalculateProjectUncompleteWorkToStartAfterValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putRecalculateProjectWorkAsCompleteCall(PutRecalculateProjectWorkAsCompleteRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OffsetDateTime localVarPostBody = request.getcompleteThrough();
        String localVarPath = "/tasks/{name}/recalculate/projectWorkAsComplete".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "setZeroOrHundredPercentCompleteOnly", request.getsetZeroOrHundredPercentCompleteOnly());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putRecalculateProjectWorkAsCompleteValidateBeforeCall(PutRecalculateProjectWorkAsCompleteRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putRecalculateProjectWorkAsComplete");
        }
        if (request.getcompleteThrough() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'completeThrough' when calling putRecalculateProjectWorkAsComplete");
        }
        Call call = this.putRecalculateProjectWorkAsCompleteCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putRecalculateProjectWorkAsComplete(PutRecalculateProjectWorkAsCompleteRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putRecalculateProjectWorkAsCompleteWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putRecalculateProjectWorkAsCompleteWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putRecalculateProjectWorkAsCompleteWithHttpInfo(PutRecalculateProjectWorkAsCompleteRequest request) throws ApiException {
        Call call = this.putRecalculateProjectWorkAsCompleteValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putRecalculateProjectWorkAsCompleteAsync(PutRecalculateProjectWorkAsCompleteRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putRecalculateProjectWorkAsCompleteValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getReportPdfCall(GetReportPdfRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/report".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "type", request.gettype());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getReportPdfValidateBeforeCall(GetReportPdfRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getReportPdf");
        }
        if (request.gettype() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'type' when calling getReportPdf");
        }
        Call call = this.getReportPdfCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File getReportPdf(GetReportPdfRequest request) throws ApiException {
        try {
            ApiResponse<File> resp = this.getReportPdfWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<File> resp = this.getReportPdfWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<File> getReportPdfWithHttpInfo(GetReportPdfRequest request) throws ApiException {
        Call call = this.getReportPdfValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getReportPdfAsync(GetReportPdfRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getReportPdfValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call clearLevelingCall(ClearLevelingRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<Integer> localVarPostBody = request.gettaskUids();
        String localVarPath = "/tasks/{name}/resourceLevel".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call clearLevelingValidateBeforeCall(ClearLevelingRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling clearLeveling");
        }
        Call call = this.clearLevelingCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse clearLeveling(ClearLevelingRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.clearLevelingWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.clearLevelingWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> clearLevelingWithHttpInfo(ClearLevelingRequest request) throws ApiException {
        Call call = this.clearLevelingValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call clearLevelingAsync(ClearLevelingRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.clearLevelingValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call levelTasksCall(LevelTasksRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LevelingOptions localVarPostBody = request.getoptions();
        String localVarPath = "/tasks/{name}/resourceLevel".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call levelTasksValidateBeforeCall(LevelTasksRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling levelTasks");
        }
        Call call = this.levelTasksCall(request, progressListener, progressRequestListener);
        return call;
    }

    public LevelingResponse levelTasks(LevelTasksRequest request) throws ApiException {
        try {
            ApiResponse<LevelingResponse> resp = this.levelTasksWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<LevelingResponse> resp = this.levelTasksWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<LevelingResponse> levelTasksWithHttpInfo(LevelTasksRequest request) throws ApiException {
        Call call = this.levelTasksValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<LevelingResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call levelTasksAsync(LevelTasksRequest request, final ApiCallback<LevelingResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.levelTasksValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LevelingResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteResourceCall(DeleteResourceRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/resources/{resourceUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{resourceUid\\}", this.apiClient.escapeString(request.getresourceUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteResourceValidateBeforeCall(DeleteResourceRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteResource");
        }
        if (request.getresourceUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'resourceUid' when calling deleteResource");
        }
        Call call = this.deleteResourceCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteResource(DeleteResourceRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteResourceWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteResourceWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteResourceWithHttpInfo(DeleteResourceRequest request) throws ApiException {
        Call call = this.deleteResourceValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteResourceAsync(DeleteResourceRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteResourceValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getResourceCall(GetResourceRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/resources/{resourceUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{resourceUid\\}", this.apiClient.escapeString(request.getresourceUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getResourceValidateBeforeCall(GetResourceRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getResource");
        }
        if (request.getresourceUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'resourceUid' when calling getResource");
        }
        Call call = this.getResourceCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ResourceResponse getResource(GetResourceRequest request) throws ApiException {
        try {
            ApiResponse<ResourceResponse> resp = this.getResourceWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ResourceResponse> resp = this.getResourceWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ResourceResponse> getResourceWithHttpInfo(GetResourceRequest request) throws ApiException {
        Call call = this.getResourceValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ResourceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getResourceAsync(GetResourceRequest request, final ApiCallback<ResourceResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getResourceValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getResourceAssignmentsCall(GetResourceAssignmentsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/resources/{resourceUid}/assignments".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{resourceUid\\}", this.apiClient.escapeString(request.getresourceUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getResourceAssignmentsValidateBeforeCall(GetResourceAssignmentsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getResourceAssignments");
        }
        if (request.getresourceUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'resourceUid' when calling getResourceAssignments");
        }
        Call call = this.getResourceAssignmentsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AssignmentsResponse getResourceAssignments(GetResourceAssignmentsRequest request) throws ApiException {
        try {
            ApiResponse<AssignmentsResponse> resp = this.getResourceAssignmentsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AssignmentsResponse> resp = this.getResourceAssignmentsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AssignmentsResponse> getResourceAssignmentsWithHttpInfo(GetResourceAssignmentsRequest request) throws ApiException {
        Call call = this.getResourceAssignmentsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AssignmentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getResourceAssignmentsAsync(GetResourceAssignmentsRequest request, final ApiCallback<AssignmentsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getResourceAssignmentsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AssignmentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getResourceTimephasedDataCall(GetResourceTimephasedDataRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/resources/{resourceUid}/timeScaleData".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{resourceUid\\}", this.apiClient.escapeString(request.getresourceUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "type", request.gettype());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "startDate", request.getstartDate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "endDate", request.getendDate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getResourceTimephasedDataValidateBeforeCall(GetResourceTimephasedDataRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getResourceTimephasedData");
        }
        if (request.getresourceUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'resourceUid' when calling getResourceTimephasedData");
        }
        Call call = this.getResourceTimephasedDataCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TimephasedDataResponse getResourceTimephasedData(GetResourceTimephasedDataRequest request) throws ApiException {
        try {
            ApiResponse<TimephasedDataResponse> resp = this.getResourceTimephasedDataWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TimephasedDataResponse> resp = this.getResourceTimephasedDataWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TimephasedDataResponse> getResourceTimephasedDataWithHttpInfo(GetResourceTimephasedDataRequest request) throws ApiException {
        Call call = this.getResourceTimephasedDataValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TimephasedDataResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getResourceTimephasedDataAsync(GetResourceTimephasedDataRequest request, final ApiCallback<TimephasedDataResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getResourceTimephasedDataValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TimephasedDataResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getResourcesCall(GetResourcesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/resources".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getResourcesValidateBeforeCall(GetResourcesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getResources");
        }
        Call call = this.getResourcesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ResourceItemsResponse getResources(GetResourcesRequest request) throws ApiException {
        try {
            ApiResponse<ResourceItemsResponse> resp = this.getResourcesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ResourceItemsResponse> resp = this.getResourcesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ResourceItemsResponse> getResourcesWithHttpInfo(GetResourcesRequest request) throws ApiException {
        Call call = this.getResourcesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ResourceItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getResourcesAsync(GetResourcesRequest request, final ApiCallback<ResourceItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getResourcesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourceItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postResourceCall(PostResourceRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/resources".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "resourceName", request.getresourceName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "beforeResourceId", request.getbeforeResourceId());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postResourceValidateBeforeCall(PostResourceRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postResource");
        }
        Call call = this.postResourceCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ResourceItemResponse postResource(PostResourceRequest request) throws ApiException {
        try {
            ApiResponse<ResourceItemResponse> resp = this.postResourceWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ResourceItemResponse> resp = this.postResourceWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ResourceItemResponse> postResourceWithHttpInfo(PostResourceRequest request) throws ApiException {
        Call call = this.postResourceValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ResourceItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postResourceAsync(PostResourceRequest request, final ApiCallback<ResourceItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postResourceValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourceItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putResourceCall(PutResourceRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Resource localVarPostBody = request.getresource();
        String localVarPath = "/tasks/{name}/resources/{resourceUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{resourceUid\\}", this.apiClient.escapeString(request.getresourceUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "mode", request.getmode());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "recalculate", request.getrecalculate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putResourceValidateBeforeCall(PutResourceRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putResource");
        }
        if (request.getresourceUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'resourceUid' when calling putResource");
        }
        if (request.getresource() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'resource' when calling putResource");
        }
        Call call = this.putResourceCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ResourceResponse putResource(PutResourceRequest request) throws ApiException {
        try {
            ApiResponse<ResourceResponse> resp = this.putResourceWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ResourceResponse> resp = this.putResourceWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ResourceResponse> putResourceWithHttpInfo(PutResourceRequest request) throws ApiException {
        Call call = this.putResourceValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ResourceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putResourceAsync(PutResourceRequest request, final ApiCallback<ResourceResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putResourceValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getRiskAnalysisReportCall(GetRiskAnalysisReportRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/riskAnalysisReport".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "taskUid", request.gettaskUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "distributionType", request.getdistributionType());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "optimistic", request.getoptimistic());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "pessimistic", request.getpessimistic());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "confidenceLevel", request.getconfidenceLevel());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "iterations", request.getiterations());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"multipart/form-data"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRiskAnalysisReportValidateBeforeCall(GetRiskAnalysisReportRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getRiskAnalysisReport");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling getRiskAnalysisReport");
        }
        Call call = this.getRiskAnalysisReportCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File getRiskAnalysisReport(GetRiskAnalysisReportRequest request) throws ApiException {
        try {
            ApiResponse<File> resp = this.getRiskAnalysisReportWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<File> resp = this.getRiskAnalysisReportWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<File> getRiskAnalysisReportWithHttpInfo(GetRiskAnalysisReportRequest request) throws ApiException {
        Call call = this.getRiskAnalysisReportValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRiskAnalysisReportAsync(GetRiskAnalysisReportRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRiskAnalysisReportValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteTaskCall(DeleteTaskRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks/{taskUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTaskValidateBeforeCall(DeleteTaskRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteTask");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling deleteTask");
        }
        Call call = this.deleteTaskCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteTask(DeleteTaskRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteTaskWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteTaskWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteTaskWithHttpInfo(DeleteTaskRequest request) throws ApiException {
        Call call = this.deleteTaskValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteTaskAsync(DeleteTaskRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTaskValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getPrimaveraTaskPropertiesCall(GetPrimaveraTaskPropertiesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks/{taskUid}/primaveraProperties".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPrimaveraTaskPropertiesValidateBeforeCall(GetPrimaveraTaskPropertiesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getPrimaveraTaskProperties");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling getPrimaveraTaskProperties");
        }
        Call call = this.getPrimaveraTaskPropertiesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public PrimaveraTaskPropertiesResponse getPrimaveraTaskProperties(GetPrimaveraTaskPropertiesRequest request) throws ApiException {
        try {
            ApiResponse<PrimaveraTaskPropertiesResponse> resp = this.getPrimaveraTaskPropertiesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<PrimaveraTaskPropertiesResponse> resp = this.getPrimaveraTaskPropertiesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<PrimaveraTaskPropertiesResponse> getPrimaveraTaskPropertiesWithHttpInfo(GetPrimaveraTaskPropertiesRequest request) throws ApiException {
        Call call = this.getPrimaveraTaskPropertiesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<PrimaveraTaskPropertiesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPrimaveraTaskPropertiesAsync(GetPrimaveraTaskPropertiesRequest request, final ApiCallback<PrimaveraTaskPropertiesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPrimaveraTaskPropertiesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PrimaveraTaskPropertiesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTaskCall(GetTaskRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks/{taskUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaskValidateBeforeCall(GetTaskRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTask");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling getTask");
        }
        Call call = this.getTaskCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskResponse getTask(GetTaskRequest request) throws ApiException {
        try {
            ApiResponse<TaskResponse> resp = this.getTaskWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskResponse> resp = this.getTaskWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskResponse> getTaskWithHttpInfo(GetTaskRequest request) throws ApiException {
        Call call = this.getTaskValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaskAsync(GetTaskRequest request, final ApiCallback<TaskResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaskValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTaskAssignmentsCall(GetTaskAssignmentsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks/{taskUid}/assignments".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaskAssignmentsValidateBeforeCall(GetTaskAssignmentsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTaskAssignments");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling getTaskAssignments");
        }
        Call call = this.getTaskAssignmentsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AssignmentsResponse getTaskAssignments(GetTaskAssignmentsRequest request) throws ApiException {
        try {
            ApiResponse<AssignmentsResponse> resp = this.getTaskAssignmentsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AssignmentsResponse> resp = this.getTaskAssignmentsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AssignmentsResponse> getTaskAssignmentsWithHttpInfo(GetTaskAssignmentsRequest request) throws ApiException {
        Call call = this.getTaskAssignmentsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AssignmentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaskAssignmentsAsync(GetTaskAssignmentsRequest request, final ApiCallback<AssignmentsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaskAssignmentsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AssignmentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTaskRecurringInfoCall(GetTaskRecurringInfoRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks/{taskUid}/recurringInfo".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaskRecurringInfoValidateBeforeCall(GetTaskRecurringInfoRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTaskRecurringInfo");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling getTaskRecurringInfo");
        }
        Call call = this.getTaskRecurringInfoCall(request, progressListener, progressRequestListener);
        return call;
    }

    public RecurringInfoResponse getTaskRecurringInfo(GetTaskRecurringInfoRequest request) throws ApiException {
        try {
            ApiResponse<RecurringInfoResponse> resp = this.getTaskRecurringInfoWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<RecurringInfoResponse> resp = this.getTaskRecurringInfoWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<RecurringInfoResponse> getTaskRecurringInfoWithHttpInfo(GetTaskRecurringInfoRequest request) throws ApiException {
        Call call = this.getTaskRecurringInfoValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<RecurringInfoResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaskRecurringInfoAsync(GetTaskRecurringInfoRequest request, final ApiCallback<RecurringInfoResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaskRecurringInfoValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RecurringInfoResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTaskTimephasedDataCall(GetTaskTimephasedDataRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks/{taskUid}/timeScaleData".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "type", request.gettype());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "startDate", request.getstartDate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "endDate", request.getendDate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaskTimephasedDataValidateBeforeCall(GetTaskTimephasedDataRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTaskTimephasedData");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling getTaskTimephasedData");
        }
        Call call = this.getTaskTimephasedDataCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TimephasedDataResponse getTaskTimephasedData(GetTaskTimephasedDataRequest request) throws ApiException {
        try {
            ApiResponse<TimephasedDataResponse> resp = this.getTaskTimephasedDataWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TimephasedDataResponse> resp = this.getTaskTimephasedDataWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TimephasedDataResponse> getTaskTimephasedDataWithHttpInfo(GetTaskTimephasedDataRequest request) throws ApiException {
        Call call = this.getTaskTimephasedDataValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TimephasedDataResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaskTimephasedDataAsync(GetTaskTimephasedDataRequest request, final ApiCallback<TimephasedDataResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaskTimephasedDataValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TimephasedDataResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTasksCall(GetTasksRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTasksValidateBeforeCall(GetTasksRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTasks");
        }
        Call call = this.getTasksCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskItemsResponse getTasks(GetTasksRequest request) throws ApiException {
        try {
            ApiResponse<TaskItemsResponse> resp = this.getTasksWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskItemsResponse> resp = this.getTasksWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskItemsResponse> getTasksWithHttpInfo(GetTasksRequest request) throws ApiException {
        Call call = this.getTasksValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTasksAsync(GetTasksRequest request, final ApiCallback<TaskItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTasksValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postTaskCall(PostTaskRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "taskName", request.gettaskName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "beforeTaskId", request.getbeforeTaskId());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postTaskValidateBeforeCall(PostTaskRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postTask");
        }
        Call call = this.postTaskCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskItemResponse postTask(PostTaskRequest request) throws ApiException {
        try {
            ApiResponse<TaskItemResponse> resp = this.postTaskWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskItemResponse> resp = this.postTaskWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskItemResponse> postTaskWithHttpInfo(PostTaskRequest request) throws ApiException {
        Call call = this.postTaskValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postTaskAsync(PostTaskRequest request, final ApiCallback<TaskItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postTaskValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postTaskRecurringInfoCall(PostTaskRecurringInfoRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RecurringInfo localVarPostBody = request.getrecurringInfo();
        String localVarPath = "/tasks/{name}/tasks/recurringInfo".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "parentTaskUid", request.getparentTaskUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "taskName", request.gettaskName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "calendarName", request.getcalendarName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postTaskRecurringInfoValidateBeforeCall(PostTaskRecurringInfoRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postTaskRecurringInfo");
        }
        if (request.getparentTaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'parentTaskUid' when calling postTaskRecurringInfo");
        }
        if (request.gettaskName() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskName' when calling postTaskRecurringInfo");
        }
        if (request.getrecurringInfo() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'recurringInfo' when calling postTaskRecurringInfo");
        }
        if (request.getcalendarName() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'calendarName' when calling postTaskRecurringInfo");
        }
        Call call = this.postTaskRecurringInfoCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskItemResponse postTaskRecurringInfo(PostTaskRecurringInfoRequest request) throws ApiException {
        try {
            ApiResponse<TaskItemResponse> resp = this.postTaskRecurringInfoWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskItemResponse> resp = this.postTaskRecurringInfoWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskItemResponse> postTaskRecurringInfoWithHttpInfo(PostTaskRecurringInfoRequest request) throws ApiException {
        Call call = this.postTaskRecurringInfoValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postTaskRecurringInfoAsync(PostTaskRecurringInfoRequest request, final ApiCallback<TaskItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postTaskRecurringInfoValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postTasksCall(PostTasksRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<TaskCreationRequest> localVarPostBody = request.getrequests();
        String localVarPath = "/tasks/{name}/tasks/batch".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postTasksValidateBeforeCall(PostTasksRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postTasks");
        }
        if (request.getrequests() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'requests' when calling postTasks");
        }
        Call call = this.postTasksCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskItemsResponse postTasks(PostTasksRequest request) throws ApiException {
        try {
            ApiResponse<TaskItemsResponse> resp = this.postTasksWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskItemsResponse> resp = this.postTasksWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskItemsResponse> postTasksWithHttpInfo(PostTasksRequest request) throws ApiException {
        Call call = this.postTasksValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postTasksAsync(PostTasksRequest request, final ApiCallback<TaskItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postTasksValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putMoveTaskCall(PutMoveTaskRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks/{taskUid}/move".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "parentTaskUid", request.getparentTaskUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putMoveTaskValidateBeforeCall(PutMoveTaskRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putMoveTask");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling putMoveTask");
        }
        if (request.getparentTaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'parentTaskUid' when calling putMoveTask");
        }
        Call call = this.putMoveTaskCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putMoveTask(PutMoveTaskRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putMoveTaskWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putMoveTaskWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putMoveTaskWithHttpInfo(PutMoveTaskRequest request) throws ApiException {
        Call call = this.putMoveTaskValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putMoveTaskAsync(PutMoveTaskRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putMoveTaskValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putMoveTaskToSiblingCall(PutMoveTaskToSiblingRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/tasks/{taskUid}/moveToSibling".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "beforeTaskUid", request.getbeforeTaskUid());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putMoveTaskToSiblingValidateBeforeCall(PutMoveTaskToSiblingRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putMoveTaskToSibling");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling putMoveTaskToSibling");
        }
        if (request.getbeforeTaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'beforeTaskUid' when calling putMoveTaskToSibling");
        }
        Call call = this.putMoveTaskToSiblingCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putMoveTaskToSibling(PutMoveTaskToSiblingRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putMoveTaskToSiblingWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putMoveTaskToSiblingWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putMoveTaskToSiblingWithHttpInfo(PutMoveTaskToSiblingRequest request) throws ApiException {
        Call call = this.putMoveTaskToSiblingValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putMoveTaskToSiblingAsync(PutMoveTaskToSiblingRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putMoveTaskToSiblingValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putTaskCall(PutTaskRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Task localVarPostBody = request.gettask();
        String localVarPath = "/tasks/{name}/tasks/{taskUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "mode", request.getmode());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "recalculate", request.getrecalculate());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putTaskValidateBeforeCall(PutTaskRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putTask");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling putTask");
        }
        if (request.gettask() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'task' when calling putTask");
        }
        Call call = this.putTaskCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskResponse putTask(PutTaskRequest request) throws ApiException {
        try {
            ApiResponse<TaskResponse> resp = this.putTaskWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskResponse> resp = this.putTaskWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskResponse> putTaskWithHttpInfo(PutTaskRequest request) throws ApiException {
        Call call = this.putTaskValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putTaskAsync(PutTaskRequest request, final ApiCallback<TaskResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putTaskValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putTaskRecurringInfoCall(PutTaskRecurringInfoRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RecurringInfo localVarPostBody = request.getrecurringInfo();
        String localVarPath = "/tasks/{name}/tasks/{taskUid}/recurringInfo".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{taskUid\\}", this.apiClient.escapeString(request.gettaskUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putTaskRecurringInfoValidateBeforeCall(PutTaskRecurringInfoRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putTaskRecurringInfo");
        }
        if (request.gettaskUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUid' when calling putTaskRecurringInfo");
        }
        if (request.getrecurringInfo() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'recurringInfo' when calling putTaskRecurringInfo");
        }
        Call call = this.putTaskRecurringInfoCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putTaskRecurringInfo(PutTaskRecurringInfoRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putTaskRecurringInfoWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putTaskRecurringInfoWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putTaskRecurringInfoWithHttpInfo(PutTaskRecurringInfoRequest request) throws ApiException {
        Call call = this.putTaskRecurringInfoValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putTaskRecurringInfoAsync(PutTaskRecurringInfoRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putTaskRecurringInfoValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteTaskLinkCall(DeleteTaskLinkRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/taskLinks/{index}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(request.getindex().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTaskLinkValidateBeforeCall(DeleteTaskLinkRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteTaskLink");
        }
        if (request.getindex() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'index' when calling deleteTaskLink");
        }
        Call call = this.deleteTaskLinkCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteTaskLink(DeleteTaskLinkRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteTaskLinkWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteTaskLinkWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteTaskLinkWithHttpInfo(DeleteTaskLinkRequest request) throws ApiException {
        Call call = this.deleteTaskLinkValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteTaskLinkAsync(DeleteTaskLinkRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTaskLinkValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTaskLinksCall(GetTaskLinksRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/taskLinks".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaskLinksValidateBeforeCall(GetTaskLinksRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTaskLinks");
        }
        Call call = this.getTaskLinksCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskLinksResponse getTaskLinks(GetTaskLinksRequest request) throws ApiException {
        try {
            ApiResponse<TaskLinksResponse> resp = this.getTaskLinksWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskLinksResponse> resp = this.getTaskLinksWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskLinksResponse> getTaskLinksWithHttpInfo(GetTaskLinksRequest request) throws ApiException {
        Call call = this.getTaskLinksValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskLinksResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaskLinksAsync(GetTaskLinksRequest request, final ApiCallback<TaskLinksResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaskLinksValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskLinksResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call postTaskLinkCall(PostTaskLinkRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaskLink localVarPostBody = request.gettaskLink();
        String localVarPath = "/tasks/{name}/taskLinks".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postTaskLinkValidateBeforeCall(PostTaskLinkRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling postTaskLink");
        }
        if (request.gettaskLink() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskLink' when calling postTaskLink");
        }
        Call call = this.postTaskLinkCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse postTaskLink(PostTaskLinkRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.postTaskLinkWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.postTaskLinkWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> postTaskLinkWithHttpInfo(PostTaskLinkRequest request) throws ApiException {
        Call call = this.postTaskLinkValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postTaskLinkAsync(PostTaskLinkRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postTaskLinkValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putTaskLinkCall(PutTaskLinkRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaskLink localVarPostBody = request.gettaskLink();
        String localVarPath = "/tasks/{name}/taskLinks/{index}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(request.getindex().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putTaskLinkValidateBeforeCall(PutTaskLinkRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putTaskLink");
        }
        if (request.getindex() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'index' when calling putTaskLink");
        }
        if (request.gettaskLink() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskLink' when calling putTaskLink");
        }
        Call call = this.putTaskLinkCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TaskLinkResponse putTaskLink(PutTaskLinkRequest request) throws ApiException {
        try {
            ApiResponse<TaskLinkResponse> resp = this.putTaskLinkWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TaskLinkResponse> resp = this.putTaskLinkWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TaskLinkResponse> putTaskLinkWithHttpInfo(PutTaskLinkRequest request) throws ApiException {
        Call call = this.putTaskLinkValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TaskLinkResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putTaskLinkAsync(PutTaskLinkRequest request, final ApiCallback<TaskLinkResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putTaskLinkValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskLinkResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getVbaProjectCall(GetVbaProjectRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/vbaproject".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getVbaProjectValidateBeforeCall(GetVbaProjectRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getVbaProject");
        }
        Call call = this.getVbaProjectCall(request, progressListener, progressRequestListener);
        return call;
    }

    public VbaProjectResponse getVbaProject(GetVbaProjectRequest request) throws ApiException {
        try {
            ApiResponse<VbaProjectResponse> resp = this.getVbaProjectWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<VbaProjectResponse> resp = this.getVbaProjectWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<VbaProjectResponse> getVbaProjectWithHttpInfo(GetVbaProjectRequest request) throws ApiException {
        Call call = this.getVbaProjectValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<VbaProjectResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getVbaProjectAsync(GetVbaProjectRequest request, final ApiCallback<VbaProjectResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getVbaProjectValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<VbaProjectResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call createTableTextStyleCall(CreateTableTextStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TableTextStyle localVarPostBody = request.gettableTextStyle();
        String localVarPath = "/tasks/{name}/views/{viewUid}/tabletextstyles".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{viewUid\\}", this.apiClient.escapeString(request.getviewUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createTableTextStyleValidateBeforeCall(CreateTableTextStyleRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling createTableTextStyle");
        }
        if (request.getviewUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'viewUid' when calling createTableTextStyle");
        }
        if (request.gettableTextStyle() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'tableTextStyle' when calling createTableTextStyle");
        }
        Call call = this.createTableTextStyleCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse createTableTextStyle(CreateTableTextStyleRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.createTableTextStyleWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.createTableTextStyleWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> createTableTextStyleWithHttpInfo(CreateTableTextStyleRequest request) throws ApiException {
        Call call = this.createTableTextStyleValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createTableTextStyleAsync(CreateTableTextStyleRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTableTextStyleValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteTableTextStyleCall(DeleteTableTextStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/views/{viewUid}/tabletextstyles/{rowUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{viewUid\\}", this.apiClient.escapeString(request.getviewUid().toString())).replaceAll("\\{rowUid\\}", this.apiClient.escapeString(request.getrowUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "field", request.getfield());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTableTextStyleValidateBeforeCall(DeleteTableTextStyleRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling deleteTableTextStyle");
        }
        if (request.getviewUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'viewUid' when calling deleteTableTextStyle");
        }
        if (request.getrowUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'rowUid' when calling deleteTableTextStyle");
        }
        Call call = this.deleteTableTextStyleCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse deleteTableTextStyle(DeleteTableTextStyleRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.deleteTableTextStyleWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.deleteTableTextStyleWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> deleteTableTextStyleWithHttpInfo(DeleteTableTextStyleRequest request) throws ApiException {
        Call call = this.deleteTableTextStyleValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteTableTextStyleAsync(DeleteTableTextStyleRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTableTextStyleValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAllTableTextStylesCall(GetAllTableTextStylesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/views/{viewUid}/tabletextstyles".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{viewUid\\}", this.apiClient.escapeString(request.getviewUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllTableTextStylesValidateBeforeCall(GetAllTableTextStylesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getAllTableTextStyles");
        }
        if (request.getviewUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'viewUid' when calling getAllTableTextStyles");
        }
        Call call = this.getAllTableTextStylesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TableTextStylesResponse getAllTableTextStyles(GetAllTableTextStylesRequest request) throws ApiException {
        try {
            ApiResponse<TableTextStylesResponse> resp = this.getAllTableTextStylesWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TableTextStylesResponse> resp = this.getAllTableTextStylesWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TableTextStylesResponse> getAllTableTextStylesWithHttpInfo(GetAllTableTextStylesRequest request) throws ApiException {
        Call call = this.getAllTableTextStylesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TableTextStylesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllTableTextStylesAsync(GetAllTableTextStylesRequest request, final ApiCallback<TableTextStylesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllTableTextStylesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TableTextStylesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTableTextStyleCall(GetTableTextStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/views/{viewUid}/tabletextstyles/{rowUid}".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{viewUid\\}", this.apiClient.escapeString(request.getviewUid().toString())).replaceAll("\\{rowUid\\}", this.apiClient.escapeString(request.getrowUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "field", request.getfield());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTableTextStyleValidateBeforeCall(GetTableTextStyleRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getTableTextStyle");
        }
        if (request.getviewUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'viewUid' when calling getTableTextStyle");
        }
        if (request.getrowUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'rowUid' when calling getTableTextStyle");
        }
        Call call = this.getTableTextStyleCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TableTextStyleResponse getTableTextStyle(GetTableTextStyleRequest request) throws ApiException {
        try {
            ApiResponse<TableTextStyleResponse> resp = this.getTableTextStyleWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<TableTextStyleResponse> resp = this.getTableTextStyleWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<TableTextStyleResponse> getTableTextStyleWithHttpInfo(GetTableTextStyleRequest request) throws ApiException {
        Call call = this.getTableTextStyleValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TableTextStyleResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTableTextStyleAsync(GetTableTextStyleRequest request, final ApiCallback<TableTextStyleResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTableTextStyleValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TableTextStyleResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getViewsCall(GetViewsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/views".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getViewsValidateBeforeCall(GetViewsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getViews");
        }
        Call call = this.getViewsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ViewsResponse getViews(GetViewsRequest request) throws ApiException {
        try {
            ApiResponse<ViewsResponse> resp = this.getViewsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<ViewsResponse> resp = this.getViewsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<ViewsResponse> getViewsWithHttpInfo(GetViewsRequest request) throws ApiException {
        Call call = this.getViewsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ViewsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getViewsAsync(GetViewsRequest request, final ApiCallback<ViewsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getViewsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ViewsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateTableTextStyleCall(UpdateTableTextStyleRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TableTextStyle localVarPostBody = request.gettableTextStyle();
        String localVarPath = "/tasks/{name}/views/{viewUid}/tabletextstyles".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString())).replaceAll("\\{viewUid\\}", this.apiClient.escapeString(request.getviewUid().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTableTextStyleValidateBeforeCall(UpdateTableTextStyleRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling updateTableTextStyle");
        }
        if (request.getviewUid() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'viewUid' when calling updateTableTextStyle");
        }
        if (request.gettableTextStyle() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'tableTextStyle' when calling updateTableTextStyle");
        }
        Call call = this.updateTableTextStyleCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse updateTableTextStyle(UpdateTableTextStyleRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.updateTableTextStyleWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.updateTableTextStyleWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> updateTableTextStyleWithHttpInfo(UpdateTableTextStyleRequest request) throws ApiException {
        Call call = this.updateTableTextStyleValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTableTextStyleAsync(UpdateTableTextStyleRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTableTextStyleValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getWbsDefinitionCall(GetWbsDefinitionRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tasks/{name}/wbsDefinition".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"multipart/form-data"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWbsDefinitionValidateBeforeCall(GetWbsDefinitionRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling getWbsDefinition");
        }
        Call call = this.getWbsDefinitionCall(request, progressListener, progressRequestListener);
        return call;
    }

    public WBSDefinitionResponse getWbsDefinition(GetWbsDefinitionRequest request) throws ApiException {
        try {
            ApiResponse<WBSDefinitionResponse> resp = this.getWbsDefinitionWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<WBSDefinitionResponse> resp = this.getWbsDefinitionWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<WBSDefinitionResponse> getWbsDefinitionWithHttpInfo(GetWbsDefinitionRequest request) throws ApiException {
        Call call = this.getWbsDefinitionValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<WBSDefinitionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWbsDefinitionAsync(GetWbsDefinitionRequest request, final ApiCallback<WBSDefinitionResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWbsDefinitionValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WBSDefinitionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putRenumberWbsCodeCall(PutRenumberWbsCodeRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<Integer> localVarPostBody = request.gettaskUids();
        String localVarPath = "/tasks/{name}/renumberWbsCode".replaceAll("\\{name\\}", this.apiClient.escapeString(request.getname().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storage", request.getstorage());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "fileName", request.getfileName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "folder", request.getfolder());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"multipart/form-data"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putRenumberWbsCodeValidateBeforeCall(PutRenumberWbsCodeRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getname() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'name' when calling putRenumberWbsCode");
        }
        if (request.gettaskUids() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'taskUids' when calling putRenumberWbsCode");
        }
        Call call = this.putRenumberWbsCodeCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AsposeResponse putRenumberWbsCode(PutRenumberWbsCodeRequest request) throws ApiException {
        try {
            ApiResponse<AsposeResponse> resp = this.putRenumberWbsCodeWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = this.putRenumberWbsCodeWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<AsposeResponse> putRenumberWbsCodeWithHttpInfo(PutRenumberWbsCodeRequest request) throws ApiException {
        Call call = this.putRenumberWbsCodeValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putRenumberWbsCodeAsync(PutRenumberWbsCodeRequest request, final ApiCallback<AsposeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putRenumberWbsCodeValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private String addParameterToQuery(List<Pair> queryParams, String path, String paramName, Object paramValue) {
        if (path.contains("{" + paramName + "}")) {
            if (paramValue == null || paramValue.equals("")) {
                return path.replace("{" + paramName + "}", "");
            }
            return path.replace("{" + paramName + "}", paramValue.toString());
        }
        queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        return path;
    }
}

