/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.BaselineType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Represents baseline values of a resource or a task.")
public class Baseline {
    @SerializedName(value="BaselineNumber")
    private BaselineType baselineNumber = null;
    @SerializedName(value="Work")
    private String work = null;
    @SerializedName(value="Cost")
    private BigDecimal cost = null;
    @SerializedName(value="Bcws")
    private Double bcws = null;
    @SerializedName(value="Bcwp")
    private Double bcwp = null;

    public Baseline baselineNumber(BaselineType baselineNumber) {
        this.baselineNumber = baselineNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique number of a baseline data record.")
    public BaselineType getBaselineNumber() {
        return this.baselineNumber;
    }

    public void setBaselineNumber(BaselineType baselineNumber) {
        this.baselineNumber = baselineNumber;
    }

    public Baseline work(String work) {
        this.work = work;
        return this;
    }

    @ApiModelProperty(required=true, value="The work assigned to a resource when the baseline is saved.")
    public String getWork() {
        return this.work;
    }

    public void setWork(String work) {
        this.work = work;
    }

    public Baseline cost(BigDecimal cost) {
        this.cost = cost;
        return this;
    }

    @ApiModelProperty(required=true, value="The projected cost of a resource when the baseline is saved.")
    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public Baseline bcws(Double bcws) {
        this.bcws = bcws;
        return this;
    }

    @ApiModelProperty(required=true, value="The budget cost of a work scheduled for a resource.")
    public Double getBcws() {
        return this.bcws;
    }

    public void setBcws(Double bcws) {
        this.bcws = bcws;
    }

    public Baseline bcwp(Double bcwp) {
        this.bcwp = bcwp;
        return this;
    }

    @ApiModelProperty(required=true, value="The budgeted cost of a work performed by a resource for a project to-date.")
    public Double getBcwp() {
        return this.bcwp;
    }

    public void setBcwp(Double bcwp) {
        this.bcwp = bcwp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Baseline baseline = (Baseline)o;
        return Objects.equals((Object)this.baselineNumber, (Object)baseline.baselineNumber) && Objects.equals(this.work, baseline.work) && Objects.equals(this.cost, baseline.cost) && Objects.equals(this.bcws, baseline.bcws) && Objects.equals(this.bcwp, baseline.bcwp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baselineNumber, this.work, this.cost, this.bcws, this.bcwp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Baseline {\n");
        sb.append("    baselineNumber: ").append(this.toIndentedString((Object)this.baselineNumber)).append("\n");
        sb.append("    work: ").append(this.toIndentedString(this.work)).append("\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    bcws: ").append(this.toIndentedString(this.bcws)).append("\n");
        sb.append("    bcwp: ").append(this.toIndentedString(this.bcwp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

