/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.CalendarExceptionType;
import com.aspose.tasks.cloud.model.DayType;
import com.aspose.tasks.cloud.model.Month;
import com.aspose.tasks.cloud.model.MonthItemType;
import com.aspose.tasks.cloud.model.MonthPosition;
import com.aspose.tasks.cloud.model.WorkingTime;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represent exceptional time periods in a calendar.")
public class CalendarException {
    @SerializedName(value="Index")
    private Integer index = null;
    @SerializedName(value="EnteredByOccurrences")
    private Boolean enteredByOccurrences = null;
    @SerializedName(value="FromDate")
    private OffsetDateTime fromDate = null;
    @SerializedName(value="ToDate")
    private OffsetDateTime toDate = null;
    @SerializedName(value="Occurrences")
    private Integer occurrences = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="Type")
    private CalendarExceptionType type = null;
    @SerializedName(value="Period")
    private Integer period = null;
    @SerializedName(value="DaysOfWeek")
    private List<DayType> daysOfWeek = null;
    @SerializedName(value="MonthItem")
    private MonthItemType monthItem = null;
    @SerializedName(value="MonthPosition")
    private MonthPosition monthPosition = null;
    @SerializedName(value="Month")
    private Month month = null;
    @SerializedName(value="MonthDay")
    private Integer monthDay = null;
    @SerializedName(value="DayWorking")
    private Boolean dayWorking = null;
    @SerializedName(value="WorkingTimes")
    private List<WorkingTime> workingTimes = null;

    public CalendarException index(Integer index) {
        this.index = index;
        return this;
    }

    @ApiModelProperty(required=true, value="Index of the current item in the collection of calendar's exceptions.")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public CalendarException enteredByOccurrences(Boolean enteredByOccurrences) {
        this.enteredByOccurrences = enteredByOccurrences;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the range of recurrence is defined by entering a number of occurrences. False specifies that the range of recurrence is defined by entering a finish date.")
    public Boolean isEnteredByOccurrences() {
        return this.enteredByOccurrences;
    }

    public void setEnteredByOccurrences(Boolean enteredByOccurrences) {
        this.enteredByOccurrences = enteredByOccurrences;
    }

    public CalendarException fromDate(OffsetDateTime fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The beginning of the exception time.")
    public OffsetDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(OffsetDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public CalendarException toDate(OffsetDateTime toDate) {
        this.toDate = toDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The end of the exception time.")
    public OffsetDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(OffsetDateTime toDate) {
        this.toDate = toDate;
    }

    public CalendarException occurrences(Integer occurrences) {
        this.occurrences = occurrences;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of occurrences for which the calendar exception is valid.")
    public Integer getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(Integer occurrences) {
        this.occurrences = occurrences;
    }

    public CalendarException name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the exception.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CalendarException type(CalendarExceptionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The exception type.")
    public CalendarExceptionType getType() {
        return this.type;
    }

    public void setType(CalendarExceptionType type) {
        this.type = type;
    }

    public CalendarException period(Integer period) {
        this.period = period;
        return this;
    }

    @ApiModelProperty(required=true, value="The period of recurrence for the exception.")
    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public CalendarException daysOfWeek(List<DayType> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    public CalendarException addDaysOfWeekItem(DayType daysOfWeekItem) {
        if (this.daysOfWeek == null) {
            this.daysOfWeek = new ArrayList<DayType>();
        }
        this.daysOfWeek.add(daysOfWeekItem);
        return this;
    }

    @ApiModelProperty(value="The days of the week on which the exception is valid.")
    public List<DayType> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(List<DayType> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public CalendarException monthItem(MonthItemType monthItem) {
        this.monthItem = monthItem;
        return this;
    }

    @ApiModelProperty(required=true, value="The month item for which an exception recurrence is scheduled.")
    public MonthItemType getMonthItem() {
        return this.monthItem;
    }

    public void setMonthItem(MonthItemType monthItem) {
        this.monthItem = monthItem;
    }

    public CalendarException monthPosition(MonthPosition monthPosition) {
        this.monthPosition = monthPosition;
        return this;
    }

    @ApiModelProperty(required=true, value="The position of a month item within a month.")
    public MonthPosition getMonthPosition() {
        return this.monthPosition;
    }

    public void setMonthPosition(MonthPosition monthPosition) {
        this.monthPosition = monthPosition;
    }

    public CalendarException month(Month month) {
        this.month = month;
        return this;
    }

    @ApiModelProperty(required=true, value="The month for which an exception recurrence is scheduled.")
    public Month getMonth() {
        return this.month;
    }

    public void setMonth(Month month) {
        this.month = month;
    }

    public CalendarException monthDay(Integer monthDay) {
        this.monthDay = monthDay;
        return this;
    }

    @ApiModelProperty(required=true, value="The day of a month on which an exception recurrence is scheduled.")
    public Integer getMonthDay() {
        return this.monthDay;
    }

    public void setMonthDay(Integer monthDay) {
        this.monthDay = monthDay;
    }

    public CalendarException dayWorking(Boolean dayWorking) {
        this.dayWorking = dayWorking;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the specified date or day type is working.")
    public Boolean isDayWorking() {
        return this.dayWorking;
    }

    public void setDayWorking(Boolean dayWorking) {
        this.dayWorking = dayWorking;
    }

    public CalendarException workingTimes(List<WorkingTime> workingTimes) {
        this.workingTimes = workingTimes;
        return this;
    }

    public CalendarException addWorkingTimesItem(WorkingTime workingTimesItem) {
        if (this.workingTimes == null) {
            this.workingTimes = new ArrayList<WorkingTime>();
        }
        this.workingTimes.add(workingTimesItem);
        return this;
    }

    @ApiModelProperty(value="The collection of working times that defines the time worked on the weekday.  At least one working time must present, and there can't be more than five.")
    public List<WorkingTime> getWorkingTimes() {
        return this.workingTimes;
    }

    public void setWorkingTimes(List<WorkingTime> workingTimes) {
        this.workingTimes = workingTimes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarException calendarException = (CalendarException)o;
        return Objects.equals(this.index, calendarException.index) && Objects.equals(this.enteredByOccurrences, calendarException.enteredByOccurrences) && Objects.equals(this.fromDate, calendarException.fromDate) && Objects.equals(this.toDate, calendarException.toDate) && Objects.equals(this.occurrences, calendarException.occurrences) && Objects.equals(this.name, calendarException.name) && Objects.equals((Object)this.type, (Object)calendarException.type) && Objects.equals(this.period, calendarException.period) && Objects.equals(this.daysOfWeek, calendarException.daysOfWeek) && Objects.equals((Object)this.monthItem, (Object)calendarException.monthItem) && Objects.equals((Object)this.monthPosition, (Object)calendarException.monthPosition) && Objects.equals((Object)this.month, (Object)calendarException.month) && Objects.equals(this.monthDay, calendarException.monthDay) && Objects.equals(this.dayWorking, calendarException.dayWorking) && Objects.equals(this.workingTimes, calendarException.workingTimes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.enteredByOccurrences, this.fromDate, this.toDate, this.occurrences, this.name, this.type, this.period, this.daysOfWeek, this.monthItem, this.monthPosition, this.month, this.monthDay, this.dayWorking, this.workingTimes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CalendarException {\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    enteredByOccurrences: ").append(this.toIndentedString(this.enteredByOccurrences)).append("\n");
        sb.append("    fromDate: ").append(this.toIndentedString(this.fromDate)).append("\n");
        sb.append("    toDate: ").append(this.toIndentedString(this.toDate)).append("\n");
        sb.append("    occurrences: ").append(this.toIndentedString(this.occurrences)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    monthItem: ").append(this.toIndentedString((Object)this.monthItem)).append("\n");
        sb.append("    monthPosition: ").append(this.toIndentedString((Object)this.monthPosition)).append("\n");
        sb.append("    month: ").append(this.toIndentedString((Object)this.month)).append("\n");
        sb.append("    monthDay: ").append(this.toIndentedString(this.monthDay)).append("\n");
        sb.append("    dayWorking: ").append(this.toIndentedString(this.dayWorking)).append("\n");
        sb.append("    workingTimes: ").append(this.toIndentedString(this.workingTimes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

