/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.CustomFieldType;
import com.aspose.tasks.cloud.model.Duration;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents extended attribute.")
public class ExtendedAttribute {
    @SerializedName(value="FieldId")
    private String fieldId = null;
    @SerializedName(value="AttributeType")
    private CustomFieldType attributeType = null;
    @SerializedName(value="ValueGuid")
    private String valueGuid = null;
    @SerializedName(value="LookupValueId")
    private Integer lookupValueId = null;
    @SerializedName(value="DurationValue")
    private Duration durationValue = null;
    @SerializedName(value="NumericValue")
    private BigDecimal numericValue = null;
    @SerializedName(value="DateValue")
    private OffsetDateTime dateValue = null;
    @SerializedName(value="FlagValue")
    private Boolean flagValue = null;
    @SerializedName(value="TextValue")
    private String textValue = null;
    @SerializedName(value="IsErrorValue")
    private Boolean isErrorValue = null;

    public ExtendedAttribute fieldId(String fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the id of a field.")
    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public ExtendedAttribute attributeType(CustomFieldType attributeType) {
        this.attributeType = attributeType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the type of a custom field.")
    public CustomFieldType getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(CustomFieldType attributeType) {
        this.attributeType = attributeType;
    }

    public ExtendedAttribute valueGuid(String valueGuid) {
        this.valueGuid = valueGuid;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the guid of a value.")
    public String getValueGuid() {
        return this.valueGuid;
    }

    public void setValueGuid(String valueGuid) {
        this.valueGuid = valueGuid;
    }

    public ExtendedAttribute lookupValueId(Integer lookupValueId) {
        this.lookupValueId = lookupValueId;
        return this;
    }

    @ApiModelProperty(value="Gets or sets Id of the lookup value (if value is lookup value)")
    public Integer getLookupValueId() {
        return this.lookupValueId;
    }

    public void setLookupValueId(Integer lookupValueId) {
        this.lookupValueId = lookupValueId;
    }

    public ExtendedAttribute durationValue(Duration durationValue) {
        this.durationValue = durationValue;
        return this;
    }

    @ApiModelProperty(value="Gets or sets value for attributes with 'Duration' type.")
    public Duration getDurationValue() {
        return this.durationValue;
    }

    public void setDurationValue(Duration durationValue) {
        this.durationValue = durationValue;
    }

    public ExtendedAttribute numericValue(BigDecimal numericValue) {
        this.numericValue = numericValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a value for attributes with numeric types (Cost, Number).")
    public BigDecimal getNumericValue() {
        return this.numericValue;
    }

    public void setNumericValue(BigDecimal numericValue) {
        this.numericValue = numericValue;
    }

    public ExtendedAttribute dateValue(OffsetDateTime dateValue) {
        this.dateValue = dateValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a value for attributes with date types (Date, Start, Finish).")
    public OffsetDateTime getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(OffsetDateTime dateValue) {
        this.dateValue = dateValue;
    }

    public ExtendedAttribute flagValue(Boolean flagValue) {
        this.flagValue = flagValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a value indicating whether a flag is set for an attribute with 'Flag' type.")
    public Boolean isFlagValue() {
        return this.flagValue;
    }

    public void setFlagValue(Boolean flagValue) {
        this.flagValue = flagValue;
    }

    public ExtendedAttribute textValue(String textValue) {
        this.textValue = textValue;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a value for attributes with 'Text' type.")
    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public ExtendedAttribute isErrorValue(Boolean isErrorValue) {
        this.isErrorValue = isErrorValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets whether calculation of extended attribute's value resulted in an error.             ")
    public Boolean isIsErrorValue() {
        return this.isErrorValue;
    }

    public void setIsErrorValue(Boolean isErrorValue) {
        this.isErrorValue = isErrorValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedAttribute extendedAttribute = (ExtendedAttribute)o;
        return Objects.equals(this.fieldId, extendedAttribute.fieldId) && Objects.equals((Object)this.attributeType, (Object)extendedAttribute.attributeType) && Objects.equals(this.valueGuid, extendedAttribute.valueGuid) && Objects.equals(this.lookupValueId, extendedAttribute.lookupValueId) && Objects.equals(this.durationValue, extendedAttribute.durationValue) && Objects.equals(this.numericValue, extendedAttribute.numericValue) && Objects.equals(this.dateValue, extendedAttribute.dateValue) && Objects.equals(this.flagValue, extendedAttribute.flagValue) && Objects.equals(this.textValue, extendedAttribute.textValue) && Objects.equals(this.isErrorValue, extendedAttribute.isErrorValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldId, this.attributeType, this.valueGuid, this.lookupValueId, this.durationValue, this.numericValue, this.dateValue, this.flagValue, this.textValue, this.isErrorValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtendedAttribute {\n");
        sb.append("    fieldId: ").append(this.toIndentedString(this.fieldId)).append("\n");
        sb.append("    attributeType: ").append(this.toIndentedString((Object)this.attributeType)).append("\n");
        sb.append("    valueGuid: ").append(this.toIndentedString(this.valueGuid)).append("\n");
        sb.append("    lookupValueId: ").append(this.toIndentedString(this.lookupValueId)).append("\n");
        sb.append("    durationValue: ").append(this.toIndentedString(this.durationValue)).append("\n");
        sb.append("    numericValue: ").append(this.toIndentedString(this.numericValue)).append("\n");
        sb.append("    dateValue: ").append(this.toIndentedString(this.dateValue)).append("\n");
        sb.append("    flagValue: ").append(this.toIndentedString(this.flagValue)).append("\n");
        sb.append("    textValue: ").append(this.toIndentedString(this.textValue)).append("\n");
        sb.append("    isErrorValue: ").append(this.toIndentedString(this.isErrorValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

