/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.LevelingOrder;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class LevelingOptions {
    @SerializedName(value="StartDate")
    private OffsetDateTime startDate = null;
    @SerializedName(value="FinishDate")
    private OffsetDateTime finishDate = null;
    @SerializedName(value="ResourceUids")
    private List<Integer> resourceUids = null;
    @SerializedName(value="LevelingOrder")
    private LevelingOrder levelingOrder = null;

    public LevelingOptions startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="Leveling period start date. The default value is the project`s start date.")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public LevelingOptions finishDate(OffsetDateTime finishDate) {
        this.finishDate = finishDate;
        return this;
    }

    @ApiModelProperty(value="Leveling period end date. The default value is the project`s finish date.")
    public OffsetDateTime getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(OffsetDateTime finishDate) {
        this.finishDate = finishDate;
    }

    public LevelingOptions resourceUids(List<Integer> resourceUids) {
        this.resourceUids = resourceUids;
        return this;
    }

    public LevelingOptions addResourceUidsItem(Integer resourceUidsItem) {
        if (this.resourceUids == null) {
            this.resourceUids = new ArrayList<Integer>();
        }
        this.resourceUids.add(resourceUidsItem);
        return this;
    }

    @ApiModelProperty(value="The list of the resource uids which will be leveled. If null is set,  all project resources will be leveled.")
    public List<Integer> getResourceUids() {
        return this.resourceUids;
    }

    public void setResourceUids(List<Integer> resourceUids) {
        this.resourceUids = resourceUids;
    }

    public LevelingOptions levelingOrder(LevelingOrder levelingOrder) {
        this.levelingOrder = levelingOrder;
        return this;
    }

    @ApiModelProperty(required=true, value="The order in which the leveling algorithm delays tasks that have overallocations. After determination of tasks causing the overallocation and which tasks can be delayed, the specified order is used which task should be delayed first.")
    public LevelingOrder getLevelingOrder() {
        return this.levelingOrder;
    }

    public void setLevelingOrder(LevelingOrder levelingOrder) {
        this.levelingOrder = levelingOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LevelingOptions levelingOptions = (LevelingOptions)o;
        return Objects.equals(this.startDate, levelingOptions.startDate) && Objects.equals(this.finishDate, levelingOptions.finishDate) && Objects.equals(this.resourceUids, levelingOptions.resourceUids) && Objects.equals((Object)this.levelingOrder, (Object)levelingOptions.levelingOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startDate, this.finishDate, this.resourceUids, this.levelingOrder});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LevelingOptions {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    finishDate: ").append(this.toIndentedString(this.finishDate)).append("\n");
        sb.append("    resourceUids: ").append(this.toIndentedString(this.resourceUids)).append("\n");
        sb.append("    levelingOrder: ").append(this.toIndentedString((Object)this.levelingOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

