/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.MaskType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents four elements of a mask which defines an outline code format.")
public class OutlineMask {
    @SerializedName(value="Level")
    private Integer level = null;
    @SerializedName(value="Type")
    private MaskType type = null;
    @SerializedName(value="Length")
    private Integer length = null;
    @SerializedName(value="Separator")
    private String separator = null;

    public OutlineMask level(Integer level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(required=true, value="The level of a mask.")
    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public OutlineMask type(MaskType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of a mask.")
    public MaskType getType() {
        return this.type;
    }

    public void setType(MaskType type) {
        this.type = type;
    }

    public OutlineMask length(Integer length) {
        this.length = length;
        return this;
    }

    @ApiModelProperty(required=true, value="The maximum length (in characters) of the outline code values. 0 if length is not defined.")
    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public OutlineMask separator(String separator) {
        this.separator = separator;
        return this;
    }

    @ApiModelProperty(value="The separator of code values.")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlineMask outlineMask = (OutlineMask)o;
        return Objects.equals(this.level, outlineMask.level) && Objects.equals((Object)this.type, (Object)outlineMask.type) && Objects.equals(this.length, outlineMask.length) && Objects.equals(this.separator, outlineMask.separator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.type, this.length, this.separator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutlineMask {\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    separator: ").append(this.toIndentedString(this.separator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

