/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.OutlineValueType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents an outline value.")
public class OutlineValue {
    @SerializedName(value="ValueId")
    private Integer valueId = null;
    @SerializedName(value="FieldGuid")
    private String fieldGuid = null;
    @SerializedName(value="Type")
    private OutlineValueType type = null;
    @SerializedName(value="ParentValueId")
    private Integer parentValueId = null;
    @SerializedName(value="Value")
    private String value = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="IsCollapsed")
    private Boolean isCollapsed = null;

    public OutlineValue valueId(Integer valueId) {
        this.valueId = valueId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique Id of an outline code value within a project.")
    public Integer getValueId() {
        return this.valueId;
    }

    public void setValueId(Integer valueId) {
        this.valueId = valueId;
    }

    public OutlineValue fieldGuid(String fieldGuid) {
        this.fieldGuid = fieldGuid;
        return this;
    }

    @ApiModelProperty(value="The Guid of an outline code value.")
    public String getFieldGuid() {
        return this.fieldGuid;
    }

    public void setFieldGuid(String fieldGuid) {
        this.fieldGuid = fieldGuid;
    }

    public OutlineValue type(OutlineValueType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The outline code type.")
    public OutlineValueType getType() {
        return this.type;
    }

    public void setType(OutlineValueType type) {
        this.type = type;
    }

    public OutlineValue parentValueId(Integer parentValueId) {
        this.parentValueId = parentValueId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Id of a parent node of an outline code.")
    public Integer getParentValueId() {
        return this.parentValueId;
    }

    public void setParentValueId(Integer parentValueId) {
        this.parentValueId = parentValueId;
    }

    public OutlineValue value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The actual value.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public OutlineValue description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of an outline value.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OutlineValue isCollapsed(Boolean isCollapsed) {
        this.isCollapsed = isCollapsed;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether outline value is collapsed or not.")
    public Boolean isIsCollapsed() {
        return this.isCollapsed;
    }

    public void setIsCollapsed(Boolean isCollapsed) {
        this.isCollapsed = isCollapsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlineValue outlineValue = (OutlineValue)o;
        return Objects.equals(this.valueId, outlineValue.valueId) && Objects.equals(this.fieldGuid, outlineValue.fieldGuid) && Objects.equals((Object)this.type, (Object)outlineValue.type) && Objects.equals(this.parentValueId, outlineValue.parentValueId) && Objects.equals(this.value, outlineValue.value) && Objects.equals(this.description, outlineValue.description) && Objects.equals(this.isCollapsed, outlineValue.isCollapsed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.valueId, this.fieldGuid, this.type, this.parentValueId, this.value, this.description, this.isCollapsed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutlineValue {\n");
        sb.append("    valueId: ").append(this.toIndentedString(this.valueId)).append("\n");
        sb.append("    fieldGuid: ").append(this.toIndentedString(this.fieldGuid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    parentValueId: ").append(this.toIndentedString(this.parentValueId)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isCollapsed: ").append(this.toIndentedString(this.isCollapsed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

