/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tasks.cloud.model;

import com.aspose.tasks.cloud.model.PrimaveraActivityType;
import com.aspose.tasks.cloud.model.PrimaveraConstraintType;
import com.aspose.tasks.cloud.model.PrimaveraDurationType;
import com.aspose.tasks.cloud.model.PrimaveraPercentCompleteType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents Primavera-specific properties for a task read from Primavera format (XER of P6XML).")
public class PrimaveraTaskProperties {
    @SerializedName(value="SequenceNumber")
    private Integer sequenceNumber = null;
    @SerializedName(value="ActivityId")
    private String activityId = null;
    @SerializedName(value="RemainingEarlyFinish")
    private OffsetDateTime remainingEarlyFinish = null;
    @SerializedName(value="RemainingEarlyStart")
    private OffsetDateTime remainingEarlyStart = null;
    @SerializedName(value="RemainingLateStart")
    private OffsetDateTime remainingLateStart = null;
    @SerializedName(value="RemainingLateFinish")
    private OffsetDateTime remainingLateFinish = null;
    @SerializedName(value="RawDurationType")
    private String rawDurationType = null;
    @SerializedName(value="RawActivityType")
    private String rawActivityType = null;
    @SerializedName(value="RawCompletePercentType")
    private String rawCompletePercentType = null;
    @SerializedName(value="RawStatus")
    private String rawStatus = null;
    @SerializedName(value="DurationPercentComplete")
    private Double durationPercentComplete = null;
    @SerializedName(value="PhysicalPercentComplete")
    private Double physicalPercentComplete = null;
    @SerializedName(value="ActualNonLaborUnits")
    private Double actualNonLaborUnits = null;
    @SerializedName(value="ActualLaborUnits")
    private Double actualLaborUnits = null;
    @SerializedName(value="UnitsPercentComplete")
    private Double unitsPercentComplete = null;
    @SerializedName(value="RemainingLaborUnits")
    private Double remainingLaborUnits = null;
    @SerializedName(value="RemainingNonLaborUnits")
    private Double remainingNonLaborUnits = null;
    @SerializedName(value="DurationType")
    private PrimaveraDurationType durationType = null;
    @SerializedName(value="ActivityType")
    private PrimaveraActivityType activityType = null;
    @SerializedName(value="PercentCompleteType")
    private PrimaveraPercentCompleteType percentCompleteType = null;
    @SerializedName(value="ActualLaborCost")
    private BigDecimal actualLaborCost = null;
    @SerializedName(value="ActualNonlaborCost")
    private BigDecimal actualNonlaborCost = null;
    @SerializedName(value="ActualMaterialCost")
    private BigDecimal actualMaterialCost = null;
    @SerializedName(value="ActualExpenseCost")
    private BigDecimal actualExpenseCost = null;
    @SerializedName(value="RemainingExpenseCost")
    private BigDecimal remainingExpenseCost = null;
    @SerializedName(value="ActualTotalCost")
    private BigDecimal actualTotalCost = null;
    @SerializedName(value="BudgetedTotalCost")
    private BigDecimal budgetedTotalCost = null;
    @SerializedName(value="BudgetedLaborCost")
    private BigDecimal budgetedLaborCost = null;
    @SerializedName(value="BudgetedNonlaborCost")
    private BigDecimal budgetedNonlaborCost = null;
    @SerializedName(value="BudgetedMaterialCost")
    private BigDecimal budgetedMaterialCost = null;
    @SerializedName(value="BudgetedExpenseCost")
    private BigDecimal budgetedExpenseCost = null;
    @SerializedName(value="PrimaryConstraintType")
    private PrimaveraConstraintType primaryConstraintType = null;
    @SerializedName(value="PrimaryConstraintDate")
    private OffsetDateTime primaryConstraintDate = null;
    @SerializedName(value="SecondaryConstraintType")
    private PrimaveraConstraintType secondaryConstraintType = null;
    @SerializedName(value="SecondaryConstraintDate")
    private OffsetDateTime secondaryConstraintDate = null;

    public PrimaveraTaskProperties sequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The sequence number of the WBS item (summary tasks). It is used to sort summary tasks in Primavera.")
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public PrimaveraTaskProperties activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @ApiModelProperty(value="Activity id field - a task's unique identifier used by Primavera.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public PrimaveraTaskProperties remainingEarlyFinish(OffsetDateTime remainingEarlyFinish) {
        this.remainingEarlyFinish = remainingEarlyFinish;
        return this;
    }

    @ApiModelProperty(required=true, value="Remaining early finish date - the date when the remaining work for the activity is scheduled to be finished.")
    public OffsetDateTime getRemainingEarlyFinish() {
        return this.remainingEarlyFinish;
    }

    public void setRemainingEarlyFinish(OffsetDateTime remainingEarlyFinish) {
        this.remainingEarlyFinish = remainingEarlyFinish;
    }

    public PrimaveraTaskProperties remainingEarlyStart(OffsetDateTime remainingEarlyStart) {
        this.remainingEarlyStart = remainingEarlyStart;
        return this;
    }

    @ApiModelProperty(required=true, value="Remaining early start date - the date when the remaining work for the activity is scheduled to begin.")
    public OffsetDateTime getRemainingEarlyStart() {
        return this.remainingEarlyStart;
    }

    public void setRemainingEarlyStart(OffsetDateTime remainingEarlyStart) {
        this.remainingEarlyStart = remainingEarlyStart;
    }

    public PrimaveraTaskProperties remainingLateStart(OffsetDateTime remainingLateStart) {
        this.remainingLateStart = remainingLateStart;
        return this;
    }

    @ApiModelProperty(required=true, value="Remaining late start date.")
    public OffsetDateTime getRemainingLateStart() {
        return this.remainingLateStart;
    }

    public void setRemainingLateStart(OffsetDateTime remainingLateStart) {
        this.remainingLateStart = remainingLateStart;
    }

    public PrimaveraTaskProperties remainingLateFinish(OffsetDateTime remainingLateFinish) {
        this.remainingLateFinish = remainingLateFinish;
        return this;
    }

    @ApiModelProperty(required=true, value="Remaining late finish date.")
    public OffsetDateTime getRemainingLateFinish() {
        return this.remainingLateFinish;
    }

    public void setRemainingLateFinish(OffsetDateTime remainingLateFinish) {
        this.remainingLateFinish = remainingLateFinish;
    }

    public PrimaveraTaskProperties rawDurationType(String rawDurationType) {
        this.rawDurationType = rawDurationType;
        return this;
    }

    @ApiModelProperty(value="Raw text representation (as in source file) of 'Duration Type' field of the activity.")
    public String getRawDurationType() {
        return this.rawDurationType;
    }

    public void setRawDurationType(String rawDurationType) {
        this.rawDurationType = rawDurationType;
    }

    public PrimaveraTaskProperties rawActivityType(String rawActivityType) {
        this.rawActivityType = rawActivityType;
        return this;
    }

    @ApiModelProperty(value="Raw text representation (as in source file) of 'Activity Type' field of the activity.")
    public String getRawActivityType() {
        return this.rawActivityType;
    }

    public void setRawActivityType(String rawActivityType) {
        this.rawActivityType = rawActivityType;
    }

    public PrimaveraTaskProperties rawCompletePercentType(String rawCompletePercentType) {
        this.rawCompletePercentType = rawCompletePercentType;
        return this;
    }

    @ApiModelProperty(value="Raw text representation (as in source file) of '% Complete Type' field of the activity.")
    public String getRawCompletePercentType() {
        return this.rawCompletePercentType;
    }

    public void setRawCompletePercentType(String rawCompletePercentType) {
        this.rawCompletePercentType = rawCompletePercentType;
    }

    public PrimaveraTaskProperties rawStatus(String rawStatus) {
        this.rawStatus = rawStatus;
        return this;
    }

    @ApiModelProperty(value="Raw text representation (as in source file) of 'Status' field of the activity.")
    public String getRawStatus() {
        return this.rawStatus;
    }

    public void setRawStatus(String rawStatus) {
        this.rawStatus = rawStatus;
    }

    public PrimaveraTaskProperties durationPercentComplete(Double durationPercentComplete) {
        this.durationPercentComplete = durationPercentComplete;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of duration percent complete.")
    public Double getDurationPercentComplete() {
        return this.durationPercentComplete;
    }

    public void setDurationPercentComplete(Double durationPercentComplete) {
        this.durationPercentComplete = durationPercentComplete;
    }

    public PrimaveraTaskProperties physicalPercentComplete(Double physicalPercentComplete) {
        this.physicalPercentComplete = physicalPercentComplete;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of Physical Percent Complete.")
    public Double getPhysicalPercentComplete() {
        return this.physicalPercentComplete;
    }

    public void setPhysicalPercentComplete(Double physicalPercentComplete) {
        this.physicalPercentComplete = physicalPercentComplete;
    }

    public PrimaveraTaskProperties actualNonLaborUnits(Double actualNonLaborUnits) {
        this.actualNonLaborUnits = actualNonLaborUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of actual non labor units.")
    public Double getActualNonLaborUnits() {
        return this.actualNonLaborUnits;
    }

    public void setActualNonLaborUnits(Double actualNonLaborUnits) {
        this.actualNonLaborUnits = actualNonLaborUnits;
    }

    public PrimaveraTaskProperties actualLaborUnits(Double actualLaborUnits) {
        this.actualLaborUnits = actualLaborUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of actual labor units.")
    public Double getActualLaborUnits() {
        return this.actualLaborUnits;
    }

    public void setActualLaborUnits(Double actualLaborUnits) {
        this.actualLaborUnits = actualLaborUnits;
    }

    public PrimaveraTaskProperties unitsPercentComplete(Double unitsPercentComplete) {
        this.unitsPercentComplete = unitsPercentComplete;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of units percent complete.")
    public Double getUnitsPercentComplete() {
        return this.unitsPercentComplete;
    }

    public void setUnitsPercentComplete(Double unitsPercentComplete) {
        this.unitsPercentComplete = unitsPercentComplete;
    }

    public PrimaveraTaskProperties remainingLaborUnits(Double remainingLaborUnits) {
        this.remainingLaborUnits = remainingLaborUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of remaining labor units.")
    public Double getRemainingLaborUnits() {
        return this.remainingLaborUnits;
    }

    public void setRemainingLaborUnits(Double remainingLaborUnits) {
        this.remainingLaborUnits = remainingLaborUnits;
    }

    public PrimaveraTaskProperties remainingNonLaborUnits(Double remainingNonLaborUnits) {
        this.remainingNonLaborUnits = remainingNonLaborUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of remaining non labor units.")
    public Double getRemainingNonLaborUnits() {
        return this.remainingNonLaborUnits;
    }

    public void setRemainingNonLaborUnits(Double remainingNonLaborUnits) {
        this.remainingNonLaborUnits = remainingNonLaborUnits;
    }

    public PrimaveraTaskProperties durationType(PrimaveraDurationType durationType) {
        this.durationType = durationType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of 'Duration Type' field of the activity.")
    public PrimaveraDurationType getDurationType() {
        return this.durationType;
    }

    public void setDurationType(PrimaveraDurationType durationType) {
        this.durationType = durationType;
    }

    public PrimaveraTaskProperties activityType(PrimaveraActivityType activityType) {
        this.activityType = activityType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of 'Activity Type' field.")
    public PrimaveraActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(PrimaveraActivityType activityType) {
        this.activityType = activityType;
    }

    public PrimaveraTaskProperties percentCompleteType(PrimaveraPercentCompleteType percentCompleteType) {
        this.percentCompleteType = percentCompleteType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of '% Complete Type' field of the activity.")
    public PrimaveraPercentCompleteType getPercentCompleteType() {
        return this.percentCompleteType;
    }

    public void setPercentCompleteType(PrimaveraPercentCompleteType percentCompleteType) {
        this.percentCompleteType = percentCompleteType;
    }

    public PrimaveraTaskProperties actualLaborCost(BigDecimal actualLaborCost) {
        this.actualLaborCost = actualLaborCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of actual labor cost.")
    public BigDecimal getActualLaborCost() {
        return this.actualLaborCost;
    }

    public void setActualLaborCost(BigDecimal actualLaborCost) {
        this.actualLaborCost = actualLaborCost;
    }

    public PrimaveraTaskProperties actualNonlaborCost(BigDecimal actualNonlaborCost) {
        this.actualNonlaborCost = actualNonlaborCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of actual non labor cost.")
    public BigDecimal getActualNonlaborCost() {
        return this.actualNonlaborCost;
    }

    public void setActualNonlaborCost(BigDecimal actualNonlaborCost) {
        this.actualNonlaborCost = actualNonlaborCost;
    }

    public PrimaveraTaskProperties actualMaterialCost(BigDecimal actualMaterialCost) {
        this.actualMaterialCost = actualMaterialCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of actual material cost.             ")
    public BigDecimal getActualMaterialCost() {
        return this.actualMaterialCost;
    }

    public void setActualMaterialCost(BigDecimal actualMaterialCost) {
        this.actualMaterialCost = actualMaterialCost;
    }

    public PrimaveraTaskProperties actualExpenseCost(BigDecimal actualExpenseCost) {
        this.actualExpenseCost = actualExpenseCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of actual expense cost.")
    public BigDecimal getActualExpenseCost() {
        return this.actualExpenseCost;
    }

    public void setActualExpenseCost(BigDecimal actualExpenseCost) {
        this.actualExpenseCost = actualExpenseCost;
    }

    public PrimaveraTaskProperties remainingExpenseCost(BigDecimal remainingExpenseCost) {
        this.remainingExpenseCost = remainingExpenseCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of remaining expense cost.")
    public BigDecimal getRemainingExpenseCost() {
        return this.remainingExpenseCost;
    }

    public void setRemainingExpenseCost(BigDecimal remainingExpenseCost) {
        this.remainingExpenseCost = remainingExpenseCost;
    }

    public PrimaveraTaskProperties actualTotalCost(BigDecimal actualTotalCost) {
        this.actualTotalCost = actualTotalCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the total value of actual costs.")
    public BigDecimal getActualTotalCost() {
        return this.actualTotalCost;
    }

    public void setActualTotalCost(BigDecimal actualTotalCost) {
        this.actualTotalCost = actualTotalCost;
    }

    public PrimaveraTaskProperties budgetedTotalCost(BigDecimal budgetedTotalCost) {
        this.budgetedTotalCost = budgetedTotalCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the total value of budgeted (or planned) costs.")
    public BigDecimal getBudgetedTotalCost() {
        return this.budgetedTotalCost;
    }

    public void setBudgetedTotalCost(BigDecimal budgetedTotalCost) {
        this.budgetedTotalCost = budgetedTotalCost;
    }

    public PrimaveraTaskProperties budgetedLaborCost(BigDecimal budgetedLaborCost) {
        this.budgetedLaborCost = budgetedLaborCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of budgeted (or planned) labor cost.")
    public BigDecimal getBudgetedLaborCost() {
        return this.budgetedLaborCost;
    }

    public void setBudgetedLaborCost(BigDecimal budgetedLaborCost) {
        this.budgetedLaborCost = budgetedLaborCost;
    }

    public PrimaveraTaskProperties budgetedNonlaborCost(BigDecimal budgetedNonlaborCost) {
        this.budgetedNonlaborCost = budgetedNonlaborCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of budgeted (or planned) non labor cost.")
    public BigDecimal getBudgetedNonlaborCost() {
        return this.budgetedNonlaborCost;
    }

    public void setBudgetedNonlaborCost(BigDecimal budgetedNonlaborCost) {
        this.budgetedNonlaborCost = budgetedNonlaborCost;
    }

    public PrimaveraTaskProperties budgetedMaterialCost(BigDecimal budgetedMaterialCost) {
        this.budgetedMaterialCost = budgetedMaterialCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of of budgeted (or planned) material cost.")
    public BigDecimal getBudgetedMaterialCost() {
        return this.budgetedMaterialCost;
    }

    public void setBudgetedMaterialCost(BigDecimal budgetedMaterialCost) {
        this.budgetedMaterialCost = budgetedMaterialCost;
    }

    public PrimaveraTaskProperties budgetedExpenseCost(BigDecimal budgetedExpenseCost) {
        this.budgetedExpenseCost = budgetedExpenseCost;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the value of budgeted (or planned) expense cost.")
    public BigDecimal getBudgetedExpenseCost() {
        return this.budgetedExpenseCost;
    }

    public void setBudgetedExpenseCost(BigDecimal budgetedExpenseCost) {
        this.budgetedExpenseCost = budgetedExpenseCost;
    }

    public PrimaveraTaskProperties primaryConstraintType(PrimaveraConstraintType primaryConstraintType) {
        this.primaryConstraintType = primaryConstraintType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets a type of primary constraint.")
    public PrimaveraConstraintType getPrimaryConstraintType() {
        return this.primaryConstraintType;
    }

    public void setPrimaryConstraintType(PrimaveraConstraintType primaryConstraintType) {
        this.primaryConstraintType = primaryConstraintType;
    }

    public PrimaveraTaskProperties primaryConstraintDate(OffsetDateTime primaryConstraintDate) {
        this.primaryConstraintDate = primaryConstraintDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the date of primary constraint.")
    public OffsetDateTime getPrimaryConstraintDate() {
        return this.primaryConstraintDate;
    }

    public void setPrimaryConstraintDate(OffsetDateTime primaryConstraintDate) {
        this.primaryConstraintDate = primaryConstraintDate;
    }

    public PrimaveraTaskProperties secondaryConstraintType(PrimaveraConstraintType secondaryConstraintType) {
        this.secondaryConstraintType = secondaryConstraintType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets a type of secondary constraint.")
    public PrimaveraConstraintType getSecondaryConstraintType() {
        return this.secondaryConstraintType;
    }

    public void setSecondaryConstraintType(PrimaveraConstraintType secondaryConstraintType) {
        this.secondaryConstraintType = secondaryConstraintType;
    }

    public PrimaveraTaskProperties secondaryConstraintDate(OffsetDateTime secondaryConstraintDate) {
        this.secondaryConstraintDate = secondaryConstraintDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets the date of secondary constraint.")
    public OffsetDateTime getSecondaryConstraintDate() {
        return this.secondaryConstraintDate;
    }

    public void setSecondaryConstraintDate(OffsetDateTime secondaryConstraintDate) {
        this.secondaryConstraintDate = secondaryConstraintDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimaveraTaskProperties primaveraTaskProperties = (PrimaveraTaskProperties)o;
        return Objects.equals(this.sequenceNumber, primaveraTaskProperties.sequenceNumber) && Objects.equals(this.activityId, primaveraTaskProperties.activityId) && Objects.equals(this.remainingEarlyFinish, primaveraTaskProperties.remainingEarlyFinish) && Objects.equals(this.remainingEarlyStart, primaveraTaskProperties.remainingEarlyStart) && Objects.equals(this.remainingLateStart, primaveraTaskProperties.remainingLateStart) && Objects.equals(this.remainingLateFinish, primaveraTaskProperties.remainingLateFinish) && Objects.equals(this.rawDurationType, primaveraTaskProperties.rawDurationType) && Objects.equals(this.rawActivityType, primaveraTaskProperties.rawActivityType) && Objects.equals(this.rawCompletePercentType, primaveraTaskProperties.rawCompletePercentType) && Objects.equals(this.rawStatus, primaveraTaskProperties.rawStatus) && Objects.equals(this.durationPercentComplete, primaveraTaskProperties.durationPercentComplete) && Objects.equals(this.physicalPercentComplete, primaveraTaskProperties.physicalPercentComplete) && Objects.equals(this.actualNonLaborUnits, primaveraTaskProperties.actualNonLaborUnits) && Objects.equals(this.actualLaborUnits, primaveraTaskProperties.actualLaborUnits) && Objects.equals(this.unitsPercentComplete, primaveraTaskProperties.unitsPercentComplete) && Objects.equals(this.remainingLaborUnits, primaveraTaskProperties.remainingLaborUnits) && Objects.equals(this.remainingNonLaborUnits, primaveraTaskProperties.remainingNonLaborUnits) && Objects.equals((Object)this.durationType, (Object)primaveraTaskProperties.durationType) && Objects.equals((Object)this.activityType, (Object)primaveraTaskProperties.activityType) && Objects.equals((Object)this.percentCompleteType, (Object)primaveraTaskProperties.percentCompleteType) && Objects.equals(this.actualLaborCost, primaveraTaskProperties.actualLaborCost) && Objects.equals(this.actualNonlaborCost, primaveraTaskProperties.actualNonlaborCost) && Objects.equals(this.actualMaterialCost, primaveraTaskProperties.actualMaterialCost) && Objects.equals(this.actualExpenseCost, primaveraTaskProperties.actualExpenseCost) && Objects.equals(this.remainingExpenseCost, primaveraTaskProperties.remainingExpenseCost) && Objects.equals(this.actualTotalCost, primaveraTaskProperties.actualTotalCost) && Objects.equals(this.budgetedTotalCost, primaveraTaskProperties.budgetedTotalCost) && Objects.equals(this.budgetedLaborCost, primaveraTaskProperties.budgetedLaborCost) && Objects.equals(this.budgetedNonlaborCost, primaveraTaskProperties.budgetedNonlaborCost) && Objects.equals(this.budgetedMaterialCost, primaveraTaskProperties.budgetedMaterialCost) && Objects.equals(this.budgetedExpenseCost, primaveraTaskProperties.budgetedExpenseCost) && Objects.equals((Object)this.primaryConstraintType, (Object)primaveraTaskProperties.primaryConstraintType) && Objects.equals(this.primaryConstraintDate, primaveraTaskProperties.primaryConstraintDate) && Objects.equals((Object)this.secondaryConstraintType, (Object)primaveraTaskProperties.secondaryConstraintType) && Objects.equals(this.secondaryConstraintDate, primaveraTaskProperties.secondaryConstraintDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sequenceNumber, this.activityId, this.remainingEarlyFinish, this.remainingEarlyStart, this.remainingLateStart, this.remainingLateFinish, this.rawDurationType, this.rawActivityType, this.rawCompletePercentType, this.rawStatus, this.durationPercentComplete, this.physicalPercentComplete, this.actualNonLaborUnits, this.actualLaborUnits, this.unitsPercentComplete, this.remainingLaborUnits, this.remainingNonLaborUnits, this.durationType, this.activityType, this.percentCompleteType, this.actualLaborCost, this.actualNonlaborCost, this.actualMaterialCost, this.actualExpenseCost, this.remainingExpenseCost, this.actualTotalCost, this.budgetedTotalCost, this.budgetedLaborCost, this.budgetedNonlaborCost, this.budgetedMaterialCost, this.budgetedExpenseCost, this.primaryConstraintType, this.primaryConstraintDate, this.secondaryConstraintType, this.secondaryConstraintDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrimaveraTaskProperties {\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    remainingEarlyFinish: ").append(this.toIndentedString(this.remainingEarlyFinish)).append("\n");
        sb.append("    remainingEarlyStart: ").append(this.toIndentedString(this.remainingEarlyStart)).append("\n");
        sb.append("    remainingLateStart: ").append(this.toIndentedString(this.remainingLateStart)).append("\n");
        sb.append("    remainingLateFinish: ").append(this.toIndentedString(this.remainingLateFinish)).append("\n");
        sb.append("    rawDurationType: ").append(this.toIndentedString(this.rawDurationType)).append("\n");
        sb.append("    rawActivityType: ").append(this.toIndentedString(this.rawActivityType)).append("\n");
        sb.append("    rawCompletePercentType: ").append(this.toIndentedString(this.rawCompletePercentType)).append("\n");
        sb.append("    rawStatus: ").append(this.toIndentedString(this.rawStatus)).append("\n");
        sb.append("    durationPercentComplete: ").append(this.toIndentedString(this.durationPercentComplete)).append("\n");
        sb.append("    physicalPercentComplete: ").append(this.toIndentedString(this.physicalPercentComplete)).append("\n");
        sb.append("    actualNonLaborUnits: ").append(this.toIndentedString(this.actualNonLaborUnits)).append("\n");
        sb.append("    actualLaborUnits: ").append(this.toIndentedString(this.actualLaborUnits)).append("\n");
        sb.append("    unitsPercentComplete: ").append(this.toIndentedString(this.unitsPercentComplete)).append("\n");
        sb.append("    remainingLaborUnits: ").append(this.toIndentedString(this.remainingLaborUnits)).append("\n");
        sb.append("    remainingNonLaborUnits: ").append(this.toIndentedString(this.remainingNonLaborUnits)).append("\n");
        sb.append("    durationType: ").append(this.toIndentedString((Object)this.durationType)).append("\n");
        sb.append("    activityType: ").append(this.toIndentedString((Object)this.activityType)).append("\n");
        sb.append("    percentCompleteType: ").append(this.toIndentedString((Object)this.percentCompleteType)).append("\n");
        sb.append("    actualLaborCost: ").append(this.toIndentedString(this.actualLaborCost)).append("\n");
        sb.append("    actualNonlaborCost: ").append(this.toIndentedString(this.actualNonlaborCost)).append("\n");
        sb.append("    actualMaterialCost: ").append(this.toIndentedString(this.actualMaterialCost)).append("\n");
        sb.append("    actualExpenseCost: ").append(this.toIndentedString(this.actualExpenseCost)).append("\n");
        sb.append("    remainingExpenseCost: ").append(this.toIndentedString(this.remainingExpenseCost)).append("\n");
        sb.append("    actualTotalCost: ").append(this.toIndentedString(this.actualTotalCost)).append("\n");
        sb.append("    budgetedTotalCost: ").append(this.toIndentedString(this.budgetedTotalCost)).append("\n");
        sb.append("    budgetedLaborCost: ").append(this.toIndentedString(this.budgetedLaborCost)).append("\n");
        sb.append("    budgetedNonlaborCost: ").append(this.toIndentedString(this.budgetedNonlaborCost)).append("\n");
        sb.append("    budgetedMaterialCost: ").append(this.toIndentedString(this.budgetedMaterialCost)).append("\n");
        sb.append("    budgetedExpenseCost: ").append(this.toIndentedString(this.budgetedExpenseCost)).append("\n");
        sb.append("    primaryConstraintType: ").append(this.toIndentedString((Object)this.primaryConstraintType)).append("\n");
        sb.append("    primaryConstraintDate: ").append(this.toIndentedString(this.primaryConstraintDate)).append("\n");
        sb.append("    secondaryConstraintType: ").append(this.toIndentedString((Object)this.secondaryConstraintType)).append("\n");
        sb.append("    secondaryConstraintDate: ").append(this.toIndentedString(this.secondaryConstraintDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

